/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.wizard.WizardRiderEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WizardEffect
extends AbstractHeiseiRiderEffect {
    @Override
    public void executePlayerSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            WizardRiderEntity.DragonMagicType selectedDragon = WizardRiderEntity.DragonMagicType.values()[level.f_46441_.m_188503_(WizardRiderEntity.DragonMagicType.values().length)];
            WizardRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, this.getAttackDamage(), selectedDragon);
            switch (selectedDragon) {
                case FlameDragon: {
                    this.executeFlameMagic(level, player, direction);
                    break;
                }
                case WaterDragon: {
                    this.executeWaterMagic(level, player, direction);
                    break;
                }
                case HurricaneDragon: {
                    this.executeHurricaneMagic(level, player, direction);
                    break;
                }
                case LandDragon: {
                    this.executeLandMagic(level, player, direction);
                }
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 1));
        }
    }

    private void executeFlameMagic(Level level, Player player, Vec3 direction) {
        Vec3 toEntity;
        EntityHitResult entityHitResult;
        Entity entity;
        Vec3 normalizedDirection = direction.m_82541_();
        double range = 20.0;
        HitResult result = player.m_19907_(range, 0.0f, false);
        if (result instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)result).m_82443_()) instanceof LivingEntity && entity != player && (toEntity = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_()).m_82526_(normalizedDirection) > 0.5) {
            entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 1.2f);
            ((LivingEntity)entity).m_20254_(10);
            level.m_254849_((Entity)player, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.getEffectRange(), Level.ExplosionInteraction.MOB);
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 300, 1));
    }

    private void executeWaterMagic(Level level, Player player, Vec3 direction) {
        Vec3 normalizedDirection = direction.m_82541_();
        double range = 12.0;
        Vec3 start = player.m_20299_(1.0f);
        Vec3 end = start.m_82549_(normalizedDirection.m_82490_(range));
        AABB attackBox = new AABB(start, end).m_82377_(range / 3.0, 3.0, range / 3.0);
        level.m_6443_(LivingEntity.class, attackBox, entity -> {
            if (entity == player) {
                return false;
            }
            Vec3 toEntity = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_();
            return toEntity.m_82526_(normalizedDirection) > 0.5;
        }).forEach(entity -> {
            entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.4f);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 150, 3));
            if (entity.m_6060_()) {
                entity.m_20095_();
            }
        });
        player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 300, 0));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 300, 1));
        int rainRange = 8;
        for (int x = -rainRange; x <= rainRange; ++x) {
            for (int z = -rainRange; z <= rainRange; ++z) {
                for (int y = 5; y >= -3; --y) {
                    BlockPos firePos = player.m_20183_().m_7918_(x, y, z);
                    if (level.m_8055_(firePos).m_60734_() != Blocks.f_50083_) continue;
                    level.m_7471_(firePos, false);
                }
            }
        }
    }

    private void executeHurricaneMagic(Level level, Player player, Vec3 direction) {
        Vec3 normalizedDirection = direction.m_82541_();
        double range = (double)this.getEffectRange() * 2.0;
        Vec3 start = player.m_20182_();
        Vec3 end = start.m_82549_(normalizedDirection.m_82490_(range));
        AABB attackBox = new AABB(start, end).m_82377_(range / 2.0, 4.0, range / 2.0);
        level.m_6443_(LivingEntity.class, attackBox, entity -> {
            if (entity == player) {
                return false;
            }
            Vec3 toEntity = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_();
            return toEntity.m_82526_(normalizedDirection) > 0.5;
        }).forEach(entity -> {
            entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.7f);
            Vec3 knockback = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82490_(4.0);
            entity.m_20256_(entity.m_20184_().m_82549_(knockback));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 100, 2));
        });
        player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 300, 0));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 300, 2));
    }

    private void executeLandMagic(Level level, Player player, Vec3 direction) {
        Vec3 normalizedDirection = direction.m_82541_();
        for (int i = 0; i < 5; ++i) {
            Vec3 pos = player.m_20299_(1.0f).m_82549_(normalizedDirection.m_82490_(2.0 + (double)i));
            BlockPos blockPos = new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_);
            if (!level.m_46859_(blockPos)) continue;
            if (level.f_46441_.m_188499_()) {
                level.m_46597_(blockPos, Blocks.f_50069_.m_49966_());
                continue;
            }
            level.m_46597_(blockPos, Blocks.f_50493_.m_49966_());
        }
        double range = (double)this.getEffectRange() * 1.5;
        Vec3 start = player.m_20182_();
        Vec3 end = start.m_82549_(normalizedDirection.m_82490_(range));
        AABB attackBox = new AABB(start, end).m_82377_(range / 2.0, 3.0, range / 2.0);
        level.m_6443_(LivingEntity.class, attackBox, entity -> {
            if (entity == player) {
                return false;
            }
            Vec3 toEntity = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_();
            return toEntity.m_82526_(normalizedDirection) > 0.5;
        }).forEach(entity -> {
            entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.8f);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 240, 4));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 2));
        });
        player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 300, 2));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 300, 2));
    }

    @Override
    public String getRiderName() {
        return "Wizard";
    }

    @Override
    public String getActivationSoundName() {
        return "Dragon Form!";
    }

    @Override
    public float getAttackDamage() {
        return 70.0f;
    }

    @Override
    public float getEffectRange() {
        return 12.0f;
    }

    @Override
    public double getEnergyCost() {
        return 20.0;
    }

    @Override
    public void executeNonPlayerSpecialAttack(Level level, LivingEntity shooter, Vec3 direction) {
        if (!level.f_46443_) {
            Vec3 normalizedDirection = direction != null && direction.m_82556_() > 0.0 ? direction.m_82541_() : shooter.m_20154_().m_82541_();
            WizardRiderEntity.DragonMagicType selectedDragon = WizardRiderEntity.DragonMagicType.values()[level.f_46441_.m_188503_(WizardRiderEntity.DragonMagicType.values().length)];
            WizardRiderEntity.trySpawnEffect(level, shooter, normalizedDirection, this.getAttackDamage(), selectedDragon);
            shooter.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 1));
            double range = this.getEffectRange();
            Vec3 start = shooter.m_20182_().m_82520_(0.0, (double)shooter.m_20192_() * 0.5, 0.0);
            Vec3 end = start.m_82549_(normalizedDirection.m_82490_(range));
            AABB attackBox = new AABB(start, end).m_82377_(range / 2.0, 3.0, range / 2.0);
            level.m_6443_(LivingEntity.class, attackBox, entity -> {
                if (entity == shooter) {
                    return false;
                }
                Vec3 toEntity = entity.m_20182_().m_82546_(shooter.m_20182_()).m_82541_();
                return toEntity.m_82526_(normalizedDirection) > 0.5;
            }).forEach(entity -> {
                entity.m_6469_(level.m_269111_().m_269333_(shooter), this.getAttackDamage() * 0.5f);
                switch (selectedDragon) {
                    case FlameDragon: {
                        entity.m_20254_(8);
                        break;
                    }
                    case WaterDragon: {
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 2));
                        break;
                    }
                    case HurricaneDragon: {
                        Vec3 knockback = entity.m_20182_().m_82546_(shooter.m_20182_()).m_82541_().m_82490_(2.0);
                        entity.m_20256_(entity.m_20184_().m_82549_(knockback));
                        break;
                    }
                    case LandDragon: {
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 150, 3));
                    }
                }
            });
        }
    }
}

