/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.energy;

import com.xiaoshi2022.kamen_rider_weapon_craft.Item.custom.Heiseisword;
import com.xiaoshi2022.kamen_rider_weapon_craft.network.HeiseiswordEnergySyncPacket;
import com.xiaoshi2022.kamen_rider_weapon_craft.network.NetworkHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;

public class HeiseiswordEnergyManager {
    private static final String TAG_CURRENT_ENERGY = "kamen_rider_craft_heiseisword_current_energy";
    private static final String TAG_MAX_ENERGY = "kamen_rider_craft_heiseisword_max_energy";
    private static final double DEFAULT_MAX_ENERGY = 100.0;
    private static final double ENERGY_REGEN_RATE = 2.0;

    public static double getCurrentEnergy(Player player) {
        if (player == null || player.getPersistentData().m_128469_("PlayerPersisted").m_128469_("kamen_rider_craft_heiseisword_energy").m_128456_()) {
            HeiseiswordEnergyManager.setCurrentEnergy(player, 100.0);
            return 100.0;
        }
        return player.getPersistentData().m_128469_("PlayerPersisted").m_128469_("kamen_rider_craft_heiseisword_energy").m_128459_(TAG_CURRENT_ENERGY);
    }

    public static double getMaxEnergy(Player player) {
        if (player == null || player.getPersistentData().m_128469_("PlayerPersisted").m_128469_("kamen_rider_craft_heiseisword_energy").m_128456_()) {
            return 100.0;
        }
        return player.getPersistentData().m_128469_("PlayerPersisted").m_128469_("kamen_rider_craft_heiseisword_energy").m_128459_(TAG_MAX_ENERGY);
    }

    public static void setCurrentEnergy(Player player, double energy) {
        if (player == null) {
            return;
        }
        double maxEnergy = HeiseiswordEnergyManager.getMaxEnergy(player);
        energy = Math.max(0.0, Math.min(energy, maxEnergy));
        CompoundTag persistedData = player.getPersistentData().m_128469_("PlayerPersisted");
        CompoundTag energyData = persistedData.m_128469_("kamen_rider_craft_heiseisword_energy");
        energyData.m_128347_(TAG_CURRENT_ENERGY, energy);
        energyData.m_128347_(TAG_MAX_ENERGY, maxEnergy);
        persistedData.m_128365_("kamen_rider_craft_heiseisword_energy", (Tag)energyData);
        player.getPersistentData().m_128365_("PlayerPersisted", (Tag)persistedData);
        HeiseiswordEnergyManager.syncEnergyToClient(player);
    }

    public static void setMaxEnergy(Player player, double maxEnergy) {
        if (player == null) {
            return;
        }
        maxEnergy = Math.max(1.0, maxEnergy);
        CompoundTag persistedData = player.getPersistentData().m_128469_("PlayerPersisted");
        CompoundTag energyData = persistedData.m_128469_("kamen_rider_craft_heiseisword_energy");
        double currentEnergy = Math.min(energyData.m_128459_(TAG_CURRENT_ENERGY), maxEnergy);
        energyData.m_128347_(TAG_CURRENT_ENERGY, currentEnergy);
        energyData.m_128347_(TAG_MAX_ENERGY, maxEnergy);
        persistedData.m_128365_("kamen_rider_craft_heiseisword_energy", (Tag)energyData);
        player.getPersistentData().m_128365_("PlayerPersisted", (Tag)persistedData);
        HeiseiswordEnergyManager.syncEnergyToClient(player);
    }

    public static boolean canUseEnergy(Player player, double cost) {
        return HeiseiswordEnergyManager.getCurrentEnergy(player) >= cost;
    }

    public static boolean consumeEnergy(Player player, double cost) {
        if (player == null) {
            return false;
        }
        if (HeiseiswordEnergyManager.getCurrentEnergy(player) >= cost) {
            if (!player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
                HeiseiswordEnergyManager.setCurrentEnergy(player, HeiseiswordEnergyManager.getCurrentEnergy(player) - cost);
            }
            return true;
        }
        return false;
    }

    public static void recoverEnergy(Player player, double amount) {
        if (player == null) {
            return;
        }
        if (!player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            HeiseiswordEnergyManager.setCurrentEnergy(player, HeiseiswordEnergyManager.getCurrentEnergy(player) + amount);
        }
    }

    private static void syncEnergyToClient(Player player) {
        if (player != null && !player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            double currentEnergy = HeiseiswordEnergyManager.getCurrentEnergy(player);
            double maxEnergy = HeiseiswordEnergyManager.getMaxEnergy(player);
            NetworkHandler.INSTANCE.sendTo((Object)new HeiseiswordEnergySyncPacket(player, currentEnergy, maxEnergy), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void recoverEnergyByDamage(Player player, float damage) {
        if (player == null) {
            return;
        }
        double recoveryAmount = (double)damage * 0.25;
        HeiseiswordEnergyManager.recoverEnergy(player, recoveryAmount);
    }

    public static void updateEnergyRegen(Player player) {
        if (player == null || player.m_7500_()) {
            return;
        }
        if (player.m_21205_().m_41720_() instanceof Heiseisword) {
            HeiseiswordEnergyManager.recoverEnergy(player, 2.0);
        }
    }

    public static void resetEnergy(Player player) {
        HeiseiswordEnergyManager.setCurrentEnergy(player, HeiseiswordEnergyManager.getMaxEnergy(player));
    }
}

