/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.build;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BuildRiderEntity
extends Projectile
implements GeoEntity {
    private static final RawAnimation MOVE_ANIMATION = RawAnimation.begin().thenPlay("move");
    private static final RawAnimation HIT_ANIMATION = RawAnimation.begin().thenPlay("attack.hit");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int lifetime = 0;
    private static final int MAX_LIFETIME = 100;
    private Vec3 attackDirection;
    private UUID ownerUUID = null;
    private static final float TRIGGER_CHANCE = 0.3f;
    private static final EntityDataAccessor<Boolean> HAS_HIT_ENTITY = SynchedEntityData.m_135353_(BuildRiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(BuildRiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    private boolean hasHitEntity() {
        return (Boolean)this.m_20088_().m_135370_(HAS_HIT_ENTITY);
    }

    private void setHasHitEntity(boolean value) {
        this.m_20088_().m_135381_(HAS_HIT_ENTITY, (Object)value);
    }

    private float getDamage() {
        return ((Float)this.m_20088_().m_135370_(DAMAGE)).floatValue();
    }

    private void setDamage(float value) {
        this.m_20088_().m_135381_(DAMAGE, (Object)Float.valueOf(value));
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
    }

    public boolean isHitEntity() {
        return this.hasHitEntity();
    }

    private BuildRiderEntity(Level level, LivingEntity owner, Vec3 direction, float attackDamage) {
        super((EntityType)ModEntityTypes.BUILD_RIDER_EFFECT.get(), level);
        this.m_5602_((Entity)owner);
        this.f_19794_ = true;
        this.m_146884_(owner.m_146892_().m_82549_(direction.m_82490_(1.0)));
        this.attackDirection = direction;
        this.setDamage(attackDamage);
        this.setOwnerUUID(owner.m_20148_());
        this.m_146922_(owner.m_146908_());
        this.m_146926_(owner.m_146909_());
    }

    public BuildRiderEntity(EntityType<? extends BuildRiderEntity> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
        this.attackDirection = Vec3.f_82478_;
    }

    public static void trySpawnEffect(Level level, LivingEntity owner, Vec3 direction, float attackDamage) {
        if (level.f_46441_.m_188501_() <= 0.3f && !level.f_46443_) {
            BuildRiderEntity effect = new BuildRiderEntity(level, owner, direction, attackDamage);
            level.m_7967_((Entity)effect);
        }
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(HAS_HIT_ENTITY, (Object)false);
        this.m_20088_().m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("OwnerUUID")) {
            this.ownerUUID = compound.m_128342_("OwnerUUID");
        }
        this.setHasHitEntity(compound.m_128471_("HasHitEntity"));
        this.lifetime = compound.m_128451_("Lifetime");
        if (compound.m_128441_("Damage")) {
            this.setDamage(compound.m_128457_("Damage"));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.ownerUUID != null) {
            compound.m_128362_("OwnerUUID", this.ownerUUID);
        }
        compound.m_128379_("HasHitEntity", this.hasHitEntity());
        compound.m_128405_("Lifetime", this.lifetime);
        compound.m_128350_("Damage", this.getDamage());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::animationPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private PlayState animationPredicate(AnimationState<BuildRiderEntity> state) {
        if (this.hasHitEntity()) {
            state.getController().setAnimation(HIT_ANIMATION);
        } else {
            state.getController().setAnimation(MOVE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.lifetime;
        if (this.hasHitEntity()) {
            if (this.lifetime > 40) {
                this.explode();
                this.m_146870_();
            }
            return;
        }
        if (this.lifetime > 100) {
            this.explode();
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().m_5776_()) {
            Vec3 currentPos = this.m_20182_();
            if (this.attackDirection != null) {
                Vec3 newPos = currentPos.m_82549_(this.attackDirection.m_82490_(0.6));
                this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
                this.checkEntityCollision();
            } else {
                this.attackDirection = Vec3.f_82478_;
            }
        }
        this.attractEntities();
    }

    private void checkEntityCollision() {
        block1: {
            if (this.attackDirection == null) {
                this.attackDirection = Vec3.f_82478_;
            }
            AABB boundingBox = this.m_20191_().m_82369_(this.attackDirection.m_82490_(1.0)).m_82400_(1.0);
            List entities = this.m_9236_().m_6443_(LivingEntity.class, boundingBox, entity -> entity != this.getOwner() && entity.m_6084_() && this.canAttack((LivingEntity)entity));
            Iterator iterator = entities.iterator();
            if (!iterator.hasNext()) break block1;
            LivingEntity entity2 = (LivingEntity)iterator.next();
            this.onHitEntity(entity2);
        }
    }

    private void onHitEntity(LivingEntity target) {
        if (this.hasHitEntity()) {
            return;
        }
        this.setHasHitEntity(true);
        float finalDamage = this.getDamage();
        LivingEntity owner = this.getOwner();
        if (owner != null) {
            target.m_6469_(this.m_269291_().m_269299_((Entity)this, owner), finalDamage);
        } else {
            target.m_6469_(this.m_269291_().m_269425_(), finalDamage);
        }
        this.lifetime = 0;
    }

    private boolean canAttack(LivingEntity target) {
        LivingEntity owner = this.getOwner();
        return owner == null || target != owner;
    }

    public LivingEntity getOwner() {
        UUID uuid = this.getOwnerUUID();
        if (uuid == null || this.m_9236_() == null) {
            return null;
        }
        AABB searchArea = this.m_20191_().m_82400_(32.0);
        List entities = this.m_9236_().m_6249_((Entity)this, searchArea, entity -> entity instanceof LivingEntity && entity.m_20148_().equals(uuid));
        if (!entities.isEmpty()) {
            return (LivingEntity)entities.get(0);
        }
        Player owner = this.m_9236_().m_46003_(uuid);
        if (owner instanceof LivingEntity) {
            return (LivingEntity)owner;
        }
        return null;
    }

    private void attractEntities() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        Vec3 center = this.m_20182_();
        AABB searchArea = this.m_20191_().m_82400_(5.0);
        List entities = this.m_9236_().m_6249_((Entity)this, searchArea, entity -> entity instanceof LivingEntity && entity != this.getOwner() && entity.m_6084_() && !(entity instanceof Projectile) && !entity.m_5833_());
        for (Entity entity2 : entities) {
            Vec3 entityPos = entity2.m_20182_();
            Vec3 toCenter = center.m_82546_(entityPos);
            double distance = toCenter.m_82553_();
            if (distance < 0.5) continue;
            Vec3 direction = toCenter.m_82541_();
            double maxDistance = 5.0;
            double minForce = 0.1;
            double maxForce = 0.8;
            double normalizedDistance = distance / maxDistance;
            double force = maxForce * (1.0 - normalizedDistance * normalizedDistance);
            force = Math.max(force, minForce);
            Vec3 attraction = direction.m_82490_(force * 0.3);
            if (entity2 instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity2;
                Vec3 currentMotion = entity2.m_20184_();
                Vec3 newMotion = currentMotion.m_82549_(attraction);
                double maxSpeed = 1.5;
                if (newMotion.m_82553_() > maxSpeed) {
                    newMotion = newMotion.m_82541_().m_82490_(maxSpeed);
                }
                entity2.m_20256_(newMotion);
                livingEntity.f_19864_ = true;
            } else {
                entity2.m_5997_(attraction.f_82479_, attraction.f_82480_, attraction.f_82481_);
            }
            if (force > minForce * 1.5 && (double)this.m_9236_().f_46441_.m_188501_() < 0.3) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123809_, entityPos.f_82479_, entityPos.f_82480_ + (double)entity2.m_20206_() * 0.5, entityPos.f_82481_, direction.f_82479_ * 0.2, direction.f_82480_ * 0.2, direction.f_82481_ * 0.2);
            }
            if (!((double)this.m_9236_().f_46441_.m_188501_() < 0.02)) continue;
            this.m_9236_().m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, SoundEvents.f_11852_, SoundSource.NEUTRAL, 0.3f, 1.5f);
        }
    }

    private void explode() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        Vec3 center = this.m_20182_();
        this.m_9236_().m_254849_((Entity)this, center.f_82479_, center.f_82480_, center.f_82481_, 2.0f, Level.ExplosionInteraction.NONE);
        AABB explosionArea = this.m_20191_().m_82400_(3.0);
        List entities = this.m_9236_().m_6443_(LivingEntity.class, explosionArea, entity -> entity != this.getOwner() && entity.m_6084_());
        for (LivingEntity entity2 : entities) {
            float explosionDamage = this.getDamage() * 0.5f;
            LivingEntity owner = this.getOwner();
            if (owner != null) {
                entity2.m_6469_(this.m_269291_().m_269333_(owner), explosionDamage);
                continue;
            }
            entity2.m_6469_(this.m_269291_().m_269425_(), explosionDamage);
        }
    }
}

