/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.decade;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DecadeRiderEntity
extends Projectile
implements GeoEntity {
    private static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.m_135353_(DecadeRiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation DIMENSION_KICK_ANIMATION = RawAnimation.begin().thenPlay("dcd");
    private int lifeTicks = 0;
    private static final int MAX_LIFE_TICKS = 40;
    private boolean hasDealtDamage = false;
    private static final int DAMAGE_TICK = 10;
    private static final int EXPLOSION_TICK = 30;
    private UUID ownerUUID;

    public DecadeRiderEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    public DecadeRiderEntity(Level level, LivingEntity owner, float damage, Vec3 direction) {
        super((EntityType)ModEntityTypes.DECADE_RIDER.get(), level);
        if (owner != null) {
            this.setOwnerUUID(owner.m_20148_());
        }
        this.setDamage(damage);
        this.m_20256_(direction.m_82541_().m_82490_(2.0));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_DAMAGE, (Object)Float.valueOf(52.0f));
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DATA_DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_DAMAGE)).floatValue();
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.lifeTicks;
        if (this.m_9236_().f_46443_) {
            this.spawnParticles();
        }
        if (!this.m_9236_().f_46443_) {
            if (this.lifeTicks == 10 && !this.hasDealtDamage) {
                this.dealDamageToArea();
                this.hasDealtDamage = true;
            }
            if (this.lifeTicks == 30) {
                this.createExplosion();
            }
        }
        if (this.lifeTicks >= 40) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private void spawnParticles() {
        for (int i = 0; i < 5; ++i) {
            Vec3 pos = this.m_20182_().m_82520_(this.f_19796_.m_188583_() * 0.5, this.f_19796_.m_188583_() * 0.5, this.f_19796_.m_188583_() * 0.5);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    private void dealDamageToArea() {
        AABB damageBox = new AABB(this.m_20182_().f_82479_ - 1.5, this.m_20182_().f_82480_ - 1.0, this.m_20182_().f_82481_ - 1.5, this.m_20182_().f_82479_ + 1.5, this.m_20182_().f_82480_ + 2.0, this.m_20182_().f_82481_ + 5.0);
        damageBox = this.rotateAABB(damageBox, this.m_146908_() * (float)Math.PI / 180.0f);
        List entities = this.m_9236_().m_45976_(LivingEntity.class, damageBox);
        LivingEntity owner = this.getOwner();
        for (LivingEntity entity : entities) {
            if (entity == owner || !entity.m_6084_()) continue;
            entity.m_6469_(this.m_9236_().m_269111_().m_269299_((Entity)this, owner), this.getDamage());
            Vec3 lookVector = this.m_20154_().m_82541_();
            entity.m_5997_(lookVector.f_82479_ * 1.5, 0.5, lookVector.f_82481_ * 1.5);
        }
    }

    private void createExplosion() {
        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, Level.ExplosionInteraction.NONE);
    }

    private AABB rotateAABB(AABB box, float radians) {
        double[][] corners;
        double centerX = (box.f_82288_ + box.f_82291_) / 2.0;
        double centerZ = (box.f_82290_ + box.f_82293_) / 2.0;
        double minX = box.f_82288_ - centerX;
        double maxX = box.f_82291_ - centerX;
        double minZ = box.f_82290_ - centerZ;
        double maxZ = box.f_82293_ - centerZ;
        double sin = Math.sin(radians);
        double cos = Math.cos(radians);
        double newMinX = Double.MAX_VALUE;
        double newMaxX = Double.MIN_VALUE;
        double newMinZ = Double.MAX_VALUE;
        double newMaxZ = Double.MIN_VALUE;
        for (double[] corner : corners = new double[][]{{minX, minZ}, {maxX, minZ}, {minX, maxZ}, {maxX, maxZ}}) {
            double x = corner[0] * cos - corner[1] * sin;
            double z = corner[0] * sin + corner[1] * cos;
            newMinX = Math.min(newMinX, x);
            newMaxX = Math.max(newMaxX, x);
            newMinZ = Math.min(newMinZ, z);
            newMaxZ = Math.max(newMaxZ, z);
        }
        return new AABB(centerX + newMinX, box.f_82289_, centerZ + newMinZ, centerX + newMaxX, box.f_82292_, centerZ + newMaxZ);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Damage", this.getDamage());
        if (this.ownerUUID != null) {
            compound.m_128362_("OwnerUUID", this.ownerUUID);
        }
        compound.m_128405_("LifeTicks", this.lifeTicks);
        compound.m_128379_("HasDealtDamage", this.hasDealtDamage);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setDamage(compound.m_128457_("Damage"));
        if (compound.m_128403_("OwnerUUID")) {
            this.ownerUUID = compound.m_128342_("OwnerUUID");
        }
        this.lifeTicks = compound.m_128451_("LifeTicks");
        this.hasDealtDamage = compound.m_128471_("HasDealtDamage");
    }

    protected boolean m_5603_(Entity entity) {
        return super.m_5603_(entity) && entity != this.getOwner();
    }

    public LivingEntity getOwner() {
        UUID uuid = this.getOwnerUUID();
        if (uuid == null || this.m_9236_() == null) {
            return null;
        }
        AABB searchArea = this.m_20191_().m_82400_(32.0);
        List entities = this.m_9236_().m_6249_((Entity)this, searchArea, entity -> entity instanceof LivingEntity && entity.m_20148_().equals(uuid));
        if (!entities.isEmpty()) {
            return (LivingEntity)entities.get(0);
        }
        Player owner = this.m_9236_().m_46003_(uuid);
        if (owner instanceof LivingEntity) {
            return (LivingEntity)owner;
        }
        return null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "dimension_kick_controller", 0, this::predicate)});
    }

    private <E extends DecadeRiderEntity> PlayState predicate(AnimationState<E> event) {
        event.getController().setAnimation(DIMENSION_KICK_ANIMATION);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static void trySpawnEffect(Level level, LivingEntity owner, Vec3 direction, float damage) {
        if (!level.f_46443_) {
            Vec3 lookVector = owner.m_20154_().m_82541_();
            Vec3 spawnPos = owner.m_20182_().m_82520_(lookVector.f_82479_ * 5.0, (double)owner.m_20192_() * 0.5, lookVector.f_82481_ * 5.0);
            DecadeRiderEntity entity = new DecadeRiderEntity(level, owner, damage, direction);
            entity.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
            entity.m_146922_(owner.m_146908_());
            entity.m_146926_(owner.m_146909_());
            level.m_7967_((Entity)entity);
        }
    }
}

