/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.den_o;

import com.xiaoshi2022.kamen_rider_weapon_craft.Item.custom.Heiseisword;
import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DenOTrainEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final String weaponType;
    private boolean attachedToWeapon = false;
    private Player attachedPlayer = null;
    private Vec3 direction;
    private float damage;
    private float speed = 1.5f;
    private int maxLifeTicks = 100;
    private boolean isContinuous = false;
    private LivingEntity owner;

    public DenOTrainEntity(EntityType<? extends DenOTrainEntity> type, Level level) {
        super(type, level);
        this.weaponType = "Sword";
    }

    public DenOTrainEntity(Level level, LivingEntity shooter, Vec3 direction, float damage, String weaponType) {
        super((EntityType)ModEntityTypes.DEN_O_TRAIN.get(), level);
        this.owner = shooter;
        this.direction = direction;
        this.damage = damage;
        this.weaponType = weaponType;
    }

    public static DenOTrainEntity spawn(ServerLevel level, LivingEntity shooter, Vec3 direction, float damage, String weaponType) {
        Heiseisword heiseisword;
        String denOWeaponType;
        Player player;
        ItemStack mainHand;
        if ("Sword".equals(weaponType)) {
            for (DenOTrainEntity existingEntity : level.m_6443_(DenOTrainEntity.class, shooter.m_20191_().m_82400_(30.0), e -> e.getOwner() == shooter && "Sword".equals(e.getWeaponType()) && !e.isAttachedToWeapon())) {
                existingEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        DenOTrainEntity entity = new DenOTrainEntity((Level)level, shooter, direction, damage, weaponType);
        if (shooter instanceof Player && (mainHand = (player = (Player)shooter).m_21205_()).m_41720_() instanceof Heiseisword && (denOWeaponType = (heiseisword = (Heiseisword)mainHand.m_41720_()).getDenOWeaponType(mainHand)) != null && denOWeaponType.equals(weaponType)) {
            entity.attachToWeapon(player);
            return entity;
        }
        Vec3 startPos = shooter.m_20299_(1.0f).m_82549_(direction.m_82541_().m_82490_(0.5));
        entity.m_6034_(startPos.f_82479_, startPos.f_82480_, startPos.f_82481_);
        level.m_7967_((Entity)entity);
        return entity;
    }

    public void attachToWeapon(Player player) {
        this.attachedToWeapon = true;
        this.attachedPlayer = player;
        this.damage = 0.0f;
        this.speed = 0.0f;
        this.m_20331_(true);
        if (!this.m_9236_().f_46443_) {
            this.m_20115_(6, true);
        }
    }

    public void detachFromWeapon() {
        this.attachedToWeapon = false;
        this.attachedPlayer = null;
        this.m_20331_(false);
        if (!this.m_9236_().f_46443_) {
            this.m_20115_(6, false);
        }
        this.m_146870_();
    }

    private void attackTarget(LivingEntity target) {
        switch (this.weaponType) {
            case "Sword": {
                ItemStack mainHand;
                Item item;
                target.m_6469_(this.m_9236_().m_269111_().m_269390_((Entity)this, (Entity)this.owner), this.damage * 1.2f);
                target.m_6469_(this.m_9236_().m_269111_().m_269390_((Entity)this, (Entity)this.owner), this.damage * 1.2f);
                target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 100, 0));
                LivingEntity livingEntity = this.owner;
                if (!(livingEntity instanceof Player)) break;
                Player player = (Player)livingEntity;
                if (this.m_9236_().f_46443_ || !((item = (mainHand = player.m_21205_()).m_41720_()) instanceof Heiseisword)) break;
                Heiseisword heiseisword = (Heiseisword)item;
                heiseisword.triggerAnimationForPlayer(player, mainHand);
                break;
            }
            case "FishingRod": {
                Item item;
                LivingEntity fishItem;
                Player player;
                LivingEntity mainHand;
                target.m_6469_(this.m_9236_().m_269111_().m_269390_((Entity)this, (Entity)this.owner), this.damage * 0.5f);
                if (target instanceof WaterAnimal) {
                    if (!this.m_9236_().f_46443_ && (mainHand = this.owner) instanceof Player) {
                        player = (Player)mainHand;
                        fishItem = this.getFishItem(target);
                        if (!fishItem.m_41619_()) {
                            if (!player.m_150109_().m_36054_((ItemStack)fishItem)) {
                                player.m_36176_((ItemStack)fishItem, false);
                            }
                            target.m_142687_(Entity.RemovalReason.DISCARDED);
                        }
                    }
                } else {
                    Vec3 pullDir = this.owner.m_20182_().m_82546_(target.m_20182_()).m_82541_();
                    target.m_20256_(target.m_20184_().m_82549_(pullDir.m_82490_(1.5)));
                }
                fishItem = this.owner;
                if (!(fishItem instanceof Player)) break;
                player = (Player)fishItem;
                if (this.m_9236_().f_46443_ || !((item = (mainHand = player.m_21205_()).m_41720_()) instanceof Heiseisword)) break;
                Heiseisword heiseisword = (Heiseisword)item;
                heiseisword.triggerAnimationForPlayer(player, (ItemStack)mainHand);
                break;
            }
            case "Ax": {
                target.m_6469_(this.m_9236_().m_269111_().m_269390_((Entity)this, (Entity)this.owner), this.damage * 1.2f);
                target.m_20254_(3);
                break;
            }
            case "Gun": {
                target.m_6469_(this.m_9236_().m_269111_().m_269390_((Entity)this, (Entity)this.owner), this.damage * 0.4f);
            }
        }
    }

    public String getWeaponType() {
        return this.weaponType;
    }

    public LivingEntity getOwner() {
        return this.owner;
    }

    private ItemStack getFishItem(LivingEntity entity) {
        return new ItemStack((ItemLike)Items.f_42526_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.attachedToWeapon) {
            this.handleAttachedToWeaponTick();
            return;
        }
        if (this.direction != null) {
            this.m_20256_(this.direction.m_82490_((double)this.speed));
            this.m_146884_(this.m_20182_().m_82549_(this.m_20184_()));
        } else {
            this.m_20256_(new Vec3(0.0, 0.1, 0.0));
            this.m_146884_(this.m_20182_().m_82549_(this.m_20184_()));
        }
        if (this.maxLifeTicks-- <= 0 || this.m_20070_() || this.m_20077_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        for (LivingEntity entity : this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(1.5), e -> e != this.owner && e.m_6084_())) {
            this.attackTarget(entity);
            if (this.isContinuous) continue;
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private void handleAttachedToWeaponTick() {
        if (this.attachedPlayer == null || this.attachedPlayer.m_213877_()) {
            this.detachFromWeapon();
            return;
        }
        ItemStack mainHand = this.attachedPlayer.m_21205_();
        if (!(mainHand.m_41720_() instanceof Heiseisword) || !((Heiseisword)mainHand.m_41720_()).hasAttachedEntity(mainHand)) {
            this.detachFromWeapon();
            return;
        }
        if (this.m_9236_().f_46443_) {
            // empty if block
        }
    }

    public boolean isAttachedToWeapon() {
        return this.attachedToWeapon;
    }

    public Player getAttachedPlayer() {
        return this.attachedPlayer;
    }

    protected void m_7378_(CompoundTag p_20052_) {
    }

    protected void m_8097_() {
    }

    protected void m_7380_(CompoundTag tag) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

