/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.drive;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.drive.DriveRiderEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DriveRiderEffect {
    public static void spawnWheelEffect(Level level, LivingEntity owner, Vec3 direction, float attackDamage) {
        DriveRiderEntity.trySpawnEffect(level, owner, direction, attackDamage);
    }

    public static void spawnWheelEffectByRotation(Level level, LivingEntity owner, float yRot, float xRot, float attackDamage) {
        Vec3 direction = DriveRiderEffect.calculateDirectionFromRotations(yRot, xRot);
        DriveRiderEffect.spawnWheelEffect(level, owner, direction, attackDamage);
    }

    public static void spawnWheelEffectByOwnerDirection(Level level, LivingEntity owner, float attackDamage) {
        Vec3 lookVector = owner.m_20252_(1.0f);
        DriveRiderEffect.spawnWheelEffect(level, owner, lookVector, attackDamage);
    }

    private static Vec3 calculateDirectionFromRotations(float yRot, float xRot) {
        float yRadians = (float)Math.toRadians(yRot);
        float xRadians = (float)Math.toRadians(xRot);
        float xComponent = -Mth.m_14031_((float)yRadians) * Mth.m_14089_((float)xRadians);
        float zComponent = Mth.m_14089_((float)yRadians) * Mth.m_14089_((float)xRadians);
        float yComponent = -Mth.m_14031_((float)xRadians);
        return new Vec3((double)xComponent, (double)yComponent, (double)zComponent).m_82541_();
    }

    public static void spawnMultiWheelEffect(Level level, LivingEntity owner, Vec3 baseDirection, float attackDamage, int count, float spreadAngle) {
        if (count <= 1) {
            DriveRiderEffect.spawnWheelEffect(level, owner, baseDirection, attackDamage);
            return;
        }
        float angleIncrement = spreadAngle / (float)(count - 1);
        float startAngle = -spreadAngle / 2.0f;
        for (int i = 0; i < count; ++i) {
            float currentAngle = startAngle + (float)i * angleIncrement;
            Vec3 direction = DriveRiderEffect.rotateVectorAroundY(baseDirection, currentAngle);
            DriveRiderEffect.spawnWheelEffect(level, owner, direction, attackDamage);
        }
    }

    private static Vec3 rotateVectorAroundY(Vec3 vector, float angle) {
        double radians = Math.toRadians(angle);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double x = vector.f_82479_ * cos - vector.f_82481_ * sin;
        double z = vector.f_82479_ * sin + vector.f_82481_ * cos;
        return new Vec3(x, vector.f_82480_, z).m_82541_();
    }
}

