/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.exaid;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ExAidSlashEffectEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation SLASH_ANIMATION = RawAnimation.begin().then("animation.exaid_slash_effect.slash", Animation.LoopType.PLAY_ONCE);
    private Entity owner;
    private int lifetime = 0;
    private static final int MAX_LIFETIME = 120;
    private Entity hitEntity = null;
    private int followTicks = 0;
    private Entity targetEntity = null;
    private static final EntityDataAccessor<Integer> HIT_ENTITY_ID = SynchedEntityData.m_135353_(ExAidSlashEffectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_HIT_ENTITY = SynchedEntityData.m_135353_(ExAidSlashEffectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TARGET_ENTITY_ID = SynchedEntityData.m_135353_(ExAidSlashEffectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_TARGET_ENTITY = SynchedEntityData.m_135353_(ExAidSlashEffectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public void setOwner(Entity owner) {
        this.owner = owner;
    }

    public ExAidSlashEffectEntity(EntityType<? extends ExAidSlashEffectEntity> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
        this.m_20331_(true);
    }

    public ExAidSlashEffectEntity(Level level, Entity owner, Vec3 position, Vec3 direction) {
        super((EntityType)ModEntityTypes.EXAID_SLASH_EFFECT.get(), level);
        this.m_146884_(position);
        double horizontalDistance = Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_);
        float yRot = (float)Math.toDegrees(Math.atan2(-direction.f_82479_, direction.f_82481_));
        float xRot = (float)Math.toDegrees(Math.atan2(direction.f_82480_, horizontalDistance));
        this.m_146922_(yRot);
        this.m_146926_(xRot);
        this.owner = owner;
        this.f_19794_ = true;
        this.m_20331_(true);
    }

    public void m_8119_() {
        super.m_8119_();
        this.checkNearbyPlayers();
        ++this.lifetime;
        if (this.lifetime > 120) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.m_9236_().f_46443_) {
            this.updateHitEntityFromSyncedData();
            this.updateTargetEntityFromSyncedData();
        }
        if (this.targetEntity != null && this.hitEntity == null && !this.targetEntity.m_213877_() && this.targetEntity != this.owner) {
            double randomOffsetX = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 1.0;
            double randomOffsetY = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.8;
            double randomOffsetZ = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 1.0;
            this.m_6034_(this.targetEntity.m_20185_() + randomOffsetX, this.targetEntity.m_20186_() + (double)this.targetEntity.m_20206_() * 0.5 + randomOffsetY, this.targetEntity.m_20189_() + randomOffsetZ);
            ++this.followTicks;
            if (this.followTicks % 3 == 0) {
                this.spawnHitParticles(this.targetEntity);
            }
            if (this.followTicks > 60) {
                this.followTicks = 0;
                Vec3 motionAwayFromOwner = this.getMotionAwayFromOwner();
                this.m_20256_(motionAwayFromOwner);
            }
        } else if (this.hitEntity != null && !this.hitEntity.m_213877_()) {
            if (this.hitEntity == this.owner) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            this.m_6034_(this.hitEntity.m_20185_(), this.hitEntity.m_20186_() + (double)this.hitEntity.m_20206_() * 0.5, this.hitEntity.m_20189_());
            ++this.followTicks;
            if (this.followTicks % 3 == 0) {
                this.spawnHitParticles(this.hitEntity);
            }
            if (this.followTicks > 30) {
                this.hitEntity = null;
                this.followTicks = 0;
                Vec3 motionAwayFromOwner = this.getMotionAwayFromOwner();
                this.m_20256_(motionAwayFromOwner);
            }
        } else {
            Vec3 currentMotion = this.m_20184_();
            if (currentMotion.m_82553_() < 0.5) {
                Vec3 motionAwayFromOwner = this.getMotionAwayFromOwner();
                this.m_20256_(motionAwayFromOwner);
            } else {
                this.m_20256_(currentMotion.m_82541_().m_82490_(0.8).m_82520_((this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.1, 0.02 + this.m_9236_().f_46441_.m_188500_() * 0.05, (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.1));
            }
            this.checkEntityCollision();
        }
    }

    private Vec3 getMotionAwayFromOwner() {
        Vec3 ownerToEffect;
        if (this.owner != null && !this.owner.m_213877_() && (ownerToEffect = this.m_20182_().m_82546_(this.owner.m_20182_())).m_82553_() > 0.1) {
            return ownerToEffect.m_82541_().m_82490_(0.5).m_82520_((this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.3, 0.1 + this.m_9236_().f_46441_.m_188500_() * 0.3, (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.3);
        }
        return new Vec3((this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.5, 0.1 + this.m_9236_().f_46441_.m_188500_() * 0.3, (this.m_9236_().f_46441_.m_188500_() - 0.5) * 0.5);
    }

    public void setTargetEntity(Entity targetEntity) {
        if (targetEntity != null && targetEntity != this.owner) {
            this.targetEntity = targetEntity;
            if (!this.m_9236_().f_46443_) {
                this.syncTargetEntity(targetEntity);
            }
        } else {
            this.targetEntity = null;
            if (!this.m_9236_().f_46443_) {
                this.syncTargetEntity(null);
            }
        }
    }

    private void syncTargetEntity(Entity entity) {
        if (entity != null) {
            this.f_19804_.m_135381_(TARGET_ENTITY_ID, (Object)entity.m_19879_());
            this.f_19804_.m_135381_(HAS_TARGET_ENTITY, (Object)true);
        } else {
            this.f_19804_.m_135381_(TARGET_ENTITY_ID, (Object)0);
            this.f_19804_.m_135381_(HAS_TARGET_ENTITY, (Object)false);
        }
    }

    private void updateTargetEntityFromSyncedData() {
        int entityId;
        if (((Boolean)this.f_19804_.m_135370_(HAS_TARGET_ENTITY)).booleanValue() && (entityId = ((Integer)this.f_19804_.m_135370_(TARGET_ENTITY_ID)).intValue()) > 0) {
            Entity entity = this.m_9236_().m_6815_(entityId);
            if (entity != null && !entity.m_213877_()) {
                this.targetEntity = entity;
            } else {
                this.f_19804_.m_135381_(HAS_TARGET_ENTITY, (Object)false);
                this.f_19804_.m_135381_(TARGET_ENTITY_ID, (Object)0);
                this.targetEntity = null;
            }
        }
    }

    private void checkEntityCollision() {
        if (this.hitEntity == null) {
            if (this.owner != null && (double)this.m_20270_(this.owner) < 3.0) {
                return;
            }
            List nearbyEntities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(2.0), entity -> entity instanceof LivingEntity && entity != this.owner && !entity.m_5833_() && entity.m_6084_());
            for (Entity entity2 : nearbyEntities) {
                LivingEntity livingEntity;
                if (entity2 == this.owner) continue;
                this.hitEntity = entity2;
                this.followTicks = 0;
                if (!this.m_9236_().f_46443_) {
                    this.syncHitEntity(this.hitEntity);
                }
                if (this.m_9236_().f_46443_) {
                    this.spawnHitParticles(entity2);
                }
                this.m_20334_(0.0, 0.0, 0.0);
                if (this.m_9236_().f_46443_ || this.owner == null || !(entity2 instanceof LivingEntity) || (livingEntity = (LivingEntity)entity2) == this.owner) break;
                try {
                    DamageSource damageSource;
                    Entity entity3 = this.owner;
                    if (entity3 instanceof Player) {
                        Player player = (Player)entity3;
                        damageSource = this.m_9236_().m_269111_().m_269075_(player);
                    } else {
                        entity3 = this.owner;
                        if (entity3 instanceof Mob) {
                            Mob mob = (Mob)entity3;
                            damageSource = this.m_9236_().m_269111_().m_269333_((LivingEntity)mob);
                        } else {
                            damageSource = this.m_9236_().m_269111_().m_269425_();
                        }
                    }
                    livingEntity.m_6469_(damageSource, 5.0f);
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 40, 1, false, false));
                }
                catch (ClassCastException e) {
                    livingEntity.m_6469_(this.m_9236_().m_269111_().m_269425_(), 5.0f);
                }
                break;
            }
        }
    }

    private void syncHitEntity(Entity entity) {
        if (entity != null) {
            this.f_19804_.m_135381_(HIT_ENTITY_ID, (Object)entity.m_19879_());
            this.f_19804_.m_135381_(HAS_HIT_ENTITY, (Object)true);
        } else {
            this.f_19804_.m_135381_(HIT_ENTITY_ID, (Object)0);
            this.f_19804_.m_135381_(HAS_HIT_ENTITY, (Object)false);
        }
    }

    private void updateHitEntityFromSyncedData() {
        int entityId;
        if (((Boolean)this.f_19804_.m_135370_(HAS_HIT_ENTITY)).booleanValue() && (entityId = ((Integer)this.f_19804_.m_135370_(HIT_ENTITY_ID)).intValue()) > 0) {
            Entity entity = this.m_9236_().m_6815_(entityId);
            if (entity != null && !entity.m_213877_()) {
                this.hitEntity = entity;
            } else {
                this.f_19804_.m_135381_(HAS_HIT_ENTITY, (Object)false);
                this.f_19804_.m_135381_(HIT_ENTITY_ID, (Object)0);
                this.hitEntity = null;
            }
        }
    }

    private void spawnHitParticles(Entity entity) {
        if (entity == null || entity.m_213877_()) {
            return;
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        this.hitEntity = null;
        this.owner = null;
    }

    private PlayState animationPredicate(AnimationState<ExAidSlashEffectEntity> event) {
        event.getController().setAnimation(SLASH_ANIMATION);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::animationPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(HIT_ENTITY_ID, (Object)0);
        this.f_19804_.m_135372_(HAS_HIT_ENTITY, (Object)false);
        this.f_19804_.m_135372_(TARGET_ENTITY_ID, (Object)0);
        this.f_19804_.m_135372_(HAS_TARGET_ENTITY, (Object)false);
    }

    protected void m_7378_(CompoundTag nbt) {
        this.lifetime = nbt.m_128451_("Lifetime");
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128405_("Lifetime", this.lifetime);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static void spawnEffect(Level level, Entity owner, Vec3 direction) {
        if (!level.f_46443_) {
            Vec3 startPos = owner.m_20299_(1.0f).m_82549_(direction.m_82490_(2.5));
            ExAidSlashEffectEntity effect = new ExAidSlashEffectEntity(level, owner, startPos, direction);
            effect.m_20256_(direction.m_82490_(1.2));
            level.m_7967_((Entity)effect);
        }
    }

    public static void spawnEffectOnTarget(Level level, Entity owner, Entity target) {
        if (!level.f_46443_ && target != null) {
            double x = target.m_20185_();
            double y = target.m_20186_() + (double)target.m_20206_() * 0.5;
            double z = target.m_20189_();
            Vec3 direction = new Vec3(level.f_46441_.m_188500_() - 0.5, level.f_46441_.m_188500_() - 0.5, level.f_46441_.m_188500_() - 0.5).m_82541_();
            ExAidSlashEffectEntity effect = new ExAidSlashEffectEntity(level, owner, new Vec3(x, y, z), direction);
            effect.setTargetEntity(target);
            level.m_7967_((Entity)effect);
        }
    }

    private void checkNearbyPlayers() {
        double distance;
        if (this.owner != null && this.owner.m_6084_() && (distance = (double)this.m_20270_(this.owner)) < 2.0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
    }
}

