/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.fourze;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FourzeRocketEntity
extends Projectile
implements GeoEntity {
    private static final RawAnimation FLY_ANIMATION = RawAnimation.begin().thenPlay("fly");
    private static final RawAnimation EXPLODE_ANIMATION = RawAnimation.begin().thenPlay("explode");
    private int lifetime = 0;
    private static final int MAX_LIFETIME = 100;
    private static final int EXPLODE_ANIMATION_LENGTH = 20;
    private Vec3 attackDirection;
    private LivingEntity trackingTarget = null;
    private int trackingCooldown = 0;
    private static final double MAX_TRACKING_DISTANCE = 20.0;
    private float trackingSpeed = 1.0f;
    private static final float MAX_TRACKING_SPEED = 2.0f;
    private static final float ACCELERATION_RATE = 0.05f;
    private UUID ownerUUID = null;
    private static final EntityDataAccessor<Boolean> IS_EXPLODING = SynchedEntityData.m_135353_(FourzeRocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(FourzeRocketEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    private boolean isExploding() {
        return (Boolean)this.m_20088_().m_135370_(IS_EXPLODING);
    }

    private void setExploding(boolean value) {
        this.m_20088_().m_135381_(IS_EXPLODING, (Object)value);
    }

    private float getDamage() {
        return ((Float)this.m_20088_().m_135370_(DAMAGE)).floatValue();
    }

    private void setDamage(float value) {
        this.m_20088_().m_135381_(DAMAGE, (Object)Float.valueOf(value));
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
    }

    private FourzeRocketEntity(Level level, LivingEntity owner, Vec3 position, Vec3 initialDirection, float damage) {
        super((EntityType)ModEntityTypes.FOURZE_ROCKET.get(), level);
        this.m_5602_((Entity)owner);
        this.setOwnerUUID(owner.m_20148_());
        this.m_146884_(position);
        this.attackDirection = initialDirection.m_82541_();
        this.m_20256_(initialDirection.m_82541_().m_82490_((double)this.trackingSpeed));
        this.setDamage(damage);
        this.f_19794_ = false;
    }

    public FourzeRocketEntity(EntityType<? extends FourzeRocketEntity> type, Level level) {
        super(type, level);
        this.f_19794_ = false;
    }

    public static void spawnRockets(Level level, LivingEntity owner, Vec3 direction, float damage) {
        if (level.f_46443_) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            float spreadAngle = (float)(i - 1) * 5.0f;
            Vec3 spreadDirection = FourzeRocketEntity.rotateVectorAroundY(direction, spreadAngle);
            Vec3 offset = new Vec3((double)(i - 1) * 0.5, 0.3, (double)(i - 1) * 0.5);
            Vec3 spawnPos = owner.m_146892_().m_82549_(direction.m_82541_().m_82490_(1.0)).m_82549_(offset);
            FourzeRocketEntity rocket = new FourzeRocketEntity(level, owner, spawnPos, spreadDirection, damage);
            level.m_7967_((Entity)rocket);
        }
    }

    private static Vec3 rotateVectorAroundY(Vec3 vector, float degrees) {
        double radians = Math.toRadians(degrees);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double x = vector.f_82479_ * cos + vector.f_82481_ * sin;
        double z = vector.f_82481_ * cos - vector.f_82479_ * sin;
        return new Vec3(x, vector.f_82480_, z).m_82541_();
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(IS_EXPLODING, (Object)false);
        this.m_20088_().m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("OwnerUUID")) {
            this.ownerUUID = compound.m_128342_("OwnerUUID");
        }
        this.setExploding(compound.m_128471_("IsExploding"));
        this.lifetime = compound.m_128451_("Lifetime");
        this.trackingSpeed = compound.m_128457_("TrackingSpeed");
        if (compound.m_128441_("Damage")) {
            this.setDamage(compound.m_128457_("Damage"));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.ownerUUID != null) {
            compound.m_128362_("OwnerUUID", this.ownerUUID);
        }
        compound.m_128379_("IsExploding", this.isExploding());
        compound.m_128405_("Lifetime", this.lifetime);
        compound.m_128350_("TrackingSpeed", this.trackingSpeed);
        compound.m_128350_("Damage", this.getDamage());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::animationPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private PlayState animationPredicate(AnimationState<FourzeRocketEntity> state) {
        if (this.isExploding()) {
            state.getController().setAnimation(EXPLODE_ANIMATION);
        } else {
            state.getController().setAnimation(FLY_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.lifetime;
        if (this.isExploding()) {
            if (this.lifetime > 20) {
                this.m_146870_();
            }
            return;
        }
        if (this.lifetime > 100) {
            this.explode();
            return;
        }
        if (this.m_9236_().m_5776_()) {
            this.spawnExhaustParticles();
        }
        if (!this.m_9236_().m_5776_()) {
            this.updateTrackingTarget();
            this.enhancedTrackingMovement();
            this.checkCollision();
        }
    }

    private void updateTrackingTarget() {
        if (this.trackingCooldown > 0) {
            if (this.trackingTarget != null && (!this.trackingTarget.m_6084_() || this.trackingTarget.m_20280_((Entity)this) > 400.0)) {
                this.trackingTarget = null;
            }
            --this.trackingCooldown;
            return;
        }
        LivingEntity owner = this.getOwner();
        LivingEntity nearestTarget = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(20.0), e -> e != owner && e.m_6084_() && this.canAttack((LivingEntity)e)).stream().min(Comparator.comparingDouble(arg_0 -> ((FourzeRocketEntity)this).m_20280_(arg_0))).orElse(null);
        if (nearestTarget != null) {
            this.trackingTarget = nearestTarget;
            this.trackingCooldown = 10;
        }
    }

    private void enhancedTrackingMovement() {
        Vec3 moveVec;
        this.trackingSpeed = Math.min(this.trackingSpeed + 0.05f, 2.0f);
        if (this.trackingTarget != null && this.trackingTarget.m_6084_()) {
            Vec3 targetPos = this.trackingTarget.m_20182_().m_82520_(0.0, (double)(this.trackingTarget.m_20206_() / 2.0f), 0.0);
            Vec3 entityPos = this.m_20182_();
            Vec3 direction = targetPos.m_82546_(entityPos).m_82541_();
            moveVec = direction.m_82490_((double)this.trackingSpeed);
            this.lookAt(targetPos);
        } else {
            moveVec = this.attackDirection != null ? this.attackDirection.m_82490_((double)this.trackingSpeed) : this.m_20184_();
        }
        this.m_20256_(moveVec);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_37283_();
    }

    private void lookAt(Vec3 targetPos) {
        Vec3 entityPos = this.m_20182_();
        double dx = targetPos.f_82479_ - entityPos.f_82479_;
        double dy = targetPos.f_82480_ - entityPos.f_82480_;
        double dz = targetPos.f_82481_ - entityPos.f_82481_;
        double yaw = Math.atan2(dz, dx) * 57.29577951308232 - 90.0;
        double distance = Math.sqrt(dx * dx + dz * dz);
        double pitch = Math.atan2(dy, distance) * 57.29577951308232;
        this.m_146922_((float)yaw);
        this.m_146926_((float)pitch);
        this.m_5618_((float)yaw);
        this.m_5616_((float)yaw);
    }

    private void spawnExhaustParticles() {
        Vec3 motion = this.m_20184_().m_82541_();
        Vec3 exhaustPos = this.m_20182_().m_82546_(motion.m_82490_(0.5));
        for (int i = 0; i < 3; ++i) {
            double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.3;
            double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.3;
            double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.3;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, exhaustPos.f_82479_ + offsetX, exhaustPos.f_82480_ + offsetY, exhaustPos.f_82481_ + offsetZ, -motion.f_82479_ * 0.5, -motion.f_82480_ * 0.5, -motion.f_82481_ * 0.5);
            if (!this.f_19796_.m_188499_()) continue;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, exhaustPos.f_82479_ + offsetX, exhaustPos.f_82480_ + offsetY, exhaustPos.f_82481_ + offsetZ, -motion.f_82479_ * 0.3, -motion.f_82480_ * 0.3, -motion.f_82481_ * 0.3);
        }
    }

    public void m_37283_() {
        Vec3 motion = this.m_20184_();
        if (motion.m_82553_() < 0.01) {
            return;
        }
        double horizontalDistance = Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_);
        float yaw = (float)Math.toDegrees(Math.atan2(-motion.f_82479_, motion.f_82481_));
        float pitch = (float)Math.toDegrees(Math.atan2(-motion.f_82480_, horizontalDistance));
        this.m_146922_(yaw);
        this.m_146926_(pitch);
    }

    private void checkCollision() {
        if (this.trackingTarget != null && this.trackingTarget.m_6084_() && this.m_20191_().m_82381_(this.trackingTarget.m_20191_())) {
            this.explode();
            return;
        }
        if (this.m_9236_().m_8055_(this.m_20183_()).m_280296_()) {
            this.explode();
            return;
        }
    }

    private void explode() {
        if (this.isExploding() || this.m_9236_().m_5776_()) {
            return;
        }
        this.setExploding(true);
        this.lifetime = 0;
        Vec3 center = this.m_20182_();
        float explosionRadius = 2.0f;
        this.m_9236_().m_254849_((Entity)this, center.f_82479_, center.f_82480_, center.f_82481_, explosionRadius, Level.ExplosionInteraction.NONE);
        AABB explosionArea = this.m_20191_().m_82400_((double)explosionRadius);
        List entities = this.m_9236_().m_6443_(LivingEntity.class, explosionArea, entity -> entity != this.getOwner() && entity.m_6084_());
        LivingEntity owner = this.getOwner();
        float explosionDamage = this.getDamage() * 1.2f;
        for (LivingEntity entity2 : entities) {
            double distance = entity2.m_20270_((Entity)this);
            float finalDamage = (float)((double)explosionDamage * (1.0 - distance / ((double)explosionRadius * 2.0)));
            if (!(finalDamage > 0.0f)) continue;
            if (owner != null) {
                entity2.m_6469_(this.m_269291_().m_269333_(owner), finalDamage);
            } else {
                entity2.m_6469_(this.m_269291_().m_269425_(), finalDamage);
            }
            Vec3 knockbackDir = entity2.m_20182_().m_82546_(center).m_82541_();
            entity2.m_5997_(knockbackDir.f_82479_ * 0.5, 0.3, knockbackDir.f_82481_ * 0.5);
        }
        for (int i = 0; i < 30; ++i) {
            double offsetX = (this.f_19796_.m_188500_() - 0.5) * (double)explosionRadius * 2.0;
            double offsetY = (this.f_19796_.m_188500_() - 0.5) * (double)explosionRadius * 2.0;
            double offsetZ = (this.f_19796_.m_188500_() - 0.5) * (double)explosionRadius * 2.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, center.f_82479_ + offsetX, center.f_82480_ + offsetY, center.f_82481_ + offsetZ, 0.0, 0.0, 0.0);
            if (!this.f_19796_.m_188499_()) continue;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, center.f_82479_ + offsetX, center.f_82480_ + offsetY, center.f_82481_ + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    private boolean canAttack(LivingEntity target) {
        LivingEntity owner = this.getOwner();
        return owner == null || target != owner;
    }

    public LivingEntity getOwner() {
        UUID uuid = this.getOwnerUUID();
        if (uuid == null || this.m_9236_() == null) {
            return null;
        }
        AABB searchArea = this.m_20191_().m_82400_(32.0);
        List entities = this.m_9236_().m_6249_((Entity)this, searchArea, entity -> entity instanceof LivingEntity && entity.m_20148_().equals(uuid));
        if (!entities.isEmpty()) {
            return (LivingEntity)entities.get(0);
        }
        Player owner = this.m_9236_().m_46003_(uuid);
        if (owner instanceof LivingEntity) {
            return (LivingEntity)owner;
        }
        return null;
    }
}

