/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.hibiki;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.hibiki.HibikiDrumEffectEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class HibikiRiderEffect {
    public static void spawnDrumEffect(Level level, Entity owner, LivingEntity target) {
        HibikiDrumEffectEntity.spawnEffect(level, owner, target);
    }

    public static boolean canLockTarget(LivingEntity target) {
        if (target == null || target.m_213877_() || target.m_21224_()) {
            return false;
        }
        if (target instanceof Player) {
            return true;
        }
        return true;
    }

    public static double getDrumDamageMultiplier(int level) {
        return 1.0 + (double)(level - 1) * 0.2;
    }

    public static LivingEntity findNearestTarget(Entity owner, double maxDistance) {
        if (owner == null || owner.m_9236_().f_46443_) {
            return null;
        }
        LivingEntity closestTarget = null;
        double closestDistance = maxDistance;
        for (LivingEntity entity : owner.m_9236_().m_45976_(LivingEntity.class, owner.m_20191_().m_82400_(maxDistance))) {
            LivingEntity livingOwner;
            double distance;
            if (entity == owner || !HibikiRiderEffect.canLockTarget(entity) || !((distance = (double)owner.m_20270_((Entity)entity)) < closestDistance)) continue;
            if (owner instanceof LivingEntity && (livingOwner = (LivingEntity)owner).m_142582_((Entity)entity)) {
                closestDistance = distance;
                closestTarget = entity;
                continue;
            }
            closestDistance = distance;
            closestTarget = entity;
        }
        return closestTarget;
    }

    public static boolean isTargetAlreadyLocked(Level level, LivingEntity target) {
        if (target == null) {
            return false;
        }
        for (HibikiDrumEffectEntity drum : level.m_45976_(HibikiDrumEffectEntity.class, target.m_20191_().m_82400_(20.0))) {
            if (drum.getTargetEntity() != target) continue;
            return true;
        }
        return false;
    }

    public static boolean performDrumLockAttack(Entity owner, LivingEntity target) {
        if (owner == null || target == null || owner.m_9236_().f_46443_) {
            return false;
        }
        Level level = owner.m_9236_();
        if (!HibikiRiderEffect.canLockTarget(target)) {
            return false;
        }
        if (HibikiRiderEffect.isTargetAlreadyLocked(level, target)) {
            return false;
        }
        HibikiRiderEffect.spawnDrumEffect(level, owner, target);
        level.m_5594_(null, owner.m_20183_(), SoundEvents.f_12632_, SoundSource.PLAYERS, 1.0f, 0.8f);
        return true;
    }
}

