/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.ooo;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.ooo.OOOGeoEntity;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class OOOGeoEffect {
    public static final String PUTOTYRA = "putotyra";
    private static final double GOLDEN_RATIO = (1.0 + Math.sqrt(5.0)) / 2.0;

    public static void spawnCellMedalSlash(Level level, LivingEntity owner, Vec3 direction, float attackDamage, String coinType) {
        OOOGeoEntity.trySpawnEffect(level, owner, direction, attackDamage, coinType);
    }

    public static void spawnCellMedalSlashByRotation(Level level, LivingEntity owner, float yRot, float xRot, float attackDamage, String coinType) {
        Vec3 direction = OOOGeoEffect.calculateDirectionFromRotations(yRot, xRot);
        OOOGeoEffect.spawnCellMedalSlash(level, owner, direction, attackDamage, coinType);
    }

    public static void spawnCellMedalSlashByOwnerDirection(Level level, LivingEntity owner, float attackDamage, String coinType) {
        Vec3 lookVector = owner.m_20252_(1.0f);
        OOOGeoEffect.spawnCellMedalSlash(level, owner, lookVector, attackDamage, coinType);
    }

    private static Vec3 calculateDirectionFromRotations(float yRot, float xRot) {
        float yRadians = (float)Math.toRadians(yRot);
        float xRadians = (float)Math.toRadians(xRot);
        float xComponent = -Mth.m_14031_((float)yRadians) * Mth.m_14089_((float)xRadians);
        float zComponent = Mth.m_14089_((float)yRadians) * Mth.m_14089_((float)xRadians);
        float yComponent = -Mth.m_14031_((float)xRadians);
        return new Vec3((double)xComponent, (double)yComponent, (double)zComponent).m_82541_();
    }

    public static void spawnCellMedalSwallow(Level level, LivingEntity owner, Vec3 baseDirection, float attackDamage, LivingEntity target) {
        LivingEntity finalTarget = target;
        if (finalTarget == null) {
            finalTarget = OOOGeoEffect.findTargetInDirection(owner, baseDirection, 15.0);
        }
        int count = 12;
        Vec3 playerPos = owner.m_20299_(1.0f);
        OOOGeoEffect.spawnTrackingOrbPattern(level, owner, baseDirection, attackDamage, count, playerPos, finalTarget);
        OOOGeoEffect.spawnExplosiveParticles(level, owner.m_20182_());
    }

    private static void spawnTrackingOrbPattern(Level level, LivingEntity owner, Vec3 baseDirection, float attackDamage, int count, Vec3 playerPos, LivingEntity target) {
        for (int i = 0; i < 12; ++i) {
            double t = (double)i * GOLDEN_RATIO;
            double inclination = Math.acos(1.0 - 2.0 * ((double)i + 0.5) / 12.0);
            double azimuth = Math.PI * 2 * t;
            double x = Math.sin(inclination) * Math.cos(azimuth);
            double y = Math.sin(inclination) * Math.sin(azimuth);
            double z = Math.cos(inclination);
            Vec3 localOffset = new Vec3(x, y, z).m_82541_();
            Vec3 direction = OOOGeoEffect.calculateDirectionWithOffset(baseDirection, localOffset);
            direction = new Vec3(direction.f_82479_ + (level.f_46441_.m_188500_() - 0.5) * 0.1, direction.f_82480_ + (level.f_46441_.m_188500_() - 0.5) * 0.1, direction.f_82481_ + (level.f_46441_.m_188500_() - 0.5) * 0.1).m_82541_();
            OOOGeoEntity.trySpawnEffect(level, owner, direction, attackDamage, PUTOTYRA);
        }
    }

    private static LivingEntity findTargetInDirection(LivingEntity owner, Vec3 direction, double maxDistance) {
        LivingEntity nearestTarget = null;
        double nearestDistance = Double.MAX_VALUE;
        Vec3 start = owner.m_146892_();
        Vec3 end = start.m_82549_(direction.m_82541_().m_82490_(maxDistance));
        double searchRadius = 2.0;
        AABB searchBox = new AABB(Math.min(start.f_82479_, end.f_82479_) - searchRadius, Math.min(start.f_82480_, end.f_82480_) - searchRadius, Math.min(start.f_82481_, end.f_82481_) - searchRadius, Math.max(start.f_82479_, end.f_82479_) + searchRadius, Math.max(start.f_82480_, end.f_82480_) + searchRadius, Math.max(start.f_82481_, end.f_82481_) + searchRadius);
        List entitiesInRange = owner.m_9236_().m_45976_(LivingEntity.class, searchBox);
        for (LivingEntity entity : entitiesInRange) {
            double distance;
            double distanceToLine;
            if (entity == owner || !owner.m_6779_(entity) || !entity.m_6084_() || !((distanceToLine = OOOGeoEffect.distanceToLineSegment(start, end, entity.m_20182_())) <= searchRadius) || !((distance = entity.m_20280_((Entity)owner)) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestTarget = entity;
        }
        return nearestTarget;
    }

    private static double distanceToLineSegment(Vec3 lineStart, Vec3 lineEnd, Vec3 point) {
        Vec3 lineVector = lineEnd.m_82546_(lineStart);
        Vec3 pointVector = point.m_82546_(lineStart);
        double lineLengthSq = lineVector.m_82556_();
        if (lineLengthSq == 0.0) {
            return point.m_82554_(lineStart);
        }
        double t = Math.max(0.0, Math.min(1.0, pointVector.m_82526_(lineVector) / lineLengthSq));
        Vec3 projection = lineStart.m_82549_(lineVector.m_82490_(t));
        return point.m_82554_(projection);
    }

    private static void spawnExplosiveParticles(Level level, Vec3 position) {
    }

    private static Vec3 calculateDirectionWithOffset(Vec3 baseDirection, Vec3 offset) {
        Vec3 normalizedBase = baseDirection.m_82541_();
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        if (Math.abs(normalizedBase.f_82480_) > 0.99) {
            up = new Vec3(1.0, 0.0, 0.0);
        }
        Vec3 right = normalizedBase.m_82537_(up).m_82541_();
        up = right.m_82537_(normalizedBase).m_82541_();
        return right.m_82490_(offset.f_82479_).m_82549_(up.m_82490_(offset.f_82480_)).m_82549_(normalizedBase.m_82490_(offset.f_82481_)).m_82541_();
    }

    private static Vec3 rotateVectorAroundY(Vec3 vector, float angle) {
        double radians = Math.toRadians(angle);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double x = vector.f_82479_ * cos - vector.f_82481_ * sin;
        double z = vector.f_82479_ * sin + vector.f_82481_ * cos;
        return new Vec3(x, vector.f_82480_, z).m_82541_();
    }

    public static void spawnPutotyraCellMedalSwallow(Level level, LivingEntity owner, float attackDamage) {
        Vec3 lookVector = owner.m_20252_(1.0f);
        OOOGeoEffect.spawnCellMedalSwallow(level, owner, lookVector, attackDamage, null);
        if (owner instanceof Player) {
            owner.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 1));
        }
    }
}

