/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.w;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WTornadoEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation SPIN_ANIMATION = RawAnimation.begin().thenLoop("spin");
    private Vec3 targetDirection = Vec3.f_82478_;
    private int lifetime = 0;
    private static final int MAX_LIFETIME = 60;
    private LivingEntity owner = null;

    public WTornadoEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public WTornadoEntity(Level level) {
        super((EntityType)ModEntityTypes.W_TORNADO.get(), level);
    }

    public void setDirection(Vec3 direction) {
        this.targetDirection = direction != null ? direction.m_82541_() : Vec3.f_82478_;
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.lifetime;
        if (this.lifetime >= 60) {
            this.resetAffectedEntitiesGravity();
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.targetDirection != null) {
            double speed = 0.5;
            this.m_20256_(this.targetDirection.m_82490_(speed));
        }
        if (!this.m_9236_().f_46443_) {
            double range = 2.0;
            this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(range), entity -> entity != this.owner).forEach(entity -> {
                entity.m_6469_(this.m_9236_().m_269111_().m_269264_(), 5.0f);
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 1));
                Vec3 moveDirection = this.targetDirection != null && this.targetDirection.m_82556_() > 0.01 ? this.targetDirection : Vec3.f_82478_;
                entity.m_20334_(moveDirection.f_82479_ * 0.5, 0.4, moveDirection.f_82481_ * 0.5);
                entity.f_19789_ = 0.0f;
                entity.m_20242_(true);
                entity.m_20301_(entity.m_6062_());
            });
            this.resetOutOfRangeEntitiesGravity(range);
        } else {
            this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(2.0), entity -> entity != this.owner).forEach(entity -> this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, entity.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 2.0, entity.m_20186_() + this.f_19796_.m_188500_() * 2.0, entity.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 2.0, (this.f_19796_.m_188500_() - 0.5) * 0.5, this.f_19796_.m_188500_() * 0.5, (this.f_19796_.m_188500_() - 0.5) * 0.5));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compoundTag) {
    }

    protected void m_7380_(CompoundTag compoundTag) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "spin_controller", 0, state -> state.setAndContinue(SPIN_ANIMATION))});
    }

    public static void trySpawnTornado(Level level, LivingEntity shooter, Vec3 direction) {
        if (!level.f_46443_) {
            WTornadoEntity tornado = new WTornadoEntity(level);
            tornado.setDirection(direction);
            tornado.setOwner(shooter);
            tornado.m_146884_(shooter.m_146892_().m_82549_(direction.m_82490_(1.0)));
            level.m_7967_((Entity)tornado);
        }
    }

    public static void trySpawnTornado(Level level, Player player, Vec3 direction) {
        WTornadoEntity.trySpawnTornado(level, (LivingEntity)player, direction);
    }

    private void resetOutOfRangeEntitiesGravity(double range) {
        double searchRange = range * 3.0;
        this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(searchRange), entity -> entity != this.owner && entity.m_20068_() && !this.m_20191_().m_82400_(range).m_82390_(entity.m_20182_())).forEach(entity -> {
            if ((double)entity.m_20146_() > (double)entity.m_6062_() * 0.8) {
                entity.m_20242_(false);
                Vec3 motion = entity.m_20184_();
                entity.m_20334_(motion.f_82479_, 0.1, motion.f_82481_);
            }
        });
    }

    private void resetAffectedEntitiesGravity() {
        double searchRange = 5.0;
        this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(searchRange), entity -> entity != this.owner && entity.m_20068_()).forEach(entity -> {
            entity.m_20242_(false);
            Vec3 motion = entity.m_20184_();
            entity.m_20334_(motion.f_82479_, 0.1, motion.f_82481_);
        });
    }
}

