/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.wizard;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WizardRiderEntity
extends Projectile
implements GeoEntity {
    private static final EntityDataAccessor<Integer> DRAGON_MAGIC_TYPE = SynchedEntityData.m_135353_(WizardRiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(WizardRiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final RawAnimation FLAME_DRAGON_ANIMATION = RawAnimation.begin().thenPlay("flamedragon");
    private static final RawAnimation WATER_DRAGON_ANIMATION = RawAnimation.begin().thenPlay("waterdragon");
    private static final RawAnimation HURRICANE_DRAGON_ANIMATION = RawAnimation.begin().thenPlay("hurricanedragon");
    private static final RawAnimation LAND_DRAGON_ANIMATION = RawAnimation.begin().thenPlay("landdragon");
    private int lifeTicks = 80;
    private boolean hasCollided = false;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public DragonMagicType getDragonMagicType() {
        return DragonMagicType.values()[(Integer)this.m_20088_().m_135370_(DRAGON_MAGIC_TYPE)];
    }

    public void setDragonMagicType(DragonMagicType type) {
        this.m_20088_().m_135381_(DRAGON_MAGIC_TYPE, (Object)type.ordinal());
    }

    public float getDamage() {
        return ((Float)this.m_20088_().m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float value) {
        this.m_20088_().m_135381_(DAMAGE, (Object)Float.valueOf(value));
    }

    public WizardRiderEntity(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
    }

    public static void trySpawnEffect(Level level, LivingEntity shooter, Vec3 direction, float damage, DragonMagicType dragonMagicType) {
        if (level.f_46443_) {
            return;
        }
        WizardRiderEntity entity = new WizardRiderEntity((EntityType<? extends Projectile>)((EntityType)ModEntityTypes.WIZARD_EFFECT.get()), level);
        entity.m_5602_((Entity)shooter);
        entity.setDragonMagicType(dragonMagicType);
        entity.setDamage(damage);
        entity.m_146884_(shooter.m_146892_().m_82549_(direction.m_82541_().m_82490_(1.5)));
        entity.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 1.0f, 0.0f);
        level.m_7967_((Entity)entity);
    }

    public void m_8119_() {
        super.m_8119_();
        if (--this.lifeTicks <= 0) {
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().f_46443_ && !this.hasCollided) {
            List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(3.0));
            for (Entity entity : entities) {
                Entity ownerEntity = this.m_19749_();
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity == ownerEntity || ownerEntity != null && entity.m_7307_(ownerEntity)) continue;
                this.hasCollided = true;
                switch (this.getDragonMagicType()) {
                    case FlameDragon: {
                        this.handleFlameDragonEffect(livingEntity);
                        break;
                    }
                    case WaterDragon: {
                        this.handleWaterDragonEffect(livingEntity);
                        break;
                    }
                    case HurricaneDragon: {
                        this.handleHurricaneDragonEffect(livingEntity);
                        break;
                    }
                    case LandDragon: {
                        this.handleLandDragonEffect(livingEntity);
                    }
                }
                this.lifeTicks = Math.min(this.lifeTicks, 20);
                break;
            }
        }
        if (!this.hasCollided) {
            Vec3 deltaMovement = this.m_20184_();
            this.m_20256_(deltaMovement.m_82542_(0.98, 0.98, 0.98));
            this.m_6034_(this.m_20185_() + deltaMovement.f_82479_, this.m_20186_() + deltaMovement.f_82480_, this.m_20189_() + deltaMovement.f_82481_);
        }
    }

    private void handleFlameDragonEffect(LivingEntity target) {
        LivingEntity owner;
        Entity ownerEntity = this.m_19749_();
        LivingEntity livingEntity = owner = ownerEntity instanceof LivingEntity ? (LivingEntity)ownerEntity : null;
        if (owner != null) {
            target.m_6469_(this.m_9236_().m_269111_().m_269299_((Entity)this, owner), this.getDamage());
        } else {
            target.m_6469_(this.m_9236_().m_269111_().m_269425_(), this.getDamage());
        }
        target.m_20254_(8);
        for (int i = 0; i < 3; ++i) {
            SmallFireball fireball;
            if (owner != null) {
                fireball = new SmallFireball(this.m_9236_(), owner, (this.f_19796_.m_188500_() - 0.5) * 0.5, (this.f_19796_.m_188500_() - 0.5) * 0.5, (this.f_19796_.m_188500_() - 0.5) * 0.5);
            } else {
                double motionX = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double motionY = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                double motionZ = (this.f_19796_.m_188500_() - 0.5) * 0.5;
                fireball = new SmallFireball(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), motionX, motionY, motionZ);
            }
            fireball.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
            fireball.m_20334_((target.m_20185_() - this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 2.0) * 0.2, (target.m_20186_() - this.m_20186_() + (this.f_19796_.m_188500_() - 0.5) * 2.0) * 0.2, (target.m_20189_() - this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 2.0) * 0.2);
            this.m_9236_().m_7967_((Entity)fireball);
        }
        AABB area = this.m_20191_().m_82400_(5.0);
        List nearbyEntities = this.m_9236_().m_45933_((Entity)this, area);
        for (Entity entity : nearbyEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity nearbyLiving = (LivingEntity)entity;
            if (entity == this.m_19749_() || entity.m_7307_(this.m_19749_()) || entity == target) continue;
            if (owner != null) {
                nearbyLiving.m_6469_(this.m_9236_().m_269111_().m_269104_((Entity)this, (Entity)owner), this.getDamage() * 0.5f);
            } else {
                nearbyLiving.m_6469_(this.m_9236_().m_269111_().m_269425_(), this.getDamage() * 0.5f);
            }
            nearbyLiving.m_20254_(4);
        }
    }

    private void handleWaterDragonEffect(LivingEntity target) {
        LivingEntity owner;
        Entity ownerEntity = this.m_19749_();
        LivingEntity livingEntity = owner = ownerEntity instanceof LivingEntity ? (LivingEntity)ownerEntity : null;
        if (owner != null) {
            target.m_6469_(this.m_9236_().m_269111_().m_269299_((Entity)this, owner), this.getDamage() * 1.1f);
        } else {
            target.m_6469_(this.m_9236_().m_269111_().m_269425_(), this.getDamage() * 1.1f);
        }
        int freezeRadius = 5;
        BlockPos centerPos = this.m_20183_();
        for (int dx = -freezeRadius; dx <= freezeRadius; ++dx) {
            for (int dy = -freezeRadius; dy <= freezeRadius; ++dy) {
                for (int dz = -freezeRadius; dz <= freezeRadius; ++dz) {
                    BlockPos checkPos = centerPos.m_7918_(dx, dy, dz);
                    if (this.m_9236_().m_8055_(checkPos).m_60734_() != Blocks.f_49990_ && this.m_9236_().m_8055_(checkPos).m_60734_() != Blocks.f_49990_) continue;
                    this.m_9236_().m_46597_(checkPos, Blocks.f_50126_.m_49966_());
                }
            }
        }
        target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 120, 2));
        if (target.m_6060_()) {
            target.m_20095_();
        }
        AABB area = this.m_20191_().m_82400_(4.0);
        List nearbyEntities = this.m_9236_().m_45933_((Entity)this, area);
        for (Entity entity : nearbyEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity nearbyLiving = (LivingEntity)entity;
            if (entity == ownerEntity) continue;
            nearbyLiving.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 80, 1));
            if (!nearbyLiving.m_6060_()) continue;
            nearbyLiving.m_20095_();
        }
    }

    private void handleHurricaneDragonEffect(LivingEntity target) {
        target.m_6469_(this.m_9236_().m_269111_().m_269299_((Entity)this, (LivingEntity)this.m_19749_()), this.getDamage() * 0.8f);
        AABB area = this.m_20191_().m_82400_(12.0);
        List nearbyEntities = this.m_9236_().m_45933_((Entity)this, area);
        Entity ownerEntity = this.m_19749_();
        for (Entity entity2 : nearbyEntities) {
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity livingTarget = (LivingEntity)entity2;
            if (entity2 == ownerEntity) continue;
            livingTarget.m_20334_(livingTarget.m_20184_().m_7096_() * 0.2, 3.0 + this.f_19796_.m_188500_() * 2.0, livingTarget.m_20184_().m_7094_() * 0.2);
            livingTarget.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 60, 2));
            livingTarget.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 100, 1));
            livingTarget.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100, 0));
        }
        Vec3 center = this.m_20182_();
        float explosionRadius = 3.0f;
        this.m_9236_().m_254849_((Entity)this, center.f_82479_, center.f_82480_, center.f_82481_, explosionRadius, Level.ExplosionInteraction.NONE);
        LivingEntity owner = ownerEntity instanceof LivingEntity ? (LivingEntity)ownerEntity : null;
        float explosionDamage = this.getDamage() * 0.5f;
        AABB explosionArea = this.m_20191_().m_82400_((double)explosionRadius);
        List explosionEntities = this.m_9236_().m_6443_(LivingEntity.class, explosionArea, entity -> entity != ownerEntity && entity.m_6084_());
        for (LivingEntity entity3 : explosionEntities) {
            double distance = entity3.m_20270_((Entity)this);
            float finalDamage = (float)((double)explosionDamage * (1.0 - distance / ((double)explosionRadius * 2.0)));
            if (!(finalDamage > 0.0f)) continue;
            if (owner != null) {
                entity3.m_6469_(this.m_9236_().m_269111_().m_269104_((Entity)this, (Entity)owner), finalDamage);
                continue;
            }
            entity3.m_6469_(this.m_9236_().m_269111_().m_269425_(), finalDamage);
        }
    }

    private void handleLandDragonEffect(LivingEntity target) {
        BlockPos wallPos;
        int y;
        LivingEntity owner;
        Entity ownerEntity = this.m_19749_();
        LivingEntity livingEntity = owner = ownerEntity instanceof LivingEntity ? (LivingEntity)ownerEntity : null;
        if (owner != null) {
            target.m_6469_(this.m_9236_().m_269111_().m_269299_((Entity)this, owner), this.getDamage() * 1.3f);
        } else {
            target.m_6469_(this.m_9236_().m_269111_().m_269425_(), this.getDamage() * 1.3f);
        }
        int centerX = (int)target.m_20185_();
        int centerY = (int)Math.floor(target.m_20186_());
        int centerZ = (int)target.m_20189_();
        int wallSize = 4;
        ArrayList<BlockPos> wallBlocks = new ArrayList<BlockPos>();
        for (int x = centerX - wallSize; x <= centerX + wallSize; ++x) {
            for (y = centerY; y <= centerY + 4; ++y) {
                for (int zOffset : new int[]{-wallSize, wallSize}) {
                    wallPos = new BlockPos(x, y, centerZ + zOffset);
                    if (!this.m_9236_().m_46859_(wallPos) && !(this.m_9236_().m_8055_(wallPos).m_60800_((BlockGetter)this.m_9236_(), wallPos) >= 0.0f)) continue;
                    this.m_9236_().m_46597_(wallPos, Blocks.f_50069_.m_49966_());
                    wallBlocks.add(wallPos);
                }
            }
        }
        for (int z = centerZ - wallSize + 1; z <= centerZ + wallSize - 1; ++z) {
            for (y = centerY; y <= centerY + 4; ++y) {
                for (int xOffset : new int[]{-wallSize, wallSize}) {
                    wallPos = new BlockPos(centerX + xOffset, y, z);
                    if (!this.m_9236_().m_46859_(wallPos) && !(this.m_9236_().m_8055_(wallPos).m_60800_((BlockGetter)this.m_9236_(), wallPos) >= 0.0f)) continue;
                    this.m_9236_().m_46597_(wallPos, Blocks.f_50069_.m_49966_());
                    wallBlocks.add(wallPos);
                }
            }
        }
        this.m_9236_().m_7654_().execute(() -> {
            Entity lambdaOwnerEntity = this.m_19749_();
            LivingEntity explosionOwner = lambdaOwnerEntity instanceof LivingEntity ? (LivingEntity)lambdaOwnerEntity : null;
            Explosion explosion = new Explosion(this.m_9236_(), (Entity)explosionOwner, null, null, target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_(), 4.0f, false, Explosion.BlockInteraction.DESTROY);
            explosion.m_46061_();
            explosion.m_46075_(true);
            AABB explosionArea = target.m_20191_().m_82400_(6.0);
            List explosionEntities = this.m_9236_().m_45933_((Entity)target, explosionArea);
            for (Entity explosionTarget : explosionEntities) {
                float explosionDamage;
                if (!(explosionTarget instanceof LivingEntity)) continue;
                LivingEntity livingExplosionTarget = (LivingEntity)explosionTarget;
                double distance = livingExplosionTarget.m_20270_((Entity)target);
                if (distance > 0.0 && (explosionDamage = (float)((double)(this.getDamage() * 0.7f) * (1.0 - distance / 6.0))) > 0.0f) {
                    livingExplosionTarget.m_6469_(this.m_9236_().m_269111_().m_269093_(explosion), explosionDamage);
                }
                livingExplosionTarget.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 120, 2));
                livingExplosionTarget.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 1));
            }
        });
        target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 180, 3));
        target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 1));
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DRAGON_MAGIC_TYPE, (Object)DragonMagicType.FlameDragon.ordinal());
        this.m_20088_().m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("DragonMagicType")) {
            this.setDragonMagicType(DragonMagicType.values()[compound.m_128451_("DragonMagicType")]);
        }
        if (compound.m_128441_("Damage")) {
            this.setDamage(compound.m_128457_("Damage"));
        }
        if (compound.m_128441_("LifeTicks")) {
            this.lifeTicks = compound.m_128451_("LifeTicks");
        }
        if (compound.m_128441_("HasCollided")) {
            this.hasCollided = compound.m_128471_("HasCollided");
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("DragonMagicType", this.getDragonMagicType().ordinal());
        compound.m_128350_("Damage", this.getDamage());
        compound.m_128405_("LifeTicks", this.lifeTicks);
        compound.m_128379_("HasCollided", this.hasCollided);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "dragon_controller", 0, this::animationPredicate)});
    }

    private PlayState animationPredicate(AnimationState<WizardRiderEntity> state) {
        WizardRiderEntity entity = (WizardRiderEntity)state.getAnimatable();
        switch (entity.getDragonMagicType()) {
            case FlameDragon: {
                state.getController().setAnimation(FLAME_DRAGON_ANIMATION);
                break;
            }
            case WaterDragon: {
                state.getController().setAnimation(WATER_DRAGON_ANIMATION);
                break;
            }
            case HurricaneDragon: {
                state.getController().setAnimation(HURRICANE_DRAGON_ANIMATION);
                break;
            }
            case LandDragon: {
                state.getController().setAnimation(LAND_DRAGON_ANIMATION);
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum DragonMagicType {
        FlameDragon,
        WaterDragon,
        HurricaneDragon,
        LandDragon;

    }
}

