/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.Item.client.daidaimaru.entity;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModItems;
import java.util.Collections;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThrownDaidaimaru
extends AbstractArrow
implements ItemSupplier {
    private static final Logger LOGGER = LogManager.getLogger();
    private int damageValue;
    private CompoundTag enchantmentTag;
    private static final float DAMAGE_AMOUNT = 5.0f;
    private static final float BOUNCE_FACTOR = -0.1f;

    public ThrownDaidaimaru(EntityType<? extends ThrownDaidaimaru> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownDaidaimaru(Level level, LivingEntity shooter, ItemStack stack) {
        super((EntityType)ModEntityTypes.THROWN_DAIDAIMARU.get(), shooter, level);
        this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        this.damageValue = stack.m_41773_();
        this.enchantmentTag = new CompoundTag();
        ListTag enchantmentList = new ListTag();
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        for (Map.Entry entry : enchantments.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            int player = (Integer)entry.getValue();
            CompoundTag enchantmentCompound = new CompoundTag();
            enchantmentCompound.m_128359_("id", BuiltInRegistries.f_256876_.m_7981_((Object)enchantment).toString());
            enchantmentCompound.m_128405_("lvl", player);
            enchantmentList.add((Object)enchantmentCompound);
        }
        this.enchantmentTag.m_128365_("Enchantments", (Tag)enchantmentList);
    }

    protected ItemStack m_7941_() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.DAIDAIMARU.get());
        stack.m_41721_(this.damageValue + 1);
        if (this.enchantmentTag != null && this.enchantmentTag.m_128441_("Enchantments")) {
            ListTag enchantmentList = this.enchantmentTag.m_128437_("Enchantments", 10);
            for (int i = 0; i < enchantmentList.size(); ++i) {
                CompoundTag enchantmentCompound = enchantmentList.m_128728_(i);
                String enchantmentId = enchantmentCompound.m_128461_("id");
                int level = enchantmentCompound.m_128451_("lvl");
                Enchantment enchantment = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(new ResourceLocation(enchantmentId));
                if (enchantment == null) continue;
                EnchantmentHelper.m_44865_(Collections.singletonMap(enchantment, level), (ItemStack)stack);
            }
        }
        LOGGER.info("Returning item with damage value: " + this.damageValue + ", Enchantments restored");
        return stack;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Damage", this.damageValue);
        if (this.enchantmentTag != null) {
            tag.m_128365_("Enchantments", (Tag)this.enchantmentTag.m_128437_("Enchantments", 10));
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Damage")) {
            this.damageValue = tag.m_128451_("Damage");
        }
        if (tag.m_128441_("Enchantments")) {
            this.enchantmentTag = tag.m_128469_("Enchantments");
        }
    }

    protected void m_5790_(EntityHitResult result) {
        Entity target = result.m_82443_();
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            float damage = 5.0f;
            if (livingEntity instanceof LivingEntity) {
                damage += EnchantmentHelper.m_44833_((ItemStack)this.m_7846_(), (MobType)livingEntity.m_6336_());
            }
            Entity owner = this.m_19749_();
            DamageSource damageSource = this.m_269291_().m_269525_((Entity)this, (Entity)(owner == null ? this : owner));
            if (livingEntity.m_6469_(damageSource, damage)) {
                if (livingEntity.m_6095_() == EntityType.f_20566_) {
                    return;
                }
                if (owner instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntity, (Entity)owner);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)livingEntity);
                }
                this.m_7761_(livingEntity);
            }
            Vec3 motion = this.m_20184_();
            Vec3 newMotion = new Vec3(motion.f_82479_ * (double)-0.1f, motion.f_82480_ * (double)-0.1f, motion.f_82481_ * (double)-0.1f);
            this.m_20256_(newMotion);
            this.m_20242_(false);
        }
    }

    protected EntityHitResult m_6351_(Vec3 start, Vec3 end) {
        return super.m_6351_(start, end);
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        Vec3 motion = this.m_20184_();
        Vec3 newMotion = new Vec3(motion.f_82479_ * (double)-0.1f, motion.f_82480_ * (double)-0.1f, motion.f_82481_ * (double)-0.1f);
        this.m_20256_(newMotion);
        this.m_20242_(false);
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)ModItems.DAIDAIMARU.get());
    }
}

