/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.Item.custom;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.xiaoshi2022.kamen_rider_weapon_craft.Item.client.sonicarrow.sonicarrowRenderer;
import com.xiaoshi2022.kamen_rider_weapon_craft.Item.prop.client.entity.LaserBeamEntity;
import com.xiaoshi2022.kamen_rider_weapon_craft.network.ServerSound;
import com.xiaoshi2022.kamen_rider_weapon_craft.particle.ModParticles;
import com.xiaoshi2022.kamen_rider_weapon_craft.procedures.PullSounds;
import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModSounds;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;
import software.bernie.geckolib.util.GeckoLibUtil;

@Mod.EventBusSubscriber(modid="kamen_rider_weapon_craft")
public class sonicarrow
extends SwordItem
implements GeoItem {
    private final float meleeDamage;
    private final float attackSpeed;
    private static final UUID ATTACK_DAMAGE_MODIFIER = UUID.randomUUID();
    private static final UUID ATTACK_SPEED_MODIFIER = UUID.randomUUID();
    private static final RawAnimation BOWBLADE = RawAnimation.begin().thenPlay("bowblade");
    private static final RawAnimation PULLBACK = RawAnimation.begin().thenPlay("pullback");
    private static final RawAnimation DRAW = RawAnimation.begin().thenPlay("draw");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final String MODE_KEY = "Mode";

    public sonicarrow(float meleeDamage, float attackSpeed, Item.Properties properties) {
        super((Tier)Tiers.GOLD, (int)meleeDamage, attackSpeed, properties);
        this.meleeDamage = meleeDamage;
        this.attackSpeed = attackSpeed;
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public sonicarrow() {
        this(28.0f, 8.0f, new Item.Properties().m_41487_(1).m_41503_(1500));
    }

    public void switchMode(ItemStack stack, Mode mode) {
        stack.m_41784_().m_128359_(MODE_KEY, mode.name());
        Player player = (Player)stack.m_41609_();
        if (player != null) {
            player.f_36096_.m_38946_();
        }
    }

    public Mode getCurrentMode(ItemStack stack) {
        String name = stack.m_41784_().m_128461_(MODE_KEY);
        try {
            return Mode.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return Mode.DEFAULT;
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128425_(MODE_KEY, 8)) {
            tag.m_128359_(MODE_KEY, Mode.DEFAULT.name());
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private sonicarrowRenderer renderer = null;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new sonicarrowRenderer();
                }
                return this.renderer;
            }
        });
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            Mode mode = this.getCurrentMode(stack);
            ModeConfigMelee cfg = this.getMeleeConfig(mode);
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(ATTACK_DAMAGE_MODIFIER, "Weapon modifier", (double)this.meleeDamage + cfg.damageBonus(), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(ATTACK_SPEED_MODIFIER, "Weapon modifier", (double)(this.attackSpeed + cfg.attackSpeedBonus()), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, e -> e.m_21190_(attacker.m_7655_()));
        if (!target.m_9236_().f_46443_ && attacker instanceof Player) {
            ModeConfigMelee cfg = this.getMeleeConfig(this.getCurrentMode(stack));
            cfg.onHitEffect().accept(target);
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        Level level;
        if (!player.m_9236_().f_46443_ && (level = player.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player.m_217043_().m_188503_(10) == 0) {
                this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "bowblade", "bowblade");
                serverLevel.m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.SLASH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ == EnchantmentCategory.BOW || enchantment.f_44672_ == EnchantmentCategory.WEAPON;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "draw", 20, state -> PlayState.STOP).triggerableAnim("draw", DRAW)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "pullback", 20, state -> PlayState.CONTINUE).triggerableAnim("pullback", PULLBACK)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "bowblade", 20, state -> PlayState.STOP).triggerableAnim("bowblade", BOWBLADE).setSoundKeyframeHandler(state -> {
            Player player = ClientUtils.getClientPlayer();
            if (player != null) {
                player.m_5496_((SoundEvent)ModSounds.SLASH.get(), 1.0f, 1.0f);
            }
        })});
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            player.m_6672_(hand);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "draw", "draw");
                ServerSound.sendToServer(new ServerSound(ServerSound.SoundType.START_STANDBY));
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    ModeConfig getConfig(Mode mode) {
        return switch (mode) {
            case Mode.MELON -> new ModeConfig(12.0, 1.6f, 1, 30, (ParticleOptions)ModParticles.MELON_PARTICLE.get(), (SoundEvent)ModSounds.SONICARROW_SHOOT.get());
            case Mode.LEMON -> new ModeConfig(10.0, 2.4f, 3, 10, (ParticleOptions)ModParticles.LEMON_PARTICLE.get(), (SoundEvent)ModSounds.SONICARROW_SHOOT.get());
            case Mode.CHERRY -> new ModeConfig(11.0, 2.0f, 2, 20, (ParticleOptions)ModParticles.CHERRY_PARTICLE.get(), (SoundEvent)ModSounds.SONICARROW_SHOOT.get());
            case Mode.PEACH -> new ModeConfig(13.0, 1.8f, 1, 25, (ParticleOptions)ModParticles.PEACH_PARTICLE.get(), (SoundEvent)ModSounds.SONICARROW_SHOOT.get());
            default -> new ModeConfig(9.0, 2.0f, 1, 20, (ParticleOptions)ModParticles.AONICX_PARTICLE.get(), (SoundEvent)ModSounds.SONICARROW_SHOOT.get());
        };
    }

    private ModeConfigMelee getMeleeConfig(Mode mode) {
        return switch (mode) {
            case Mode.MELON -> new ModeConfigMelee(8.0, 0.0f, target -> target.m_147240_((double)1.2f, target.m_20185_() - target.m_9236_().m_213780_().m_188500_(), target.m_20189_() - target.m_9236_().m_213780_().m_188500_()));
            case Mode.LEMON -> new ModeConfigMelee(6.0, 1.0f, target -> target.m_6469_(target.m_9236_().m_269111_().m_269075_((Player)target), 1.0f));
            case Mode.CHERRY -> new ModeConfigMelee(7.0, 0.5f, target -> {
                Level patt11696$temp = target.m_9236_();
                if (patt11696$temp instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)patt11696$temp;
                    CompoundTag tag = target.getPersistentData();
                    if (!tag.m_128441_("BleedingTimer")) {
                        tag.m_128405_("BleedingTimer", 60);
                    }
                    if (!tag.m_128471_("BleedingRegistered")) {
                        tag.m_128379_("BleedingRegistered", true);
                        MinecraftForge.EVENT_BUS.register(new Object((LivingEntity)target){
                            final /* synthetic */ LivingEntity val$target;
                            {
                                this.val$target = livingEntity;
                            }

                            @SubscribeEvent
                            public void onServerTick(TickEvent.ServerTickEvent event) {
                                if (event.phase != TickEvent.Phase.END) {
                                    return;
                                }
                                if (this.val$target.m_6084_() && this.val$target.getPersistentData().m_128441_("BleedingTimer")) {
                                    int timer = this.val$target.getPersistentData().m_128451_("BleedingTimer");
                                    if (timer % 10 == 0) {
                                        this.val$target.m_6469_(this.val$target.m_9236_().m_269111_().m_269264_(), 0.5f);
                                    }
                                    this.val$target.getPersistentData().m_128405_("BleedingTimer", timer - 1);
                                    if (timer <= 1) {
                                        this.val$target.getPersistentData().m_128473_("BleedingTimer");
                                        this.val$target.getPersistentData().m_128473_("BleedingRegistered");
                                        MinecraftForge.EVENT_BUS.unregister((Object)this);
                                    }
                                } else {
                                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                                }
                            }
                        });
                    }
                }
            });
            case Mode.PEACH -> new ModeConfigMelee(9.0, 0.2f, target -> {
                LivingEntity attacker = target.m_21188_();
                if (attacker != null && attacker.m_6084_()) {
                    attacker.m_5634_(2.0f);
                }
            });
            default -> new ModeConfigMelee(0.0, 0.0f, t -> {});
        };
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity shooter, int ticksRemaining) {
        Player player;
        block6: {
            block5: {
                if (!(shooter instanceof Player)) break block5;
                player = (Player)shooter;
                if (!level.f_46443_) break block6;
            }
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Mode mode = this.getCurrentMode(stack);
        ModeConfig cfg = this.getConfig(mode);
        player.m_36335_().m_41524_((Item)this, cfg.coolDown());
        float chargeTime = (float)(this.m_8105_(stack) - ticksRemaining) / 20.0f;
        for (int i = 0; i < cfg.burstCount(); ++i) {
            float yaw = player.m_146908_() + ((float)i - (float)cfg.burstCount() / 2.0f) * 2.5f;
            float pitch = player.m_146909_();
            Vec3 look = Vec3.m_82498_((float)pitch, (float)yaw).m_82490_((double)cfg.shootSpeed());
            LaserBeamEntity laser = new LaserBeamEntity(level, (LivingEntity)player, cfg.particle(), cfg.damage(), cfg.shootSound(), chargeTime, stack);
            laser.m_6034_(player.m_20185_(), player.m_20188_(), player.m_20189_());
            laser.shoot(look.f_82479_, look.f_82480_, look.f_82481_);
            level.m_7967_((Entity)laser);
            if (stack.getEnchantmentLevel(Enchantments.f_44990_) > 0) {
                laser.m_20254_(5);
            }
            if (stack.getEnchantmentLevel(Enchantments.f_44988_) <= 0) continue;
            laser.damage += (double)stack.getEnchantmentLevel(Enchantments.f_44988_);
        }
        serverLevel.m_5594_(null, player.m_20183_(), cfg.shootSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
        stack.m_41622_(cfg.burstCount(), (LivingEntity)player, e -> e.m_21190_(player.m_7655_()));
        this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "pullback", "pullback");
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Mode mode = this.getCurrentMode(stack);
        tooltip.add((Component)Component.m_237115_((String)("item.kamen_rider_weapon_craft.sonicarrow.mode." + mode.name().toLowerCase())).m_130940_(ChatFormatting.YELLOW));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ServerSound.isPlayingStandbySound()) {
            for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
                if (!sonicarrow.isHoldingSonicArrow((Player)player)) continue;
                PullSounds.playPullStandbySound(player);
            }
        }
    }

    private static boolean isHoldingSonicArrow(Player player) {
        return player.m_21205_().m_41720_() instanceof sonicarrow || player.m_21206_().m_41720_() instanceof sonicarrow;
    }

    public static enum Mode {
        DEFAULT,
        MELON,
        LEMON,
        CHERRY,
        PEACH;

    }

    record ModeConfigMelee(double damageBonus, float attackSpeedBonus, Consumer<LivingEntity> onHitEffect) {
    }

    record ModeConfig(double damage, float shootSpeed, int burstCount, int coolDown, ParticleOptions particle, SoundEvent shootSound) {
    }
}

