/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.event;

import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ChestLootLoader {
    public static void LootLoad(ResourceLocation id, Consumer<LootPool> addPool) {
        String prefix = "minecraft:chests/";
        String name = id.toString();
        if (name.startsWith(prefix)) {
            String file;
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "simple_dungeon": 
                case "abandoned_mineshaft": 
                case "desert_pyramid": 
                case "spawn_bonus_chest": 
                case "stronghold_corridor": {
                    addPool.accept(ChestLootLoader.getInjectPool());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        ChestLootLoader.LootLoad(event.getName(), lootPool -> event.getTable().addPool(lootPool));
    }

    public static LootPool getInjectPool() {
        return LootPool.m_79043_().m_79076_(ChestLootLoader.getInjectEntry(1)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_79082_();
    }

    private static LootPoolEntryContainer.Builder<?> getInjectEntry(int weight) {
        ResourceLocation customChestLocation = new ResourceLocation("kamen_rider_weapon_craft:chests/xs_loot_table");
        return LootTableReference.m_79776_((ResourceLocation)customChestLocation).m_79707_(weight);
    }
}

