/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.event;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.xiaoshi2022.kamen_rider_weapon_craft.villagers.LockSeedMerchantProfession;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LockSeedMerchantTradesEvent {
    @SubscribeEvent
    public static void registerTrades(VillagerTradesEvent event) {
        if (event.getType() == LockSeedMerchantProfession.LOCKSEED_MERCHANT.get()) {
            JsonObject nbtJson = LockSeedMerchantTradesEvent.readNbtJson();
            List<Item> allItems = ForgeRegistries.ITEMS.getEntries().stream().map(entry -> (Item)entry.getValue()).toList();
            for (Item item : allItems) {
                ItemStack stack = new ItemStack((ItemLike)item);
                if (!LockSeedMerchantTradesEvent.isLockSeedItem(stack, nbtJson)) continue;
                LockSeedMerchantTradesEvent.addLockSeedTrade(event, stack);
                ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)item);
                System.out.println("Added trade for item: " + String.valueOf(registryName) + " with rarity: " + stack.m_41791_().name());
            }
        }
    }

    private static JsonObject readNbtJson() {
        JsonObject jsonObject;
        BufferedReader reader = new BufferedReader(new InputStreamReader(LockSeedMerchantTradesEvent.class.getResourceAsStream("/nbt.json"), "UTF-8"));
        try {
            jsonObject = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return new JsonObject();
            }
        }
        reader.close();
        return jsonObject;
    }

    private static boolean isLockSeedItem(ItemStack stack, JsonObject nbtJson) {
        JsonArray lockseeds = nbtJson.has("lockseeds") ? nbtJson.get("lockseeds").getAsJsonArray() : new JsonArray();
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        for (int i = 0; i < lockseeds.size(); ++i) {
            String itemName = lockseeds.get(i).getAsString();
            if (!registryName.toString().equals(itemName)) continue;
            CompoundTag tag = stack.m_41784_();
            tag.m_128359_("CustomName", "lockseeds");
            return true;
        }
        return false;
    }

    private static void addLockSeedTrade(VillagerTradesEvent event, ItemStack itemStack) {
        ((List)event.getTrades().get(1)).add(new BasicItemListing(new ItemStack((ItemLike)Items.f_42616_, 1), itemStack, 8, 4, 0.05f));
        ((List)event.getTrades().get(2)).add(new BasicItemListing(itemStack, new ItemStack((ItemLike)Items.f_42616_, 1), 8, 4, 0.05f));
    }
}

