/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.network;

import com.xiaoshi2022.kamen_rider_weapon_craft.blocks.client.RiderFusionMachineBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SyncGuiOpenStatePacket {
    private final boolean isGuiOpen;
    private final BlockPos pos;

    public SyncGuiOpenStatePacket(boolean isGuiOpen, BlockPos pos) {
        this.isGuiOpen = isGuiOpen;
        this.pos = pos;
    }

    public static void encode(SyncGuiOpenStatePacket packet, FriendlyByteBuf buffer) {
        buffer.writeBoolean(packet.isGuiOpen);
        buffer.m_130064_(packet.pos);
    }

    public static SyncGuiOpenStatePacket decode(FriendlyByteBuf buffer) {
        boolean isGuiOpen = buffer.readBoolean();
        BlockPos pos = buffer.m_130135_();
        return new SyncGuiOpenStatePacket(isGuiOpen, pos);
    }

    public static void handle(SyncGuiOpenStatePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            BlockEntity blockEntity;
            ClientLevel level;
            if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT && (level = Minecraft.m_91087_().f_91073_) != null && (blockEntity = level.m_7702_(packet.pos)) instanceof RiderFusionMachineBlockEntity) {
                RiderFusionMachineBlockEntity riderFusionMachineBlockEntity = (RiderFusionMachineBlockEntity)blockEntity;
                riderFusionMachineBlockEntity.isGuiOpen = packet.isGuiOpen;
            }
        });
        context.setPacketHandled(true);
    }
}

