/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.network;

import com.xiaoshi2022.kamen_rider_weapon_craft.blocks.client.RiderFusionMachineBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncRecipeDataPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int craftingProgress;
    private final int maxCraftingProgress;
    private final boolean isCrafting;
    private final BlockPos pos;

    public SyncRecipeDataPacket(int craftingProgress, int maxCraftingProgress, boolean isCrafting, BlockPos pos) {
        this.craftingProgress = craftingProgress;
        this.maxCraftingProgress = maxCraftingProgress;
        this.isCrafting = isCrafting;
        this.pos = pos;
        LOGGER.debug("[Network] Created SyncRecipeDataPacket for position: {}, craftingProgress: {}, maxCraftingProgress: {}, isCrafting: {}", (Object)pos, (Object)craftingProgress, (Object)maxCraftingProgress, (Object)isCrafting);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.craftingProgress);
        buf.writeInt(this.maxCraftingProgress);
        buf.writeBoolean(this.isCrafting);
        buf.m_130064_(this.pos);
        LOGGER.debug("[Network] Wrote SyncRecipeDataPacket to buffer for position: {}, craftingProgress: {}, maxCraftingProgress: {}, isCrafting: {}", (Object)this.pos, (Object)this.craftingProgress, (Object)this.maxCraftingProgress, (Object)this.isCrafting);
    }

    public static SyncRecipeDataPacket decode(FriendlyByteBuf buf) {
        int craftingProgress = buf.readInt();
        int maxCraftingProgress = buf.readInt();
        boolean isCrafting = buf.readBoolean();
        BlockPos pos = buf.m_130135_();
        LOGGER.debug("[Network] Read SyncRecipeDataPacket from buffer for position: {}, craftingProgress: {}, maxCraftingProgress: {}, isCrafting: {}", (Object)pos, (Object)craftingProgress, (Object)maxCraftingProgress, (Object)isCrafting);
        return new SyncRecipeDataPacket(craftingProgress, maxCraftingProgress, isCrafting, pos);
    }

    public static void handle(SyncRecipeDataPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            NetworkEvent.Context context = (NetworkEvent.Context)ctx.get();
            if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                SyncRecipeDataPacket.handleClient(packet);
            } else {
                LOGGER.warn("Received SyncRecipeDataPacket in wrong direction: {}", (Object)context.getDirection());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void handleClient(SyncRecipeDataPacket packet) {
        Minecraft client = Minecraft.m_91087_();
        if (client == null) {
            return;
        }
        ClientLevel level = client.f_91073_;
        if (level == null || !level.m_46749_(packet.pos)) {
            LOGGER.debug("Received recipe data for unloaded position: {}", (Object)packet.pos);
            return;
        }
        client.execute(() -> SyncRecipeDataPacket.lambda$handleClient$1((Level)level, packet));
    }

    private static /* synthetic */ void lambda$handleClient$1(Level level, SyncRecipeDataPacket packet) {
        try {
            BlockEntity be = level.m_7702_(packet.pos);
            if (be instanceof RiderFusionMachineBlockEntity) {
                RiderFusionMachineBlockEntity fusionMachine = (RiderFusionMachineBlockEntity)be;
                if (packet.craftingProgress < 0 || packet.craftingProgress > packet.maxCraftingProgress) {
                    LOGGER.error("Invalid crafting progress values for {}: progress={}, max={}", (Object)packet.pos, (Object)packet.craftingProgress, (Object)packet.maxCraftingProgress);
                    return;
                }
                fusionMachine.handleRecipeSync(packet.craftingProgress, packet.maxCraftingProgress, packet.isCrafting);
            } else {
                LOGGER.error("Block entity at position {} is not a RiderFusionMachineBlockEntity", (Object)packet.pos);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error syncing recipe data at {}: {}", (Object)packet.pos, (Object)e.toString());
        }
    }
}

