/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.HeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.AgitoEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.BladeEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.BuildEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.DecadeEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.DenOEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.DriveEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.ExAidEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.FaizEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.FourzeEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.GaimEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.GhostEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.HibikiEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.KabutoEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.KivaEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.KuugaEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.OOOEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.RyukiEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.WEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl.WizardEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.sound.RiderSounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class HeiseiRiderEffectManager {
    private static final Map<String, HeiseiRiderEffect> RIDER_EFFECTS = new HashMap<String, HeiseiRiderEffect>();
    private static final Map<String, SoundEvent> RIDER_NAME_SOUNDS = new HashMap<String, SoundEvent>();
    private static final List<String> RIDER_ORDER = new ArrayList<String>();

    private static void registerRider(String name, HeiseiRiderEffect effect, SoundEvent nameSound) {
        RIDER_EFFECTS.put(name, effect);
        RIDER_NAME_SOUNDS.put(name, nameSound);
        RIDER_ORDER.add(name);
    }

    public static HeiseiRiderEffect getRiderEffect(String name) {
        return RIDER_EFFECTS.get(name);
    }

    public static double getRiderEnergyCost(String name) {
        HeiseiRiderEffect effect = HeiseiRiderEffectManager.getRiderEffect(name);
        if (effect != null) {
            try {
                return effect.getEnergyCost();
            }
            catch (AbstractMethodError e) {
                return 20.0;
            }
        }
        return 20.0;
    }

    public static SoundEvent getRiderNameSound(String name) {
        return RIDER_NAME_SOUNDS.get(name);
    }

    public static List<String> getRiderOrder() {
        return Collections.unmodifiableList(RIDER_ORDER);
    }

    public static void playSelectionSound(Level level, Player player, String riderName) {
        SoundEvent nameSound = HeiseiRiderEffectManager.getRiderNameSound(riderName);
        if (nameSound != null) {
            RiderSounds.playSelectionSound(level, player, nameSound);
        }
    }

    public static void playAttackSound(Level level, Player player, String riderName) {
        SoundEvent nameSound = HeiseiRiderEffectManager.getRiderNameSound(riderName);
        if (nameSound != null) {
            RiderSounds.playAttackSound(level, player, nameSound);
        }
    }

    public static void playScrambleTimeBreakSound(Level level, Player player, List<String> selectedRiders) {
        if (selectedRiders.isEmpty()) {
            return;
        }
        ArrayList<RiderSounds.DelayedSound> sounds = new ArrayList<RiderSounds.DelayedSound>();
        int delay = 0;
        for (String rider : selectedRiders) {
            SoundEvent nameSound = HeiseiRiderEffectManager.getRiderNameSound(rider);
            if (nameSound == null) continue;
            sounds.add(new RiderSounds.DelayedSound(nameSound, delay));
            delay += 10;
        }
        RiderSounds.playDelayedSoundSequence(level, player, sounds);
    }

    public static void playUltimateTimeBreakNameSounds(Level level, Player player, List<String> selectedRiders) {
        ArrayList<RiderSounds.DelayedSound> sounds = new ArrayList<RiderSounds.DelayedSound>();
        int delay = 40;
        for (String rider : selectedRiders) {
            SoundEvent nameSound = HeiseiRiderEffectManager.getRiderNameSound(rider);
            if (nameSound == null) continue;
            sounds.add(new RiderSounds.DelayedSound(nameSound, delay));
            delay += 8;
        }
        RiderSounds.playDelayedSoundSequence(level, player, sounds);
    }

    public static void playUltimateTimeBreakSound(Level level, Player player, List<String> selectedRiders) {
        HeiseiRiderEffectManager.playUltimateTimeBreakNameSounds(level, player, selectedRiders);
    }

    public static void playUltimateFinishSoundSequence(Level level, Player player, List<String> selectedRiders) {
        ArrayList<RiderSounds.DelayedSound> sounds = new ArrayList<RiderSounds.DelayedSound>();
        int delay = 0;
        for (String rider : selectedRiders) {
            SoundEvent nameSound = HeiseiRiderEffectManager.getRiderNameSound(rider);
            if (nameSound == null) continue;
            sounds.add(new RiderSounds.DelayedSound(nameSound, delay));
            delay += 8;
        }
        sounds.add(new RiderSounds.DelayedSound(RiderSounds.ULTIMATE_TIME_BREAK, delay + 20));
        RiderSounds.playDelayedSoundSequence(level, player, sounds);
    }

    public static void playKillSound(Level level, Player player, SoundEvent specialSound) {
        RiderSounds.playKillSound(level, player, specialSound);
    }

    public static void playRiderTimeSound(Level level, Player player) {
        RiderSounds.playSound(level, player, RiderSounds.RIDE_HEI_SABER);
    }

    public static void playFinishTimeSound(Level level, Player player) {
        RiderSounds.playSound(level, player, RiderSounds.FINISH_TIME);
    }

    public static void playUltimateActivationSound(Level level, Player player) {
        RiderSounds.playSound(level, player, RiderSounds.HEY_SAY_RAPID);
    }

    static {
        HeiseiRiderEffectManager.registerRider("Build", new BuildEffect(), RiderSounds.NAME_BUILD);
        HeiseiRiderEffectManager.registerRider("Ex-Aid", new ExAidEffect(), RiderSounds.NAME_EXAID);
        HeiseiRiderEffectManager.registerRider("Ghost", new GhostEffect(), RiderSounds.NAME_GHOST);
        HeiseiRiderEffectManager.registerRider("Drive", new DriveEffect(), RiderSounds.NAME_DRIVE);
        HeiseiRiderEffectManager.registerRider("Gaim", new GaimEffect(), RiderSounds.NAME_GAIM);
        HeiseiRiderEffectManager.registerRider("Wizard", new WizardEffect(), RiderSounds.NAME_WIZARD);
        HeiseiRiderEffectManager.registerRider("Fourze", new FourzeEffect(), RiderSounds.NAME_FOURZE);
        HeiseiRiderEffectManager.registerRider("OOO", new OOOEffect(), RiderSounds.NAME_OOO);
        HeiseiRiderEffectManager.registerRider("W", new WEffect(), RiderSounds.NAME_W);
        HeiseiRiderEffectManager.registerRider("Decade", new DecadeEffect(), RiderSounds.NAME_DECADE);
        HeiseiRiderEffectManager.registerRider("Kiva", new KivaEffect(), RiderSounds.NAME_KIVA);
        HeiseiRiderEffectManager.registerRider("Den-O", new DenOEffect(), RiderSounds.NAME_DEN_O);
        HeiseiRiderEffectManager.registerRider("Kabuto", new KabutoEffect(), RiderSounds.NAME_KABUTO);
        HeiseiRiderEffectManager.registerRider("Hibiki", new HibikiEffect(), RiderSounds.NAME_HIBIKI);
        HeiseiRiderEffectManager.registerRider("Blade", new BladeEffect(), RiderSounds.NAME_BLADE);
        HeiseiRiderEffectManager.registerRider("Faiz", new FaizEffect(), RiderSounds.NAME_FAIZ);
        HeiseiRiderEffectManager.registerRider("Ryuki", new RyukiEffect(), RiderSounds.NAME_RYUKI);
        HeiseiRiderEffectManager.registerRider("Agito", new AgitoEffect(), RiderSounds.NAME_AGITO);
        HeiseiRiderEffectManager.registerRider("Kuuga", new KuugaEffect(), RiderSounds.NAME_KUUGA);
    }
}

