/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import java.util.Random;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DenOEffect
extends AbstractHeiseiRiderEffect {
    private final Random random = new Random();

    @Override
    public void executeSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            DenOForm selectedForm = DenOForm.values()[this.random.nextInt(DenOForm.values().length)];
            switch (selectedForm) {
                case Sword: {
                    this.executeSwordFormAttack(level, player, direction);
                    break;
                }
                case Rod: {
                    this.executeRodFormAttack(level, player, direction);
                    break;
                }
                case Ax: {
                    this.executeAxFormAttack(level, player, direction);
                    break;
                }
                case Gun: {
                    this.executeGunFormAttack(level, player, direction);
                }
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 300, 1));
        }
    }

    private void executeSwordFormAttack(Level level, Player player, Vec3 direction) {
        double reach = 8.0;
        Vec3 start = player.m_20299_(1.0f);
        Vec3 end = start.m_82549_(direction.m_82490_(reach));
        level.m_6443_(LivingEntity.class, new AABB(start, end).m_82400_(1.0), entity -> entity != player).forEach(entity -> {
            entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.6f);
            entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.6f);
        });
    }

    private void executeRodFormAttack(Level level, Player player, Vec3 direction) {
        level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(5.0), entity -> entity != player).forEach(entity -> {
            entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.5f);
            Vec3 knockback = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82490_(1.5);
            entity.m_20256_(entity.m_20184_().m_82549_(knockback));
        });
    }

    private void executeAxFormAttack(Level level, Player player, Vec3 direction) {
        double reach = 6.0;
        Vec3 targetPos = player.m_20299_(1.0f).m_82549_(direction.m_82490_(reach));
        level.m_6443_(LivingEntity.class, new AABB(targetPos, targetPos).m_82400_(2.0), entity -> entity != player).forEach(entity -> {
            entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 1.2f);
            entity.m_20254_(3);
        });
    }

    private void executeGunFormAttack(Level level, Player player, Vec3 direction) {
        for (int i = 0; i < 3; ++i) {
            double spreadX = (level.f_46441_.m_188500_() - 0.5) * 0.2;
            double spreadY = (level.f_46441_.m_188500_() - 0.5) * 0.2;
            double spreadZ = (level.f_46441_.m_188500_() - 0.5) * 0.2;
            Vec3 bulletDir = new Vec3(direction.f_82479_ + spreadX, direction.f_82480_ + spreadY, direction.f_82481_ + spreadZ).m_82541_();
            double bulletReach = 15.0;
            Vec3 bulletStart = player.m_20299_(1.0f);
            Vec3 bulletEnd = bulletStart.m_82549_(bulletDir.m_82490_(bulletReach));
            level.m_6443_(LivingEntity.class, new AABB(bulletStart, bulletEnd).m_82400_(0.5), entity -> entity != player).forEach(entity -> entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.4f));
        }
    }

    @Override
    public String getRiderName() {
        return "Den-O";
    }

    @Override
    public String getActivationSoundName() {
        return "Full Charge!";
    }

    @Override
    public float getAttackDamage() {
        return 48.0f;
    }

    @Override
    public float getEffectRange() {
        return 12.0f;
    }

    private static enum DenOForm {
        Sword,
        Rod,
        Ax,
        Gun;

    }
}

