/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.exaid.ExAidSlashEffectEntity;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ExAidEffect
extends AbstractHeiseiRiderEffect {
    private static final Map<LivingEntity, Integer> DAMAGE_TARGETS = new HashMap<LivingEntity, Integer>();
    private static final int DURATION = 60;
    private static final int DAMAGE_INTERVAL = 10;
    private static final Map<Integer, DelayedEffectInfo> DELAYED_EFFECTS = new HashMap<Integer, DelayedEffectInfo>();
    private static int nextEffectId = 0;

    @Override
    public void executeSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 400, 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 400, 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 2));
            double reach = 8.0;
            Vec3 start = player.m_20299_(1.0f);
            Vec3 end = start.m_82549_(direction.m_82490_(reach));
            Entity hitEntity = this.getTargetEntity(level, player, start, end, reach);
            if (hitEntity instanceof LivingEntity && hitEntity != player) {
                LivingEntity livingEntity = (LivingEntity)hitEntity;
                float initialDamage = this.getAttackDamage() * 0.5f;
                if (livingEntity != player) {
                    boolean bl = livingEntity.m_6469_(level.m_269111_().m_269075_(player), initialDamage);
                }
                this.addToDamageTargets(livingEntity, player);
                this.spawnSlashEffectOnEntity(hitEntity, level, player, direction);
                ExAidSlashEffectEntity.spawnEffectOnTarget(level, (Entity)player, hitEntity);
            } else {
                ExAidSlashEffectEntity.spawnEffect(level, (Entity)player, direction);
            }
        } else {
            try {
                Class<?> effectClass = Class.forName("com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.exaid.ExAidRiderEffect");
                Method method = effectClass.getMethod("spawnSlashEffectByOwnerDirection", Level.class, Player.class);
                method.invoke(null, level, player);
            }
            catch (Exception e) {
                ExAidSlashEffectEntity.spawnEffect(level, (Entity)player, direction);
            }
        }
    }

    private void addToDamageTargets(LivingEntity target, Player player) {
        if (target != player) {
            DAMAGE_TARGETS.put(target, 60);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ExAidEffect.handleDamageTargets();
        ExAidEffect.handleDelayedEffects();
    }

    private static void handleDamageTargets() {
        Iterator<Map.Entry<LivingEntity, Integer>> damageIterator = DAMAGE_TARGETS.entrySet().iterator();
        while (damageIterator.hasNext()) {
            Map.Entry<LivingEntity, Integer> entry = damageIterator.next();
            LivingEntity target = entry.getKey();
            int remainingTicks = entry.getValue() - 1;
            if (target == null || !target.m_6084_() || target.m_213877_()) {
                damageIterator.remove();
                continue;
            }
            if (remainingTicks % 10 == 0) {
                float dotDamage = 5.0f;
                target.m_6469_(target.m_9236_().m_269111_().m_269425_(), dotDamage);
                ExAidEffect.spawnDotEffect(target);
            }
            if (remainingTicks <= 0) {
                damageIterator.remove();
                continue;
            }
            DAMAGE_TARGETS.put(target, remainingTicks);
        }
    }

    private static void handleDelayedEffects() {
        Iterator<Map.Entry<Integer, DelayedEffectInfo>> effectIterator = DELAYED_EFFECTS.entrySet().iterator();
        while (effectIterator.hasNext()) {
            Map.Entry<Integer, DelayedEffectInfo> entry = effectIterator.next();
            DelayedEffectInfo info = entry.getValue();
            if (info.targetEntity == null || !info.targetEntity.m_6084_() || info.targetEntity.m_213877_()) {
                effectIterator.remove();
                continue;
            }
            --info.remainingTicks;
            if (info.remainingTicks <= 0 && info.spawnedEffects < info.totalEffects) {
                ExAidEffect.spawnSingleDelayedEffect(info);
                info.remainingTicks = 3;
            }
            if (info.spawnedEffects < info.totalEffects) continue;
            effectIterator.remove();
        }
    }

    private static void spawnDotEffect(LivingEntity target) {
        Level level = target.m_9236_();
        if (!level.f_46443_ && target != null) {
            double x = target.m_20185_() + (level.f_46441_.m_188500_() - 0.5) * 0.8;
            double y = target.m_20186_() + (double)target.m_20206_() * 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.5;
            double z = target.m_20189_() + (level.f_46441_.m_188500_() - 0.5) * 0.8;
            ExAidSlashEffectEntity effect = new ExAidSlashEffectEntity((EntityType<? extends ExAidSlashEffectEntity>)((EntityType)ModEntityTypes.EXAID_SLASH_EFFECT.get()), level);
            effect.m_6034_(x, y, z);
            effect.m_146922_(level.f_46441_.m_188501_() * 360.0f);
            effect.m_146926_(level.f_46441_.m_188501_() * 360.0f);
            effect.f_19794_ = true;
            effect.m_20331_(true);
            level.m_7967_((Entity)effect);
        }
    }

    private Entity getTargetEntity(Level level, Player player, Vec3 start, Vec3 end, double reach) {
        HitResult result;
        AABB aabb = new AABB(Math.min(start.f_82479_, end.f_82479_) - 1.0, Math.min(start.f_82480_, end.f_82480_) - 1.0, Math.min(start.f_82481_, end.f_82481_) - 1.0, Math.max(start.f_82479_, end.f_82479_) + 1.0, Math.max(start.f_82480_, end.f_82480_) + 1.0, Math.max(start.f_82481_, end.f_82481_) + 1.0);
        List entities = level.m_6249_((Entity)player, aabb, entity -> entity instanceof LivingEntity && !entity.m_5833_() && entity.m_6084_() && entity != player);
        double closestDistance = Double.MAX_VALUE;
        Entity closestEntity = null;
        for (Entity entity2 : entities) {
            double distance;
            Vec3 closestPoint = entity2.m_20191_().m_82371_(start, end).orElse(null);
            if (closestPoint == null || !((distance = start.m_82554_(closestPoint)) <= reach) || !(distance < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity2;
        }
        if (closestEntity == null && (result = player.m_19907_(reach, 0.0f, false)) instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)result;
            return entityHitResult.m_82443_();
        }
        return closestEntity;
    }

    private static void spawnSingleDelayedEffect(DelayedEffectInfo info) {
        if (!info.level.f_46443_ && info.targetEntity != null && info.targetEntity.m_6084_()) {
            double x = info.targetEntity.m_20185_();
            double y = info.targetEntity.m_20186_() + (double)info.targetEntity.m_20206_() * 0.5;
            double z = info.targetEntity.m_20189_();
            Vec3 lookVector = info.direction.m_82541_();
            double radius = (double)Math.max(info.targetEntity.m_20205_(), info.targetEntity.m_20206_()) * 0.6;
            double angle = info.level.f_46441_.m_188500_() * Math.PI * 2.0;
            double heightVariation = info.level.f_46441_.m_188500_() * 0.8 - 0.4;
            double offsetX = Math.cos(angle) * radius * (info.level.f_46441_.m_188500_() * 0.7 + 0.3);
            double offsetY = heightVariation * (double)info.targetEntity.m_20206_() * 0.5 + 0.2;
            double offsetZ = Math.sin(angle) * radius * (info.level.f_46441_.m_188500_() * 0.7 + 0.3);
            ExAidSlashEffectEntity effect = new ExAidSlashEffectEntity((EntityType<? extends ExAidSlashEffectEntity>)((EntityType)ModEntityTypes.EXAID_SLASH_EFFECT.get()), info.level);
            effect.m_6034_(x + offsetX, y + offsetY, z + offsetZ);
            float yRot = (float)Math.toDegrees(Math.atan2(-lookVector.f_82479_, lookVector.f_82481_)) + (info.level.f_46441_.m_188501_() - 0.5f) * 180.0f;
            float xRot = (float)Math.toDegrees(Math.atan2(lookVector.f_82480_, Math.sqrt(lookVector.f_82479_ * lookVector.f_82479_ + lookVector.f_82481_ * lookVector.f_82481_))) + (info.level.f_46441_.m_188501_() - 0.5f) * 90.0f;
            effect.m_146922_(yRot);
            effect.m_146926_(xRot);
            effect.f_19794_ = true;
            effect.m_20331_(true);
            effect.setOwner((Entity)info.owner);
            effect.setTargetEntity(info.targetEntity);
            info.level.m_7967_((Entity)effect);
            ++info.spawnedEffects;
            if (info.targetEntity instanceof LivingEntity && info.targetEntity != info.owner) {
                LivingEntity targetLiving = (LivingEntity)info.targetEntity;
                if (!info.level.f_46443_) {
                    float damage = 8.0f;
                    targetLiving.m_6469_(info.level.m_269111_().m_269075_(info.owner), damage);
                }
            }
        }
    }

    private void spawnSlashEffectOnEntity(Entity entity, Level level, Player player, Vec3 direction) {
        if (!level.f_46443_ && entity != null) {
            DELAYED_EFFECTS.put(nextEffectId++, new DelayedEffectInfo(entity, level, player, direction, 0, 7));
            this.playHitSound(level, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() * 0.5, entity.m_20189_());
        }
    }

    private void playHitSound(Level level, double x, double y, double z) {
        float volume = 0.8f + level.f_46441_.m_188501_() * 0.2f;
        float pitch = 0.9f + level.f_46441_.m_188501_() * 0.2f;
        level.m_6263_(null, x, y, z, SoundEvents.f_11913_, SoundSource.PLAYERS, volume, pitch);
        level.m_6263_(null, x, y, z, SoundEvents.f_11705_, SoundSource.PLAYERS, volume * 0.7f, pitch * 1.2f);
    }

    @Override
    public String getRiderName() {
        return "Ex-Aid";
    }

    @Override
    public String getActivationSoundName() {
        return "Critical Strike!";
    }

    @Override
    public float getAttackDamage() {
        return 52.0f;
    }

    @Override
    public float getEffectRange() {
        return 8.0f;
    }

    private static class DelayedEffectInfo {
        Entity targetEntity;
        Level level;
        Player owner;
        Vec3 direction;
        int remainingTicks;
        int totalEffects;
        int spawnedEffects;

        DelayedEffectInfo(Entity targetEntity, Level level, Player owner, Vec3 direction, int delayTicks, int totalEffects) {
            this.targetEntity = targetEntity;
            this.level = level;
            this.owner = owner;
            this.direction = direction;
            this.remainingTicks = delayTicks;
            this.totalEffects = totalEffects;
            this.spawnedEffects = 0;
        }
    }
}

