/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class KivaEffect
extends AbstractHeiseiRiderEffect {
    @Override
    public void executeSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            KivaForm selectedForm = KivaForm.values()[level.f_46441_.m_188503_(KivaForm.values().length)];
            switch (selectedForm) {
                case KivaForm: {
                    this.executeKivaFormAttack(level, player, direction);
                    break;
                }
                case GaruluForm: {
                    this.executeGaruluFormAttack(level, player, direction);
                    break;
                }
                case BasshaaForm: {
                    this.executeBasshaaFormAttack(level, player, direction);
                    break;
                }
                case DoggaForm: {
                    this.executeDoggaFormAttack(level, player, direction);
                }
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 600, 0));
        }
    }

    private void executeKivaFormAttack(Level level, Player player, Vec3 direction) {
        EntityHitResult entityHitResult;
        Entity entity;
        double reach = 8.0;
        HitResult result = player.m_19907_(reach, 0.0f, false);
        if (result instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)result).m_82443_()) instanceof LivingEntity && entity != player) {
            ((LivingEntity)entity).m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage());
            float healAmount = Math.min(this.getAttackDamage() * 0.3f, player.m_21233_() - player.m_21223_());
            player.m_5634_(healAmount);
        }
    }

    private void executeGaruluFormAttack(Level level, Player player, Vec3 direction) {
        for (int i = 0; i < 3; ++i) {
            double angleOffset = (double)(i - 1) * Math.PI / 6.0;
            Vec3 clawDir = new Vec3(Math.cos(angleOffset) * direction.f_82479_ - Math.sin(angleOffset) * direction.f_82481_, direction.f_82480_, Math.sin(angleOffset) * direction.f_82479_ + Math.cos(angleOffset) * direction.f_82481_).m_82541_();
            Vec3 targetPos = player.m_20299_(1.0f).m_82549_(clawDir.m_82490_(2.0));
            level.m_6443_(LivingEntity.class, new AABB(targetPos, targetPos).m_82400_(1.2), entity -> entity != player).forEach(entity -> entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.6f));
        }
    }

    private void executeBasshaaFormAttack(Level level, Player player, Vec3 direction) {
        Vec3 targetPos = player.m_20299_(1.0f).m_82549_(direction.m_82490_(6.0));
        level.m_254849_((Entity)player, targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, this.getAttackDamage() / 5.0f, Level.ExplosionInteraction.MOB);
    }

    private void executeDoggaFormAttack(Level level, Player player, Vec3 direction) {
        Vec3 playerPos = player.m_20299_(1.0f);
        level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(8.0), entity -> entity != player && this.isInFront(player, (Entity)entity, direction, 1.0471975511965976)).forEach(entity -> {
            entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.7f);
            Vec3 knockback = entity.m_20182_().m_82546_(playerPos).m_82541_().m_82490_(1.2);
            entity.m_20256_(entity.m_20184_().m_82549_(knockback));
        });
    }

    private boolean isInFront(Player player, Entity entity, Vec3 direction, double maxAngle) {
        Vec3 toEntity = entity.m_20182_().m_82546_(player.m_20299_(1.0f)).m_82541_();
        double dotProduct = toEntity.m_82526_(direction.m_82541_());
        return dotProduct > Math.cos(maxAngle);
    }

    @Override
    public String getRiderName() {
        return "Kiva";
    }

    @Override
    public String getActivationSoundName() {
        return "Darkness Moon Break!";
    }

    @Override
    public float getAttackDamage() {
        return 49.0f;
    }

    @Override
    public float getEffectRange() {
        return 9.0f;
    }

    private static enum KivaForm {
        KivaForm,
        GaruluForm,
        BasshaaForm,
        DoggaForm;

    }
}

