/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class KuugaEffect
extends AbstractHeiseiRiderEffect {
    @Override
    public void executeSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            KuugaForm selectedForm = KuugaForm.values()[level.f_46441_.m_188503_(KuugaForm.values().length)];
            switch (selectedForm) {
                case Mighty: {
                    this.executeMightyForm(level, player, direction);
                    break;
                }
                case Dragon: {
                    this.executeDragonForm(level, player, direction);
                    break;
                }
                case Pegasus: {
                    this.executePegasusForm(level, player, direction);
                    break;
                }
                case Titan: {
                    this.executeTitanForm(level, player, direction);
                }
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 300, 1));
        }
    }

    private void executeMightyForm(Level level, Player player, Vec3 direction) {
        double reach = 8.0;
        Vec3 start = player.m_20299_(1.0f);
        Vec3 end = start.m_82549_(direction.m_82490_(reach));
        level.m_6443_(LivingEntity.class, new AABB(start, end).m_82400_(1.5), entity -> entity != player).forEach(entity -> {
            entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 1.2f);
            Vec3 knockback = direction.m_82490_(1.5);
            entity.m_20256_(entity.m_20184_().m_82549_(knockback));
        });
    }

    private void executeDragonForm(Level level, Player player, Vec3 direction) {
        for (int i = 0; i < 3; ++i) {
            double spreadX = (level.f_46441_.m_188500_() - 0.5) * 0.3;
            double spreadY = (level.f_46441_.m_188500_() - 0.5) * 0.3;
            double spreadZ = (level.f_46441_.m_188500_() - 0.5) * 0.3;
            Vec3 waterDir = new Vec3(direction.f_82479_ + spreadX, direction.f_82480_ + spreadY, direction.f_82481_ + spreadZ).m_82541_();
            double waterReach = 12.0;
            Vec3 waterStart = player.m_20299_(1.0f);
            Vec3 waterEnd = waterStart.m_82549_(waterDir.m_82490_(waterReach));
            level.m_6443_(LivingEntity.class, new AABB(waterStart, waterEnd).m_82400_(0.5), entity -> entity != player).forEach(entity -> entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.5f));
        }
    }

    private void executePegasusForm(Level level, Player player, Vec3 direction) {
        double reach = 15.0;
        Vec3 start = player.m_20299_(1.0f);
        Vec3 end = start.m_82549_(direction.m_82490_(reach));
        level.m_6443_(LivingEntity.class, new AABB(start, end).m_82400_(0.5), entity -> entity != player).forEach(entity -> {
            entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.8f);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 300, 0));
        });
    }

    private void executeTitanForm(Level level, Player player, Vec3 direction) {
        level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(5.0), entity -> entity != player).forEach(entity -> entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.7f));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 300, 2));
    }

    @Override
    public String getRiderName() {
        return "Kuuga";
    }

    @Override
    public String getActivationSoundName() {
        return "Rising Mighty Kick!";
    }

    @Override
    public float getAttackDamage() {
        return 45.0f;
    }

    @Override
    public float getEffectRange() {
        return 15.0f;
    }

    private static enum KuugaForm {
        Mighty,
        Dragon,
        Pegasus,
        Titan;

    }
}

