/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class OOOEffect
extends AbstractHeiseiRiderEffect {
    @Override
    public void executeSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            OOOCombo selectedCombo = OOOCombo.values()[level.f_46441_.m_188503_(OOOCombo.values().length)];
            this.executeComboAttack(level, player, direction, selectedCombo);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 300, 1));
        }
    }

    private void executeComboAttack(Level level, Player player, Vec3 direction, OOOCombo combo) {
        switch (combo) {
            case TATOBA: {
                this.executeBalancedAttack(level, player, direction);
                break;
            }
            case LATORARTAR: {
                this.executePowerAttack(level, player);
                break;
            }
            case SHAUTA: {
                this.executeWaterAttack(level, player, direction);
                break;
            }
            case PUTOTYRA: {
                this.executeFullPowerAttack(level, player);
            }
        }
    }

    private void executeBalancedAttack(Level level, Player player, Vec3 direction) {
        double reach = 8.0;
        Vec3 start = player.m_20299_(1.0f);
        Vec3 end = start.m_82549_(direction.m_82490_(reach));
        level.m_6443_(LivingEntity.class, new AABB(start, end).m_82400_(1.0), entity -> entity != player).forEach(entity -> entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 1.0f));
    }

    private void executePowerAttack(Level level, Player player) {
        level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(5.0), entity -> entity != player).forEach(entity -> {
            entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.8f);
            Vec3 knockback = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82490_(1.0);
            entity.m_20256_(entity.m_20184_().m_82549_(knockback));
        });
    }

    private void executeWaterAttack(Level level, Player player, Vec3 direction) {
        for (int i = 0; i < 3; ++i) {
            double spreadX = (level.f_46441_.m_188500_() - 0.5) * 0.2;
            double spreadY = (level.f_46441_.m_188500_() - 0.5) * 0.2;
            double spreadZ = (level.f_46441_.m_188500_() - 0.5) * 0.2;
            Vec3 waterDir = new Vec3(direction.f_82479_ + spreadX, direction.f_82480_ + spreadY, direction.f_82481_ + spreadZ).m_82541_();
            double waterReach = 12.0;
            Vec3 waterStart = player.m_20299_(1.0f);
            Vec3 waterEnd = waterStart.m_82549_(waterDir.m_82490_(waterReach));
            level.m_6443_(LivingEntity.class, new AABB(waterStart, waterEnd).m_82400_(0.5), entity -> entity != player).forEach(entity -> entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.6f));
        }
    }

    private void executeFullPowerAttack(Level level, Player player) {
        level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(7.0), entity -> entity != player).forEach(entity -> {
            entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.7f);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 150, 0));
        });
    }

    @Override
    public String getRiderName() {
        return "OOO";
    }

    @Override
    public String getActivationSoundName() {
        return "Scanning Charge!";
    }

    @Override
    public float getAttackDamage() {
        return 51.0f;
    }

    @Override
    public float getEffectRange() {
        return 14.0f;
    }

    private static enum OOOCombo {
        TATOBA(1.0, 0.8, 0.0),
        LATORARTAR(0.0, 0.5, 0.0),
        SHAUTA(0.0, 0.0, 1.0),
        PUTOTYRA(0.8, 0.0, 0.0);

        private final double r;
        private final double g;
        private final double b;

        private OOOCombo(double r, double g, double b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public double getR() {
            return this.r;
        }

        public double getG() {
            return this.g;
        }

        public double getB() {
            return this.b;
        }
    }
}

