/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RyukiEffect
extends AbstractHeiseiRiderEffect {
    @Override
    public void executeSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            RyukiCard selectedCard = RyukiCard.values()[level.f_46441_.m_188503_(RyukiCard.values().length)];
            switch (selectedCard) {
                case SwordVent: {
                    this.executeSwordVent(level, player, direction);
                    break;
                }
                case ShootVent: {
                    this.executeShootVent(level, player, direction);
                    break;
                }
                case GuardVent: {
                    this.executeGuardVent(level, player, direction);
                    break;
                }
                case StrikeVent: {
                    this.executeStrikeVent(level, player, direction);
                    break;
                }
                case FinalVent: {
                    this.executeFinalVent(level, player, direction);
                }
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 600, 0));
        }
    }

    private void executeSwordVent(Level level, Player player, Vec3 direction) {
        EntityHitResult entityHitResult;
        Entity entity;
        double reach = 8.0;
        HitResult result = player.m_19907_(reach, 0.0f, false);
        if (result instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)result).m_82443_()) instanceof LivingEntity && entity != player) {
            ((LivingEntity)entity).m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage());
            ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1));
        }
    }

    private void executeShootVent(Level level, Player player, Vec3 direction) {
        for (int i = 0; i < 5; ++i) {
            EntityHitResult entityHitResult;
            Entity entity;
            double angleOffset = (double)(i - 2) * Math.PI / 12.0;
            Vec3 bulletDir = new Vec3(Math.cos(angleOffset) * direction.f_82479_ - Math.sin(angleOffset) * direction.f_82481_, direction.f_82480_ + (level.f_46441_.m_188500_() - 0.5) * 0.3, Math.sin(angleOffset) * direction.f_82479_ + Math.cos(angleOffset) * direction.f_82481_).m_82541_();
            HitResult result = player.m_19907_(15.0, 0.0f, false);
            if (!(result instanceof EntityHitResult) || !((entity = (entityHitResult = (EntityHitResult)result).m_82443_()) instanceof LivingEntity) || entity == player) continue;
            ((LivingEntity)entity).m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.3f);
            ((LivingEntity)entity).m_20254_(3);
        }
    }

    private void executeGuardVent(Level level, Player player, Vec3 direction) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 2));
        level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_((double)this.getEffectRange()), entity -> entity != player).forEach(entity -> entity.m_6469_(level.m_269111_().m_269374_((Entity)player), this.getAttackDamage() * 0.3f));
    }

    private void executeStrikeVent(Level level, Player player, Vec3 direction) {
        level.m_45933_((Entity)player, player.m_20191_().m_82400_((double)this.getEffectRange())).forEach(entity -> {
            if (entity instanceof LivingEntity && entity != player) {
                ((LivingEntity)entity).m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.6f);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 100, 1));
            }
        });
    }

    private void executeFinalVent(Level level, Player player, Vec3 direction) {
        double reach = 10.0;
        Vec3 targetPos = player.m_20299_(1.0f).m_82549_(direction.m_82490_(reach));
        level.m_254849_((Entity)player, targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, this.getEffectRange() / 2.0f, Level.ExplosionInteraction.MOB);
        level.m_45933_((Entity)player, new AABB(targetPos, targetPos).m_82400_(4.0)).forEach(entity -> {
            if (entity instanceof LivingEntity && entity != player) {
                ((LivingEntity)entity).m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 1.5f);
                Vec3 knockback = direction.m_82490_(2.0);
                entity.m_20256_(entity.m_20184_().m_82549_(knockback));
            }
        });
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 5));
    }

    @Override
    public String getRiderName() {
        return "Ryuki";
    }

    @Override
    public String getActivationSoundName() {
        return "Dragon Rider Kick!";
    }

    @Override
    public float getAttackDamage() {
        return 47.0f;
    }

    @Override
    public float getEffectRange() {
        return 8.0f;
    }

    private static enum RyukiCard {
        SwordVent,
        ShootVent,
        GuardVent,
        StrikeVent,
        FinalVent;

    }
}

