/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WEffect
extends AbstractHeiseiRiderEffect {
    @Override
    public void executeSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            WMemoryCombo selectedCombo = WMemoryCombo.values()[level.f_46441_.m_188503_(WMemoryCombo.values().length)];
            switch (selectedCombo) {
                case CycloneJoker: {
                    this.executeCycloneJoker(level, player, direction);
                    break;
                }
                case HeatMetal: {
                    this.executeHeatMetal(level, player, direction);
                    break;
                }
                case LunaTrigger: {
                    this.executeLunaTrigger(level, player, direction);
                    break;
                }
                case FangJoker: {
                    this.executeFangJoker(level, player, direction);
                    break;
                }
                case CycloneTrigger: {
                    this.executeCycloneTrigger(level, player, direction);
                }
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 1));
        }
    }

    private void executeCycloneJoker(Level level, Player player, Vec3 direction) {
        EntityHitResult entityHitResult;
        Entity entity;
        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 100, 3));
        double reach = 8.0;
        Vec3 start = player.m_20299_(1.0f);
        Vec3 end = start.m_82549_(direction.m_82490_(reach));
        HitResult result = player.m_19907_(reach, 0.0f, false);
        if (result instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)result).m_82443_()) instanceof LivingEntity && entity != player) {
            ((LivingEntity)entity).m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage());
            ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 80, 1));
        }
    }

    private void executeHeatMetal(Level level, Player player, Vec3 direction) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 300, 0));
        for (int i = 0; i < 8; ++i) {
            BlockPos groundPos;
            Vec3 firePos = player.m_20299_(1.0f).m_82549_(direction.m_82490_((double)(i + 1)));
            BlockPos blockPos = new BlockPos((int)firePos.f_82479_, (int)firePos.f_82480_, (int)firePos.f_82481_);
            if (level.m_46859_(blockPos) && level.m_8055_(groundPos = blockPos.m_7495_()).m_60804_((BlockGetter)level, groundPos)) {
                level.m_7731_(blockPos, Blocks.f_50083_.m_49966_(), 1);
            }
            level.m_6443_(LivingEntity.class, new AABB(firePos, firePos).m_82400_(1.0), entity -> entity != player).forEach(entity -> {
                entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.3f);
                entity.m_20254_(3);
            });
        }
    }

    private void executeLunaTrigger(Level level, Player player, Vec3 direction) {
        Vec3[] bulletDirections = new Vec3[4];
        for (int i = 0; i < 4; ++i) {
            bulletDirections[i] = new Vec3(direction.f_82479_ + (level.f_46441_.m_188500_() - 0.5) * 0.6, direction.f_82480_ + (level.f_46441_.m_188500_() - 0.5) * 0.6, direction.f_82481_ + (level.f_46441_.m_188500_() - 0.5) * 0.6).m_82541_();
        }
        for (Vec3 bulletDir : bulletDirections) {
            Vec3 start = player.m_20299_(1.0f);
            Vec3 end = start.m_82549_(bulletDir.m_82490_(15.0));
            level.m_6443_(LivingEntity.class, new AABB(start, end).m_82400_(0.5), entity -> entity != player).forEach(entity -> entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.45f));
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 200, 0));
    }

    private void executeFangJoker(Level level, Player player, Vec3 direction) {
        Vec3[] attackPositions = new Vec3[3];
        for (int i = 0; i < 3; ++i) {
            attackPositions[i] = player.m_20182_().m_82520_((level.f_46441_.m_188500_() - 0.5) * 2.0, 0.0, (level.f_46441_.m_188500_() - 0.5) * 2.0);
        }
        for (Vec3 attackPos : attackPositions) {
            level.m_6443_(LivingEntity.class, new AABB(attackPos, attackPos).m_82400_(5.0), entity -> entity != player).forEach(entity -> entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.45f));
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 100, 2));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 1));
    }

    private void executeCycloneTrigger(Level level, Player player, Vec3 direction) {
        level.m_254849_((Entity)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.getEffectRange() / 2.0f, Level.ExplosionInteraction.MOB);
        for (int i = 0; i < 8; ++i) {
            EntityHitResult entityHitResult;
            Entity entity;
            double angle = Math.PI * 2 * (double)i / 8.0;
            Vec3 bulletDir = new Vec3(Math.cos(angle) * 0.8 + direction.f_82479_ * 0.2, direction.f_82480_ + (level.f_46441_.m_188500_() - 0.5) * 0.3, Math.sin(angle) * 0.8 + direction.f_82481_ * 0.2).m_82541_();
            Vec3 start = player.m_20299_(1.0f);
            Vec3 end = start.m_82549_(bulletDir.m_82490_(12.0));
            HitResult bulletResult = player.m_19907_(12.0, 0.0f, false);
            if (!(bulletResult instanceof EntityHitResult) || !((entity = (entityHitResult = (EntityHitResult)bulletResult).m_82443_()) instanceof LivingEntity) || entity == player) continue;
            ((LivingEntity)entity).m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.3f);
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 100, 2));
    }

    @Override
    public String getRiderName() {
        return "W";
    }

    @Override
    public String getActivationSoundName() {
        return "Joker Extreme!";
    }

    @Override
    public float getAttackDamage() {
        return 51.0f;
    }

    @Override
    public float getEffectRange() {
        return 7.0f;
    }

    private static enum WMemoryCombo {
        CycloneJoker,
        HeatMetal,
        LunaTrigger,
        FangJoker,
        CycloneTrigger;

    }
}

