/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WizardEffect
extends AbstractHeiseiRiderEffect {
    @Override
    public void executeSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            WizardRing selectedRing = WizardRing.values()[level.f_46441_.m_188503_(WizardRing.values().length)];
            switch (selectedRing) {
                case Flame: {
                    this.executeFlameMagic(level, player, direction);
                    break;
                }
                case Water: {
                    this.executeWaterMagic(level, player, direction);
                    break;
                }
                case Hurricane: {
                    this.executeHurricaneMagic(level, player, direction);
                    break;
                }
                case Earth: {
                    this.executeEarthMagic(level, player, direction);
                    break;
                }
                case Infinity: {
                    this.executeInfinityMagic(level, player, direction);
                }
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 0));
        }
    }

    private void executeFlameMagic(Level level, Player player, Vec3 direction) {
        EntityHitResult entityHitResult;
        Entity entity;
        Vec3 start = player.m_20299_(1.0f);
        Vec3 end = start.m_82549_(direction.m_82490_(15.0));
        HitResult result = player.m_19907_(15.0, 0.0f, false);
        if (result instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)result).m_82443_()) instanceof LivingEntity && entity != player) {
            ((LivingEntity)entity).m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 1.0f);
            ((LivingEntity)entity).m_20254_(8);
            level.m_254849_((Entity)player, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.getEffectRange() / 2.0f, Level.ExplosionInteraction.MOB);
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 200, 0));
    }

    private void executeWaterMagic(Level level, Player player, Vec3 direction) {
        for (int i = 0; i < 8; ++i) {
            Vec3 waterPos = player.m_20299_(1.0f).m_82549_(direction.m_82490_((double)(i + 1)));
            level.m_45933_((Entity)player, new AABB(waterPos, waterPos).m_82400_(1.5)).forEach(entity -> {
                if (entity instanceof LivingEntity && entity != player) {
                    ((LivingEntity)entity).m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.3f);
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 2));
                    if (((LivingEntity)entity).m_6060_()) {
                        ((LivingEntity)entity).m_20095_();
                    }
                }
            });
        }
        int rainRange = 5;
        for (int x = -rainRange; x <= rainRange; ++x) {
            for (int z = -rainRange; z <= rainRange; ++z) {
                for (int y = 3; y >= -3; --y) {
                    BlockPos firePos = player.m_20183_().m_7918_(x, y, z);
                    if (level.m_8055_(firePos).m_60734_() != Blocks.f_50083_) continue;
                    level.m_7471_(firePos, false);
                }
            }
        }
    }

    private void executeHurricaneMagic(Level level, Player player, Vec3 direction) {
        level.m_254849_((Entity)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.getEffectRange() / 2.0f, Level.ExplosionInteraction.MOB);
        level.m_45933_((Entity)player, player.m_20191_().m_82400_((double)this.getEffectRange())).forEach(entity -> {
            if (entity instanceof LivingEntity && entity != player) {
                ((LivingEntity)entity).m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.5f);
                Vec3 knockback = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82490_(2.0);
                entity.m_20256_(entity.m_20184_().m_82549_(knockback));
            }
        });
        player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 150, 0));
    }

    private void executeEarthMagic(Level level, Player player, Vec3 direction) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 300, 2));
        level.m_254849_((Entity)player, player.m_20185_(), player.m_20186_() - 1.0, player.m_20189_(), this.getEffectRange(), Level.ExplosionInteraction.BLOCK);
        level.m_45933_((Entity)player, player.m_20191_().m_82400_((double)this.getEffectRange())).forEach(entity -> {
            if (entity instanceof LivingEntity && entity != player) {
                ((LivingEntity)entity).m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.6f);
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 150, 3));
            }
        });
    }

    private void executeInfinityMagic(Level level, Player player, Vec3 direction) {
        level.m_45933_((Entity)player, player.m_20191_().m_82400_((double)this.getEffectRange() * 1.5)).forEach(entity -> {
            if (entity instanceof LivingEntity && entity != player) {
                ((LivingEntity)entity).m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.8f);
            }
        });
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 300, 3));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 300, 2));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 2));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 200, 3));
    }

    @Override
    public String getRiderName() {
        return "Wizard";
    }

    @Override
    public String getActivationSoundName() {
        return "Strike Wizard!";
    }

    @Override
    public float getAttackDamage() {
        return 51.0f;
    }

    @Override
    public float getEffectRange() {
        return 8.0f;
    }

    private static enum WizardRing {
        Flame,
        Water,
        Hurricane,
        Earth,
        Infinity;

    }
}

