/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.build;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.build.BuildRiderEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BuildRiderEffect
extends AbstractHeiseiRiderEffect {
    private static final float ATTACK_MULTIPLIER = 1.2f;
    private static final float DEFENSE_MULTIPLIER = 1.1f;
    private static final float ROCKET_PUNCH_DAMAGE = 30.0f;
    private static final float SPECIAL_KICK_DAMAGE = 51.0f;
    private static final float SPECIAL_KICK_RANGE = 8.0f;

    @Override
    public void executeSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            this.executeFormulaKick(level, player, direction);
            this.applyRabbitTankEffects(level, player);
        }
    }

    @Override
    public String getRiderName() {
        return "Build";
    }

    @Override
    public String getActivationSoundName() {
        return "Best Match!";
    }

    @Override
    public float getAttackDamage() {
        return 61.2f;
    }

    @Override
    public float getEffectRange() {
        return 5.0f;
    }

    private void executeFormulaKick(Level level, Player player, Vec3 direction) {
        this.executeRocketPunch(level, player, direction);
        BuildRiderEntity.trySpawnEffect(level, (LivingEntity)player, direction, this.getAttackDamage());
        Vec3 start = player.m_20299_(1.0f);
        Vec3 end = start.m_82549_(direction.m_82490_(8.0));
        LivingEntity target = null;
        double closestDistance = Double.MAX_VALUE;
        for (LivingEntity entity2 : level.m_6443_(LivingEntity.class, new AABB(start, end).m_82400_(1.0), entity -> entity != player)) {
            double distance = entity2.m_20280_((Entity)player);
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            target = entity2;
        }
        if (target != null) {
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.0f);
            DamageSource kickDamage = level.m_269111_().m_269075_(player);
            boolean hurt = target.m_6469_(kickDamage, this.getAttackDamage());
            if (hurt) {
                this.spawnKickParticles(level, target);
                Vec3 knockback = direction.m_82490_(2.0).m_82520_(0.0, 0.5, 0.0);
                target.m_5997_(knockback.f_82479_, knockback.f_82480_, knockback.f_82481_);
            }
        }
    }

    private void executeRocketPunch(Level level, Player player, Vec3 direction) {
        for (int i = 0; i < 3; ++i) {
            Vec3 start = player.m_20299_(1.0f);
            Vec3 end = start.m_82549_(direction.m_82490_(5.0 + (double)i * 1.0));
            level.m_6443_(LivingEntity.class, new AABB(start, end).m_82400_(0.5), entity -> entity != player).forEach(entity -> entity.m_6469_(level.m_269111_().m_269075_(player), 30.0f));
        }
    }

    private void spawnKickParticles(Level level, LivingEntity target) {
        for (int i = 0; i < 20; ++i) {
            double d0 = level.f_46441_.m_188583_() * 0.02;
            double d1 = level.f_46441_.m_188583_() * 0.02;
            double d2 = level.f_46441_.m_188583_() * 0.02;
            level.m_7106_((ParticleOptions)ParticleTypes.f_175830_, target.m_20185_() + (double)(level.f_46441_.m_188501_() * target.m_20205_() * 2.0f) - (double)target.m_20205_(), target.m_20186_() + 0.5 + (double)(level.f_46441_.m_188501_() * target.m_20206_()), target.m_20189_() + (double)(level.f_46441_.m_188501_() * target.m_20205_() * 2.0f) - (double)target.m_20205_(), d0, d1, d2);
        }
        level.m_7106_((ParticleOptions)ParticleTypes.f_175826_, target.m_20185_(), target.m_20186_() + 0.5, target.m_20189_(), 0.0, 0.0, 0.0);
    }

    private void applyRabbitTankEffects(Level level, Player player) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 1));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 1));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 100, 0));
    }
}

