/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.drive;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DriveRiderEntity
extends Projectile
implements GeoEntity {
    private static final Map<UUID, WheelType> PLAYER_WHEEL_TYPE_MAP = new HashMap<UUID, WheelType>();
    private static final RawAnimation MOVE_ANIMATION = RawAnimation.begin().thenPlay("move");
    private static final RawAnimation HIT_ANIMATION = RawAnimation.begin().thenPlay("attack.hit");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int lifetime = 0;
    private static final int MAX_LIFETIME = 200;
    private Vec3 attackDirection;
    private Vec3 initialPosition;
    private int boomerangPhase = 0;
    private static final double MAX_FLIGHT_DISTANCE = 20.0;
    private boolean hasReachedTurningPoint = false;
    private float speed = 1.0f;
    private UUID ownerUUID = null;
    private static final float TRIGGER_CHANCE = 1.0f;
    private static final EntityDataAccessor<Boolean> HAS_HIT_ENTITY = SynchedEntityData.m_135353_(DriveRiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(DriveRiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> WHEEL_TYPE = SynchedEntityData.m_135353_(DriveRiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    private boolean hasHitEntity() {
        return (Boolean)this.m_20088_().m_135370_(HAS_HIT_ENTITY);
    }

    private void setHasHitEntity(boolean value) {
        this.m_20088_().m_135381_(HAS_HIT_ENTITY, (Object)value);
    }

    private float getDamage() {
        return ((Float)this.m_20088_().m_135370_(DAMAGE)).floatValue();
    }

    private void setDamage(float value) {
        this.m_20088_().m_135381_(DAMAGE, (Object)Float.valueOf(value));
    }

    public WheelType getWheelType() {
        return WheelType.fromId((Integer)this.m_20088_().m_135370_(WHEEL_TYPE));
    }

    private void setWheelType(WheelType type) {
        this.m_20088_().m_135381_(WHEEL_TYPE, (Object)type.getId());
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
    }

    public boolean isHitEntity() {
        return this.hasHitEntity();
    }

    private DriveRiderEntity(Level level, LivingEntity owner, Vec3 direction, float attackDamage, WheelType wheelType) {
        super((EntityType)ModEntityTypes.DRIVE_RIDER_EFFECT.get(), level);
        this.m_5602_((Entity)owner);
        this.f_19794_ = true;
        this.initialPosition = owner.m_146892_();
        this.m_146884_(this.initialPosition.m_82549_(direction.m_82490_(1.0)));
        this.attackDirection = direction.m_82541_();
        this.setDamage(attackDamage * wheelType.getDamageMultiplier());
        this.setOwnerUUID(owner.m_20148_());
        this.m_146922_(owner.m_146908_());
        this.m_146926_(owner.m_146909_());
        this.speed = 1.0f * wheelType.getSpeedMultiplier();
        this.setWheelType(wheelType);
    }

    public DriveRiderEntity(EntityType<? extends DriveRiderEntity> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
        this.attackDirection = Vec3.f_82478_;
        this.initialPosition = Vec3.f_82478_;
    }

    public static void trySpawnEffect(Level level, LivingEntity owner, Vec3 direction, float attackDamage) {
        if (level.f_46441_.m_188501_() <= 1.0f && !level.f_46443_) {
            UUID ownerUUID = owner.m_20148_();
            WheelType currentType = PLAYER_WHEEL_TYPE_MAP.getOrDefault(ownerUUID, WheelType.ENGINEER);
            DriveRiderEntity effect = new DriveRiderEntity(level, owner, direction, attackDamage, currentType);
            level.m_7967_((Entity)effect);
            PLAYER_WHEEL_TYPE_MAP.put(ownerUUID, currentType.getNextType());
        }
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(HAS_HIT_ENTITY, (Object)false);
        this.m_20088_().m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(WHEEL_TYPE, (Object)WheelType.ENGINEER.getId());
    }

    protected void m_7378_(CompoundTag compound) {
        double z;
        double y;
        double x;
        if (compound.m_128441_("OwnerUUID")) {
            this.ownerUUID = compound.m_128342_("OwnerUUID");
        }
        this.setHasHitEntity(compound.m_128471_("HasHitEntity"));
        this.lifetime = compound.m_128451_("Lifetime");
        if (compound.m_128441_("Damage")) {
            this.setDamage(compound.m_128457_("Damage"));
        }
        if (compound.m_128441_("WheelType")) {
            this.setWheelType(WheelType.fromId(compound.m_128451_("WheelType")));
        }
        if (compound.m_128441_("BoomerangPhase")) {
            this.boomerangPhase = compound.m_128451_("BoomerangPhase");
        }
        if (compound.m_128441_("HasReachedTurningPoint")) {
            this.hasReachedTurningPoint = compound.m_128471_("HasReachedTurningPoint");
        }
        if (compound.m_128441_("Speed")) {
            this.speed = compound.m_128457_("Speed");
        }
        if (compound.m_128441_("InitialX")) {
            x = compound.m_128459_("InitialX");
            y = compound.m_128459_("InitialY");
            z = compound.m_128459_("InitialZ");
            this.initialPosition = new Vec3(x, y, z);
        }
        if (compound.m_128441_("DirectionX")) {
            x = compound.m_128459_("DirectionX");
            y = compound.m_128459_("DirectionY");
            z = compound.m_128459_("DirectionZ");
            this.attackDirection = new Vec3(x, y, z);
        }
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.ownerUUID != null) {
            compound.m_128362_("OwnerUUID", this.ownerUUID);
        }
        compound.m_128379_("HasHitEntity", this.hasHitEntity());
        compound.m_128405_("Lifetime", this.lifetime);
        compound.m_128350_("Damage", this.getDamage());
        compound.m_128405_("WheelType", this.getWheelType().getId());
        compound.m_128405_("BoomerangPhase", this.boomerangPhase);
        compound.m_128379_("HasReachedTurningPoint", this.hasReachedTurningPoint);
        compound.m_128350_("Speed", this.speed);
        compound.m_128347_("InitialX", this.initialPosition.f_82479_);
        compound.m_128347_("InitialY", this.initialPosition.f_82480_);
        compound.m_128347_("InitialZ", this.initialPosition.f_82481_);
        compound.m_128347_("DirectionX", this.attackDirection.f_82479_);
        compound.m_128347_("DirectionY", this.attackDirection.f_82480_);
        compound.m_128347_("DirectionZ", this.attackDirection.f_82481_);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::animationPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private PlayState animationPredicate(AnimationState<DriveRiderEntity> state) {
        if (this.hasHitEntity()) {
            state.getController().setAnimation(HIT_ANIMATION);
        } else {
            state.getController().setAnimation(MOVE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.lifetime;
        if (this.hasHitEntity()) {
            if (this.lifetime > 40) {
                this.explode();
                this.m_146870_();
            }
            return;
        }
        if (this.lifetime > 200) {
            this.explode();
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().m_5776_()) {
            this.handleBoomerangMovement();
            this.checkEntityCollision();
        }
        this.attractEntities();
    }

    private void handleBoomerangMovement() {
        Vec3 currentPos = this.m_20182_();
        if (this.attackDirection == null) {
            this.attackDirection = Vec3.f_82478_;
        }
        double distanceFromStart = currentPos.m_82554_(this.initialPosition);
        switch (this.boomerangPhase) {
            case 0: {
                if (!(distanceFromStart >= 20.0) && !this.hasReachedTurningPoint) break;
                this.boomerangPhase = 1;
                this.hasReachedTurningPoint = true;
                break;
            }
            case 1: {
                LivingEntity owner = this.getOwner();
                Vec3 targetPos = owner != null ? owner.m_20182_().m_82520_(0.0, 1.0, 0.0) : this.initialPosition;
                Vec3 returnDirection = targetPos.m_82546_(currentPos).m_82541_();
                this.attackDirection = this.attackDirection.m_82490_(0.9).m_82549_(returnDirection.m_82490_(0.1)).m_82541_();
                this.speed = Math.min(this.speed + 0.01f, 1.5f);
                if (!(this.attackDirection.m_82526_(returnDirection) > 0.95)) break;
                this.boomerangPhase = 2;
                break;
            }
            case 2: {
                LivingEntity owner2 = this.getOwner();
                Vec3 returnTarget = owner2 != null ? owner2.m_20182_().m_82520_(0.0, 1.0, 0.0) : this.initialPosition;
                double distanceToTarget = currentPos.m_82554_(returnTarget);
                if (distanceToTarget < 2.0) {
                    this.explode();
                    this.m_146870_();
                    return;
                }
                Vec3 finalReturnDirection = returnTarget.m_82546_(currentPos).m_82541_();
                this.attackDirection = this.attackDirection.m_82490_(0.8).m_82549_(finalReturnDirection.m_82490_(0.2)).m_82541_();
                this.speed = Math.min(this.speed + 0.01f, 1.8f);
            }
        }
        Vec3 newPos = currentPos.m_82549_(this.attackDirection.m_82490_((double)this.speed));
        this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        this.m_37283_();
    }

    public void m_37283_() {
        if (this.attackDirection == null || this.attackDirection.m_82553_() < 0.01) {
            return;
        }
        double horizontalDistance = Math.sqrt(this.attackDirection.f_82479_ * this.attackDirection.f_82479_ + this.attackDirection.f_82481_ * this.attackDirection.f_82481_);
        float yaw = (float)Math.toDegrees(Math.atan2(-this.attackDirection.f_82479_, this.attackDirection.f_82481_));
        float pitch = (float)Math.toDegrees(Math.atan2(-this.attackDirection.f_82480_, horizontalDistance));
        this.m_146922_(yaw);
        this.m_146926_(pitch);
    }

    private void checkEntityCollision() {
        block1: {
            if (this.attackDirection == null) {
                this.attackDirection = Vec3.f_82478_;
            }
            AABB boundingBox = this.m_20191_().m_82369_(this.attackDirection.m_82490_(1.0)).m_82400_(1.0);
            List entities = this.m_9236_().m_6443_(LivingEntity.class, boundingBox, entity -> entity != this.getOwner() && entity.m_6084_() && this.canAttack((LivingEntity)entity));
            Iterator iterator = entities.iterator();
            if (!iterator.hasNext()) break block1;
            LivingEntity entity2 = (LivingEntity)iterator.next();
            this.onHitEntity(entity2);
        }
    }

    private void onHitEntity(LivingEntity target) {
        if (this.hasHitEntity()) {
            return;
        }
        this.setHasHitEntity(true);
        float finalDamage = this.getDamage();
        LivingEntity owner = this.getOwner();
        if (owner != null) {
            target.m_6469_(this.m_269291_().m_269299_((Entity)this, owner), finalDamage);
        } else {
            target.m_6469_(this.m_269291_().m_269425_(), finalDamage);
        }
        this.lifetime = 0;
    }

    private boolean canAttack(LivingEntity target) {
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return true;
        }
        if (target == owner) {
            return false;
        }
        return owner.m_6779_(target);
    }

    public LivingEntity getOwner() {
        UUID uuid = this.getOwnerUUID();
        if (uuid == null || this.m_9236_() == null) {
            return null;
        }
        Player owner = this.m_9236_().m_46003_(uuid);
        if (owner instanceof LivingEntity) {
            return (LivingEntity)owner;
        }
        AABB searchArea = this.m_20191_().m_82400_(32.0);
        List entities = this.m_9236_().m_6249_((Entity)this, searchArea, entity -> entity instanceof LivingEntity && entity.m_20148_().equals(uuid));
        if (!entities.isEmpty()) {
            return (LivingEntity)entities.get(0);
        }
        return null;
    }

    private void attractEntities() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        Vec3 center = this.m_20182_();
        AABB searchArea = this.m_20191_().m_82400_(5.0);
        WheelType currentType = this.getWheelType();
        List entities = this.m_9236_().m_6249_((Entity)this, searchArea, entity -> entity instanceof LivingEntity && entity != this.getOwner() && entity.m_6084_() && !(entity instanceof Projectile));
        for (Entity entity2 : entities) {
            Vec3 entityPos = entity2.m_20182_();
            Vec3 direction = center.m_82546_(entityPos).m_82541_();
            double distance = entityPos.m_82554_(center);
            if (distance > 0.3) {
                double baseForce = 0.3;
                if (currentType == WheelType.ENGINEER) {
                    baseForce = 0.4;
                } else if (currentType == WheelType.NINJA) {
                    baseForce = 0.2;
                }
                double force = baseForce * (1.0 - distance / 5.0);
                Vec3 pushVector = direction.m_82490_(force);
                entity2.m_5997_(pushVector.f_82479_, pushVector.f_82480_, pushVector.f_82481_);
                if ((double)this.m_9236_().f_46441_.m_188501_() < 0.4) {
                    this.m_9236_().m_7106_(currentType.getParticleType(), entityPos.f_82479_, entityPos.f_82480_ + 0.5, entityPos.f_82481_, direction.f_82479_ * 0.5, direction.f_82480_ * 0.5, direction.f_82481_ * 0.5);
                }
            }
            if (currentType != WheelType.FIRE || !(entity2 instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity2;
            if (!((double)this.m_9236_().f_46441_.m_188501_() < 0.2)) continue;
            livingEntity.m_20254_(2);
        }
    }

    private void explode() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        Vec3 center = this.m_20182_();
        WheelType currentType = this.getWheelType();
        float explosionRadius = 2.0f;
        if (currentType == WheelType.ENGINEER) {
            explosionRadius = 2.5f;
        } else if (currentType == WheelType.FIRE) {
            explosionRadius = 1.8f;
        }
        this.m_9236_().m_254849_((Entity)this, center.f_82479_, center.f_82480_, center.f_82481_, explosionRadius, Level.ExplosionInteraction.NONE);
        AABB explosionArea = this.m_20191_().m_82400_(3.0);
        List entities = this.m_9236_().m_6443_(LivingEntity.class, explosionArea, entity -> entity != this.getOwner() && entity.m_6084_());
        for (LivingEntity entity2 : entities) {
            float damageMultiplier = 0.5f;
            if (currentType == WheelType.NINJA) {
                damageMultiplier = 0.7f;
            }
            float explosionDamage = this.getDamage() * damageMultiplier;
            LivingEntity owner = this.getOwner();
            if (owner != null) {
                entity2.m_6469_(this.m_269291_().m_269333_(owner), explosionDamage);
            } else {
                entity2.m_6469_(this.m_269291_().m_269425_(), explosionDamage);
            }
            switch (currentType) {
                case FIRE: {
                    entity2.m_20254_(3);
                    break;
                }
                case ENGINEER: {
                    Vec3 knockbackDir = entity2.m_20182_().m_82546_(center).m_82541_().m_82490_(0.5);
                    entity2.m_5997_(knockbackDir.f_82479_, 0.3, knockbackDir.f_82481_);
                    break;
                }
                case NINJA: {
                    if (!((double)this.m_9236_().f_46441_.m_188501_() < 0.3)) break;
                }
            }
        }
        for (int i = 0; i < 20; ++i) {
            double offsetX = (this.m_9236_().f_46441_.m_188500_() - 0.5) * (double)explosionRadius * 2.0;
            double offsetY = (this.m_9236_().f_46441_.m_188500_() - 0.5) * (double)explosionRadius * 2.0;
            double offsetZ = (this.m_9236_().f_46441_.m_188500_() - 0.5) * (double)explosionRadius * 2.0;
            this.m_9236_().m_7106_(currentType.getParticleType(), center.f_82479_ + offsetX, center.f_82480_ + offsetY, center.f_82481_ + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    public static enum WheelType {
        ENGINEER(0, "engineer", "\u7eff\u8272\u5de5\u7a0b\u8f66\u8f6e", 1.0f, 1.2f, (ParticleOptions)ParticleTypes.f_123753_),
        FIRE(1, "fire", "\u9ec4\u8272\u706b\u7130\u8f66\u8f6e", 1.2f, 1.0f, (ParticleOptions)ParticleTypes.f_123744_),
        NINJA(2, "ninja", "\u7d2b\u8272\u5fcd\u8005\u624b\u91cc\u5200\u8f66\u8f6e", 0.9f, 1.5f, (ParticleOptions)ParticleTypes.f_123808_);

        private final int id;
        private final String name;
        private final String displayName;
        private final float damageMultiplier;
        private final float speedMultiplier;
        private final ParticleOptions particleType;

        private WheelType(int id, String name, String displayName, float damageMultiplier, float speedMultiplier, ParticleOptions particleType) {
            this.id = id;
            this.name = name;
            this.displayName = displayName;
            this.damageMultiplier = damageMultiplier;
            this.speedMultiplier = speedMultiplier;
            this.particleType = particleType;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public float getDamageMultiplier() {
            return this.damageMultiplier;
        }

        public float getSpeedMultiplier() {
            return this.speedMultiplier;
        }

        public ParticleOptions getParticleType() {
            return this.particleType;
        }

        public static WheelType fromId(int id) {
            for (WheelType type : WheelType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return ENGINEER;
        }

        public WheelType getNextType() {
            int nextId = (this.id + 1) % WheelType.values().length;
            return WheelType.fromId(nextId);
        }
    }
}

