/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.gaim;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GaimLockSeedEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation MOVE_ANIMATION = RawAnimation.begin().thenPlay("move");
    private static final RawAnimation ATTACK_ANIMATION = RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE);
    private Entity owner;
    private int lifetime = 0;
    private static final int MAX_LIFETIME = 100;
    private Vec3 attackDirection;
    private float damage;
    private boolean hasAttacked = false;
    private int removeDelay = 0;
    private static final EntityDataAccessor<String> LOCK_SEED_TYPE = SynchedEntityData.m_135353_(GaimLockSeedEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> ATTACKED = SynchedEntityData.m_135353_(GaimLockSeedEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public GaimLockSeedEntity(EntityType<? extends GaimLockSeedEntity> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
        this.m_20331_(true);
        this.attackDirection = new Vec3(0.0, 0.0, 1.0);
    }

    public GaimLockSeedEntity(Level level, Player owner, Vec3 position, Vec3 direction, String lockSeedType, float damage) {
        super((EntityType)ModEntityTypes.GAIM_LOCK_SEED.get(), level);
        this.m_146884_(position);
        this.owner = owner;
        this.attackDirection = direction.m_82541_();
        this.setLockSeedType(lockSeedType);
        this.damage = damage * 0.75f;
        this.f_19794_ = true;
        this.m_20331_(true);
        double horizontalDistance = Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_);
        float yRot = (float)Math.toDegrees(Math.atan2(-direction.f_82479_, direction.f_82481_));
        float xRot = (float)Math.toDegrees(Math.atan2(direction.f_82480_, horizontalDistance));
        this.m_146922_(yRot);
        this.m_146926_(xRot);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(LOCK_SEED_TYPE, (Object)"ORANGE");
        this.f_19804_.m_135372_(ATTACKED, (Object)false);
    }

    public String getLockSeedType() {
        return (String)this.f_19804_.m_135370_(LOCK_SEED_TYPE);
    }

    public void setLockSeedType(String type) {
        this.f_19804_.m_135381_(LOCK_SEED_TYPE, (Object)type);
    }

    public boolean hasAttacked() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKED);
    }

    public void setAttacked(boolean attacked) {
        this.f_19804_.m_135381_(ATTACKED, (Object)attacked);
        this.hasAttacked = attacked;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.lifetime;
        if (this.removeDelay > 0) {
            --this.removeDelay;
            if (this.removeDelay <= 0) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
        } else if (this.lifetime > 100) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.attackDirection != null) {
            this.m_6478_(MoverType.SELF, this.attackDirection.m_82490_(0.4));
        }
        this.checkCollisions();
        if (this.getLockSeedType().equals("ORANGE")) {
            this.cutEntitiesOnCollision();
        }
    }

    private void cutEntitiesOnCollision() {
        if (this.m_9236_().f_46443_ || this.owner == null) {
            return;
        }
        AABB collisionBox = this.m_20191_().m_82400_(0.3);
        for (Entity entity : this.m_9236_().m_45933_((Entity)this, collisionBox)) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity == this.owner || !this.isHostileTarget(livingEntity)) continue;
            float cutDamage = this.damage * 0.3f;
            livingEntity.m_6469_(this.m_9236_().m_269111_().m_269075_((Player)this.owner), cutDamage);
            if (!this.m_9236_().f_46443_) continue;
        }
    }

    private boolean isHostileTarget(LivingEntity entity) {
        Entity entity2 = this.owner;
        if (entity2 instanceof Player) {
            Player player = (Player)entity2;
            if (entity instanceof Player) {
                Player targetPlayer = (Player)entity;
                if (player.m_7099_(targetPlayer)) {
                    return true;
                }
                Team playerTeam = player.m_5647_();
                Team targetTeam = targetPlayer.m_5647_();
                if (playerTeam != null && targetTeam != null && !playerTeam.equals(targetTeam)) {
                    return true;
                }
            }
            if (!entity.m_6095_().m_20674_().m_21609_() && entity.m_6084_()) {
                return true;
            }
        }
        return false;
    }

    private void checkCollisions() {
        if (this.hasAttacked()) {
            return;
        }
        BlockPos currentPos = this.m_20183_();
        if (!this.m_9236_().f_46443_) {
            BlockState currentState = this.m_9236_().m_8055_(currentPos);
            if (!currentState.m_60795_() && !currentState.m_60812_((BlockGetter)this.m_9236_(), currentPos).m_83281_()) {
                this.onCollision();
                return;
            }
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos adjacentPos = currentPos.m_7918_(x, y, z);
                        BlockState adjacentState = this.m_9236_().m_8055_(adjacentPos);
                        if (adjacentState.m_60795_() || adjacentState.m_60812_((BlockGetter)this.m_9236_(), adjacentPos).m_83281_() || !(adjacentPos.m_123331_((Vec3i)currentPos) <= 2.0)) continue;
                        this.onCollision();
                        return;
                    }
                }
            }
        }
        AABB boundingBox = this.m_20191_().m_82377_(0.2, 0.2, 0.2);
        for (Entity entity : this.m_9236_().m_45933_((Entity)this, boundingBox)) {
            if (!(entity instanceof LivingEntity) || entity == this.owner) continue;
            this.onCollision();
            return;
        }
    }

    private void onCollision() {
        this.setAttacked(true);
        if (this.getLockSeedType().equals("PINEAPPLE")) {
            if (!this.m_9236_().f_46443_) {
                float explosionPower = this.damage / 3.0f;
                this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), explosionPower, Level.ExplosionInteraction.MOB);
            }
            this.removeDelay = 5;
        } else if (this.getLockSeedType().equals("ORANGE")) {
            // empty if block
        }
    }

    protected void m_7378_(CompoundTag compound) {
        this.setLockSeedType(compound.m_128461_("LockSeedType"));
        this.setAttacked(compound.m_128471_("Attacked"));
        if (compound.m_128441_("Damage")) {
            this.damage = compound.m_128457_("Damage");
        }
        if (compound.m_128403_("OwnerUUID")) {
            UUID uUID = compound.m_128342_("OwnerUUID");
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128359_("LockSeedType", this.getLockSeedType());
        compound.m_128379_("Attacked", this.hasAttacked());
        compound.m_128350_("Damage", this.damage);
        if (this.owner != null) {
            compound.m_128362_("OwnerUUID", this.owner.m_20148_());
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<GaimLockSeedEntity> event) {
        if (this.hasAttacked()) {
            event.getController().setAnimation(ATTACK_ANIMATION);
        } else {
            event.getController().setAnimation(MOVE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

