/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.sound;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;

public class RiderSounds {
    private static final Map<String, Lazy<SoundEvent>> SOUND_REGISTRY = new HashMap<String, Lazy<SoundEvent>>();
    public static final SoundEvent RIDE_HEI_SABER = RiderSounds.register("ride_hei_saber");
    public static final SoundEvent FINISH_TIME = RiderSounds.register("finish_time");
    public static final SoundEvent ULTIMATE_TIME_BREAK = RiderSounds.register("ultimate_time_break");
    public static final SoundEvent SCRAMBLE_TIME_BREAK = RiderSounds.register("scramble_time_break");
    public static final SoundEvent DUAL_TIME_BREAK = RiderSounds.register("dual_time_break");
    public static final SoundEvent HEY = RiderSounds.register("hey");
    public static final SoundEvent HEY_SAY_RAPID = RiderSounds.register("hey_say_rapid");
    public static final SoundEvent NAME_BUILD = RiderSounds.register("name_build");
    public static final SoundEvent NAME_EXAID = RiderSounds.register("name_exaid");
    public static final SoundEvent NAME_GHOST = RiderSounds.register("name_ghost");
    public static final SoundEvent NAME_DRIVE = RiderSounds.register("name_drive");
    public static final SoundEvent NAME_GAIM = RiderSounds.register("name_gaim");
    public static final SoundEvent NAME_WIZARD = RiderSounds.register("name_wizard");
    public static final SoundEvent NAME_FOURZE = RiderSounds.register("name_fourze");
    public static final SoundEvent NAME_OOO = RiderSounds.register("name_ooo");
    public static final SoundEvent NAME_W = RiderSounds.register("name_w");
    public static final SoundEvent NAME_DECADE = RiderSounds.register("name_decade");
    public static final SoundEvent NAME_KIVA = RiderSounds.register("name_kiva");
    public static final SoundEvent NAME_DEN_O = RiderSounds.register("name_den_o");
    public static final SoundEvent NAME_KABUTO = RiderSounds.register("name_kabuto");
    public static final SoundEvent NAME_HIBIKI = RiderSounds.register("name_hibiki");
    public static final SoundEvent NAME_BLADE = RiderSounds.register("name_blade");
    public static final SoundEvent NAME_FAIZ = RiderSounds.register("name_faiz");
    public static final SoundEvent NAME_RYUKI = RiderSounds.register("name_ryuki");
    public static final SoundEvent NAME_AGITO = RiderSounds.register("name_agito");
    public static final SoundEvent NAME_KUUGA = RiderSounds.register("name_kuuga");

    private static SoundEvent register(String name) {
        Lazy soundEvent = Lazy.of(() -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("kamen_rider_weapon_craft", name)));
        SOUND_REGISTRY.put(name, (Lazy<SoundEvent>)soundEvent);
        return (SoundEvent)soundEvent.get();
    }

    public static void playSound(Level level, Player player, SoundEvent sound) {
        if (level.m_5776_()) {
            level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            ((ServerLevel)level).m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void playDelayedSound(final Level level, final Player player, final SoundEvent sound, int delayTicks) {
        if (level.m_5776_()) {
            Timer timer = new Timer(true);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Minecraft.m_91087_().execute(() -> RiderSounds.playSound(level, player, sound));
                }
            }, (long)delayTicks * 50L);
        } else {
            ServerLevel serverLevel = (ServerLevel)level;
            int finalDelay = delayTicks;
            serverLevel.m_7654_().execute(() -> new Timer(true).schedule(new TimerTask(){

                @Override
                public void run() {
                    RiderSounds.playSound(level, player, sound);
                }
            }, (long)finalDelay * 50L));
        }
    }

    public static void playDelayedSoundSequence(final Level level, final Player player, List<DelayedSound> sounds) {
        if (level.m_5776_()) {
            Timer timer = new Timer(true);
            for (final DelayedSound delayedSound : sounds) {
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        Minecraft.m_91087_().execute(() -> RiderSounds.playSound(level, player, delayedSound2.soundEvent));
                    }
                }, (long)delayedSound.delayTicks * 50L);
            }
        } else {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().execute(() -> {
                Timer timer = new Timer(true);
                for (final DelayedSound delayedSound : sounds) {
                    timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            RiderSounds.playSound(level, player, delayedSound.soundEvent);
                        }
                    }, (long)delayedSound.delayTicks * 50L);
                }
            });
        }
    }

    public static void playSelectionSound(Level level, Player player, SoundEvent riderNameSound) {
        RiderSounds.playSound(level, player, HEY);
        RiderSounds.playDelayedSound(level, player, riderNameSound, 20);
    }

    public static void playAttackSound(Level level, Player player, SoundEvent riderNameSound) {
        RiderSounds.playSound(level, player, riderNameSound);
    }

    public static void playKillSound(Level level, Player player, SoundEvent specialSound) {
        RiderSounds.playSound(level, player, specialSound);
    }

    public static class DelayedSound {
        public final SoundEvent soundEvent;
        public final int delayTicks;

        public DelayedSound(SoundEvent soundEvent, int delayTicks) {
            this.soundEvent = soundEvent;
            this.delayTicks = delayTicks;
        }
    }
}

