/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.util;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModItems;
import com.xiaoshi2022.kamen_rider_weapon_craft.util.tags.FruitTags;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FruitConversionRegistry {
    private static final Map<TagKey<Item>, Supplier<Item>> CONVERSIONS = new HashMap<TagKey<Item>, Supplier<Item>>();

    public static void init() {
        FruitConversionRegistry.register(FruitTags.CANTALOUPE, () -> (Item)ModItems.MELON.get());
        FruitConversionRegistry.register(FruitTags.CHERRY, () -> (Item)ModItems.CHERYY.get());
        FruitConversionRegistry.register(FruitTags.BANANA, () -> FruitConversionRegistry.crossModItem("kamen_rider_boss_you_and_me", "bananafruit"));
        FruitConversionRegistry.register(FruitTags.LEMON, () -> FruitConversionRegistry.crossModItem("kamen_rider_boss_you_and_me", "lemon_energy"));
        FruitConversionRegistry.register(FruitTags.PEACH, () -> FruitConversionRegistry.crossModItem("kamen_rider_boss_you_and_me", "peach_energy"));
    }

    private static void register(TagKey<Item> tag, Supplier<Item> resultSupplier) {
        CONVERSIONS.put(tag, resultSupplier);
    }

    private static Item crossModItem(String modId, String itemId) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modId, itemId));
    }

    public static Optional<Item> getConversion(ItemStack stack) {
        return CONVERSIONS.entrySet().stream().filter(e -> stack.m_204117_((TagKey)e.getKey())).findFirst().map(e -> (Item)((Supplier)e.getValue()).get());
    }

    public static boolean isConvertibleFruit(ItemStack stack) {
        return CONVERSIONS.keySet().stream().anyMatch(tag -> stack.m_204117_(tag));
    }
}

