/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.Item.prop.custom;

import com.xiaoshi2022.kamen_rider_weapon_craft.Item.prop.client.melon.MelonRenderer;
import com.xiaoshi2022.kamen_rider_weapon_craft.blocks.portals.helheim_crack;
import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModBlocks;
import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModSounds;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Melon
extends Item
implements GeoItem {
    private static final RawAnimation START = RawAnimation.begin().thenPlay("start");
    private static final RawAnimation COMBINE = RawAnimation.begin().thenPlay("combine");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Melon(Item.Properties properties) {
        super(properties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private MelonRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new MelonRenderer();
                }
                return this.renderer;
            }
        });
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        stack.m_41783_().m_128379_("lockseed", true);
        int INTERVAL = 240;
        long lastPlayed = player.getPersistentData().m_128454_("lastPlayedSound");
        long currentTime = level.m_46467_();
        if (currentTime - lastPlayed >= 240L) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "start", "start");
                int generatedBlocks = player.getPersistentData().m_128451_("generatedBlocks");
                if (this.generateHelheimCrack(level, player)) {
                    ++generatedBlocks;
                }
                player.getPersistentData().m_128405_("generatedBlocks", generatedBlocks);
                if (generatedBlocks >= 5) {
                    this.createPlayerOnlyExplosion(level, player);
                    player.getPersistentData().m_128405_("generatedBlocks", 0);
                }
                player.getPersistentData().m_128356_("lastPlayedSound", currentTime);
            }
        } else {
            player.m_5661_((Component)Component.m_237113_((String)("\u51b7\u5374\u65f6\u95f4\u672a\u7ed3\u675f\uff0c\u8fd8\u9700\u7b49\u5f85 " + (240L - (currentTime - lastPlayed)) / 20L + " \u79d2")), true);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
    }

    private boolean generateHelheimCrack(Level level, Player player) {
        BlockPos randomPos;
        Random random = new Random();
        BlockPos playerPos = player.m_20183_();
        int range = 4;
        if (random.nextDouble() < 0.35 && level.m_46859_(randomPos = new BlockPos(playerPos.m_123341_() + random.nextInt(range * 2) - range, playerPos.m_123342_() + random.nextInt(range * 2) - range, playerPos.m_123343_() + random.nextInt(range * 2) - range))) {
            BlockState state = ((helheim_crack)((Object)ModBlocks.HELHEIM_CRACK_BLOCK.get())).m_49966_();
            level.m_46597_(randomPos, state);
            this.playSound(level, player, randomPos);
            return true;
        }
        return false;
    }

    private void createPlayerOnlyExplosion(Level level, Player player) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            player.m_6469_(player.m_269291_().m_269264_(), 3.0f);
            if (player.m_21223_() <= 1.0f) {
                String deathMessage = player.m_7755_().getString() + "\u88ab\u81ea\u5df1\u8d2a\u73a9\u7684\u5c0f\u624b\u80cc\u53db\u4e86";
                player.m_213846_((Component)Component.m_237113_((String)deathMessage));
            }
        }
    }

    private void playSound(Level level, Player player, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_5594_(null, pos, (SoundEvent)ModSounds.MELONENERGY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "start", 20, state -> PlayState.STOP).triggerableAnim("start", START).setSoundKeyframeHandler(state -> {
            Player player = ClientUtils.getClientPlayer();
            if (player != null) {
                player.m_5496_((SoundEvent)ModSounds.MELONENERGY.get(), 1.0f, 1.0f);
            }
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

