/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.blocks.client;

import com.xiaoshi2022.kamen_rider_weapon_craft.network.NetworkHandler;
import com.xiaoshi2022.kamen_rider_weapon_craft.network.SyncAnimationStatePacket;
import com.xiaoshi2022.kamen_rider_weapon_craft.network.SyncGuiOpenStatePacket;
import com.xiaoshi2022.kamen_rider_weapon_craft.network.SyncRecipeDataPacket;
import com.xiaoshi2022.kamen_rider_weapon_craft.recipe.ModRecipes;
import com.xiaoshi2022.kamen_rider_weapon_craft.recipe.RiderFusionRecipe;
import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModBlockEntities;
import com.xiaoshi2022.kamen_rider_weapon_craft.world.inventory.RiderFusionMachineContainer;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RiderFusionMachineBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            RiderFusionMachineBlockEntity.this.m_6596_();
            if (slot < 4 && RiderFusionMachineBlockEntity.this.isCrafting) {
                RiderFusionMachineBlockEntity.this.checkRecipeMatch();
            }
            if (slot == 4 && RiderFusionMachineBlockEntity.this.isCraftingComplete && this.getStackInSlot(4).m_41619_()) {
                RiderFusionMachineBlockEntity.this.isCraftingComplete = false;
                RiderFusionMachineBlockEntity.this.shouldPlayEndAnimation = true;
                RiderFusionMachineBlockEntity.this.syncAnimationStateToClient();
            }
        }
    };
    public boolean isCrafting = false;
    public int craftingProgress = 0;
    private int fusionTime = 0;
    public int maxCraftingProgress = 0;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public boolean isGuiOpen = false;
    private boolean isCraftingComplete = false;
    public boolean shouldPlayEndAnimation = false;

    private void syncAnimationStateToClient() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new SyncAnimationStatePacket(this.shouldPlayEndAnimation, this.f_58858_));
        }
    }

    public RiderFusionMachineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.RIDER_FUSION_MACHINE_BLOCK_ENTITY.get(), pos, state);
    }

    public void onGuiOpened() {
        this.isGuiOpen = true;
        this.syncGuiOpenStateToClient();
    }

    private void syncGuiOpenStateToClient() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new SyncGuiOpenStatePacket(this.isGuiOpen, this.f_58858_));
        }
    }

    public void startCrafting() {
        Object t;
        Optional recipe;
        if (!this.isCrafting && this.canCraft() && (recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipes.RIDER_FUSION_RECIPE.get(), this.getContainer(), this.f_58857_)).isPresent() && (t = recipe.get()) instanceof RiderFusionRecipe) {
            RiderFusionRecipe fusionRecipe = (RiderFusionRecipe)t;
            this.maxCraftingProgress = this.fusionTime = fusionRecipe.getFusionTime();
            this.isCrafting = true;
            this.craftingProgress = 0;
            this.m_6596_();
            this.syncToClient();
        }
    }

    public boolean canCraft() {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipes.RIDER_FUSION_RECIPE.get(), this.getContainer(), this.f_58857_).isPresent();
    }

    public Container getContainer() {
        SimpleContainer container = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            container.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return container;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.isCrafting) {
            ++this.craftingProgress;
            if (this.craftingProgress >= this.fusionTime) {
                this.completeCrafting();
                this.isCrafting = false;
                this.craftingProgress = 0;
            }
            this.m_6596_();
            this.syncToClient();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_6907_().forEach(player -> {
                    AbstractContainerMenu patt5705$temp = player.f_36096_;
                    if (patt5705$temp instanceof RiderFusionMachineContainer) {
                        RiderFusionMachineContainer container = (RiderFusionMachineContainer)patt5705$temp;
                        container.setCraftingProgress(this.craftingProgress, this.maxCraftingProgress, this.isCrafting);
                    }
                });
            }
        }
    }

    public void completeCrafting() {
        Object t;
        if (this.f_58857_ == null) {
            return;
        }
        Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipes.RIDER_FUSION_RECIPE.get(), this.getContainer(), this.f_58857_);
        if (recipe.isPresent() && (t = recipe.get()) instanceof RiderFusionRecipe) {
            RiderFusionRecipe fusionRecipe = (RiderFusionRecipe)t;
            ItemStack result = ((Recipe)recipe.get()).m_5874_(this.getContainer(), this.f_58857_.m_9598_());
            ItemStack currentOutput = this.itemHandler.getStackInSlot(4);
            if (currentOutput.m_41619_() || currentOutput.m_150930_(result.m_41720_()) && currentOutput.m_41613_() + result.m_41613_() <= currentOutput.m_41741_()) {
                for (int i = 0; i < 4; ++i) {
                    this.itemHandler.extractItem(i, fusionRecipe.getRequiredCount(i), false);
                }
                this.itemHandler.insertItem(4, result, false);
                this.isCraftingComplete = true;
            } else {
                this.isCrafting = false;
                this.craftingProgress = 0;
            }
        } else {
            this.isCrafting = false;
            this.craftingProgress = 0;
        }
        this.m_6596_();
        this.syncToClient();
    }

    private void checkRecipeMatch() {
        if (!this.canCraft()) {
            this.isCrafting = false;
            this.craftingProgress = 0;
            this.m_6596_();
            this.syncToClient();
        }
    }

    private void syncToClient() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new SyncRecipeDataPacket(this.craftingProgress, this.maxCraftingProgress, this.isCrafting, this.f_58858_));
        }
    }

    public int getRedstoneSignal() {
        return this.isCrafting ? 3 : 0;
    }

    private PlayState predicate(AnimationState event) {
        if (this.isGuiOpen) {
            this.isGuiOpen = false;
            return event.setAndContinue(RawAnimation.begin().thenPlay("1").thenPlay("0"));
        }
        if (this.shouldPlayEndAnimation) {
            this.isCraftingComplete = false;
            this.shouldPlayEndAnimation = false;
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("end").thenPlay("0"));
        }
        if (this.isCraftingComplete) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("rotate").thenPlayAndHold("end"));
        }
        if (this.isCrafting) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("rotate"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        compound.m_128379_("isCrafting", this.isCrafting);
        compound.m_128405_("craftingProgress", this.craftingProgress);
        compound.m_128405_("fusionTime", this.fusionTime);
        compound.m_128405_("maxCraftingProgress", this.maxCraftingProgress);
        compound.m_128379_("isCraftingComplete", this.isCraftingComplete);
        compound.m_128379_("shouldPlayEndAnimation", this.shouldPlayEndAnimation);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.itemHandler.deserializeNBT(compound.m_128469_("Inventory"));
        this.isCrafting = compound.m_128471_("isCrafting");
        this.craftingProgress = compound.m_128451_("craftingProgress");
        this.fusionTime = compound.m_128451_("fusionTime");
        this.maxCraftingProgress = compound.m_128451_("maxCraftingProgress");
        this.isCraftingComplete = compound.m_128471_("isCraftingComplete");
        this.shouldPlayEndAnimation = compound.m_128471_("shouldPlayEndAnimation");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("isCrafting", this.isCrafting);
        tag.m_128405_("craftingProgress", this.craftingProgress);
        tag.m_128405_("maxCraftingProgress", this.maxCraftingProgress);
        tag.m_128379_("isCraftingComplete", this.isCraftingComplete);
        tag.m_128379_("shouldPlayEndAnimation", this.shouldPlayEndAnimation);
        return tag;
    }

    public void setCraftingProgress(int craftingProgress, int maxCraftingProgress, boolean isCrafting) {
        this.craftingProgress = craftingProgress;
        this.maxCraftingProgress = maxCraftingProgress;
        this.isCrafting = isCrafting;
        this.m_6596_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.isCrafting = tag.m_128471_("isCrafting");
            this.craftingProgress = tag.m_128451_("craftingProgress");
            this.maxCraftingProgress = tag.m_128451_("maxCraftingProgress");
            this.isCraftingComplete = tag.m_128471_("isCraftingComplete");
            this.shouldPlayEndAnimation = tag.m_128471_("shouldPlayEndAnimation");
        }
    }

    public int getCraftingProgress() {
        return this.craftingProgress;
    }

    public int getMaxCraftingProgress() {
        return this.maxCraftingProgress;
    }

    public void handleRecipeSync(int craftingProgress, int maxCraftingProgress, boolean isCrafting) {
        this.craftingProgress = craftingProgress;
        this.maxCraftingProgress = maxCraftingProgress;
        this.isCrafting = isCrafting;
        this.m_6596_();
    }
}

