/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.blocks.portals;

import com.xiaoshi2022.kamen_rider_weapon_craft.blocks.client.helheim_crackBlockEntity;
import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModBlockEntities;
import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModSounds;
import com.xiaoshi2022.kamen_rider_weapon_craft.worldgen.dimension.ModDimensions;
import com.xiaoshi2022.kamen_rider_weapon_craft.worldgen.portal.ModTeleporter;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.ITeleporter;

public class helheim_crack
extends Block
implements EntityBlock {
    public static final IntegerProperty ANIMATION = IntegerProperty.m_61631_((String)"animation", (int)0, (int)1);
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;

    public helheim_crack(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ANIMATION, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> helheim_crack.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)48.0, (double)16.0);
            case Direction.NORTH -> helheim_crack.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)48.0, (double)16.0);
            case Direction.EAST -> helheim_crack.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)48.0, (double)16.0);
            case Direction.WEST -> helheim_crack.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)48.0, (double)16.0);
            case Direction.UP -> helheim_crack.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)48.0);
            case Direction.DOWN -> helheim_crack.m_49796_((double)0.0, (double)0.0, (double)-32.0, (double)16.0, (double)16.0, (double)16.0);
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ANIMATION, FACING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)ModBlockEntities.HELHEIM_CRACK_BLOCK_ENTITY.get()).m_155264_(blockPos, blockState);
    }

    public InteractionResult m_6227_(BlockState blockstate, Level world, BlockPos pos, Player entity, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            int animationValue = 1;
            BlockState newState = (BlockState)blockstate.m_61124_((Property)ANIMATION, (Comparable)Integer.valueOf(animationValue));
            world.m_7731_(pos, newState, 3);
            world.m_7702_(pos).m_6596_();
            this.playSound(world, pos);
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                this.handleHelheimPortal(serverPlayer, pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void handleHelheimPortal(ServerPlayer player, BlockPos pPos) {
        ResourceKey<Level> resourcekey;
        ServerLevel serverlevel;
        MinecraftServer minecraftserver;
        ServerLevel portalDimension;
        Level level = player.m_9236_();
        if (level instanceof ServerLevel && (portalDimension = (minecraftserver = (serverlevel = (ServerLevel)level).m_7654_()).m_129880_(resourcekey = player.m_9236_().m_46472_() == ModDimensions.HELHEIM_LEVEL_KEY ? Level.f_46428_ : ModDimensions.HELHEIM_LEVEL_KEY)) != null && !player.m_20159_()) {
            if (resourcekey == ModDimensions.HELHEIM_LEVEL_KEY) {
                player.changeDimension(portalDimension, (ITeleporter)new ModTeleporter(pPos, true));
            } else {
                player.changeDimension(portalDimension, (ITeleporter)new ModTeleporter(pPos, false));
            }
        }
    }

    private void playSound(Level world, BlockPos pos) {
        world.m_5594_(null, pos, (SoundEvent)ModSounds.OPENDLOCK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.f_46443_) {
            return null;
        }
        if (type == ModBlockEntities.HELHEIM_CRACK_BLOCK_ENTITY.get()) {
            return (lvl, pos, stt, be) -> helheim_crackBlockEntity.tick(lvl, pos, stt, (helheim_crackBlockEntity)be);
        }
        return null;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        boolean shouldAnimate = false;
        BlockPos frontPos = pos.m_121945_(facing);
        AABB livingDetectionArea = new AABB(frontPos).m_82400_(1.0);
        for (LivingEntity livingEntity : level.m_45976_(LivingEntity.class, livingDetectionArea)) {
            if (livingEntity.m_20159_() || livingEntity.m_20160_() || !this.isFacingPortal(livingEntity, pos, facing)) continue;
            this.handleEntityPortal(livingEntity, pos);
            livingEntity.f_19864_ = true;
            shouldAnimate = true;
            break;
        }
        AABB itemDetectionArea = new AABB(pos).m_82400_(0.5);
        for (ItemEntity item : level.m_45976_(ItemEntity.class, itemDetectionArea)) {
            this.handleItemPortal(item, pos);
            item.f_19864_ = true;
            shouldAnimate = true;
        }
        if (shouldAnimate && (Integer)state.m_61143_((Property)ANIMATION) == 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ANIMATION, (Comparable)Integer.valueOf(1)), 3);
            this.playSound((Level)level, pos);
        } else if (!shouldAnimate && (Integer)state.m_61143_((Property)ANIMATION) != 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ANIMATION, (Comparable)Integer.valueOf(0)), 3);
        }
    }

    private void handleItemPortal(ItemEntity item, BlockPos pos) {
        ResourceKey<Level> destinationKey;
        ServerLevel serverLevel;
        MinecraftServer server;
        ServerLevel destination;
        Level level = item.m_9236_();
        if (level instanceof ServerLevel && (destination = (server = (serverLevel = (ServerLevel)level).m_7654_()).m_129880_(destinationKey = serverLevel.m_46472_() == ModDimensions.HELHEIM_LEVEL_KEY ? Level.f_46428_ : ModDimensions.HELHEIM_LEVEL_KEY)) != null) {
            ItemEntity newItem = new ItemEntity((Level)destination, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, item.m_32055_());
            destination.m_7967_((Entity)newItem);
            item.m_146870_();
        }
    }

    private boolean isFacingPortal(LivingEntity entity, BlockPos portalPos, Direction portalFacing) {
        Vec3 toPortal = new Vec3((double)portalFacing.m_122429_(), (double)portalFacing.m_122430_(), (double)portalFacing.m_122431_()).m_82541_();
        return toPortal.m_82526_(entity.m_20154_()) > 0.1;
    }

    private void handleEntityPortal(LivingEntity entity, BlockPos pPos) {
        ResourceKey<Level> resourcekey;
        ServerLevel serverlevel;
        MinecraftServer minecraftserver;
        ServerLevel portalDimension;
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel && (portalDimension = (minecraftserver = (serverlevel = (ServerLevel)level).m_7654_()).m_129880_(resourcekey = entity.m_9236_().m_46472_() == ModDimensions.HELHEIM_LEVEL_KEY ? Level.f_46428_ : ModDimensions.HELHEIM_LEVEL_KEY)) != null && !entity.m_20159_()) {
            if (resourcekey == ModDimensions.HELHEIM_LEVEL_KEY) {
                entity.changeDimension(portalDimension, (ITeleporter)new ModTeleporter(pPos, true));
            } else {
                entity.changeDimension(portalDimension, (ITeleporter)new ModTeleporter(pPos, false));
            }
        }
    }
}

