/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.xiaoshi2022.kamen_rider_weapon_craft.Item.custom.Heiseisword;
import com.xiaoshi2022.kamen_rider_weapon_craft.entity.ai.zombie.ZombieHeiseiswordController;
import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModItems;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.HeiseiRiderEffectManager;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SummonRiderZombieCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        List<String> riderNames = HeiseiRiderEffectManager.getRiderOrder();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"summonriderzombie").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"riderName", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (String name : riderNames) {
                builder.suggest(name.toLowerCase());
            }
            return builder.buildFuture();
        }).executes(SummonRiderZombieCommand::spawnRiderZombie))).executes(SummonRiderZombieCommand::showUsage));
    }

    private static int spawnRiderZombie(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String riderNameArg = StringArgumentType.getString(context, (String)"riderName");
        String normalizedRiderName = SummonRiderZombieCommand.normalizeRiderName(riderNameArg);
        List<String> validRiderNames = HeiseiRiderEffectManager.getRiderOrder();
        if (!validRiderNames.contains(normalizedRiderName)) {
            source.m_81352_((Component)Component.m_237113_((String)("\u65e0\u6548\u7684\u9a91\u58eb\u540d\u79f0: " + riderNameArg)));
            source.m_81352_((Component)Component.m_237113_((String)("\u53ef\u7528\u7684\u9a91\u58eb\u540d\u79f0: " + String.join((CharSequence)", ", validRiderNames))));
            return 0;
        }
        try {
            Zombie zombie = new Zombie((Level)source.m_81372_());
            zombie.m_146884_(source.m_81371_());
            ItemStack heiseisword = new ItemStack((ItemLike)ModItems.HEISEISWORD.get());
            Heiseisword.setSelectedRiderStatic(heiseisword, normalizedRiderName);
            heiseisword.m_41784_().m_128379_("fixedRider", true);
            heiseisword.m_41784_().m_128359_("fixedRiderName", normalizedRiderName);
            zombie.m_8061_(EquipmentSlot.MAINHAND, heiseisword);
            zombie.m_20049_("HeiseiswordZombie");
            zombie.m_20049_("RiderZombie_" + normalizedRiderName);
            zombie.m_21051_(Attributes.f_22276_).m_22100_(300.0);
            zombie.m_21153_(300.0f);
            if (!source.m_81372_().m_5776_()) {
                source.m_81372_().m_7967_((Entity)zombie);
                ZombieHeiseiswordController.addHeiseiswordGoal(zombie);
                source.m_288197_(() -> Component.m_237113_((String)("\u5df2\u751f\u6210" + normalizedRiderName + "\u9a91\u58eb\u50f5\u5c38\uff01")), true);
                source.m_288197_(() -> Component.m_237113_((String)("\u6b64\u50f5\u5c38\u5c06\u53ea\u4f7f\u7528" + normalizedRiderName + "\u7684\u6280\u80fd\u3002")), false);
            }
            return 1;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("\u751f\u6210\u9a91\u58eb\u50f5\u5c38\u65f6\u51fa\u9519: " + e.getMessage())));
            return 0;
        }
    }

    private static int showUsage(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        List<String> riderNames = HeiseiRiderEffectManager.getRiderOrder();
        source.m_81352_((Component)Component.m_237113_((String)"\u7528\u6cd5: /summonriderzombie <riderName>"));
        source.m_81352_((Component)Component.m_237113_((String)("\u53ef\u7528\u7684\u9a91\u58eb\u540d\u79f0: " + String.join((CharSequence)", ", riderNames))));
        return 0;
    }

    private static String normalizeRiderName(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        if (input.equalsIgnoreCase("ooo")) {
            return "OOO";
        }
        if (input.equalsIgnoreCase("den-o")) {
            return "Den-O";
        }
        if (input.equalsIgnoreCase("ex-aid")) {
            return "Ex-Aid";
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1).toLowerCase();
    }
}

