/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.entity.ai.zombie;

import com.xiaoshi2022.kamen_rider_weapon_craft.Item.custom.Heiseisword;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.HeiseiRiderEffectManager;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ZombieHeiseiswordGoal
extends Goal {
    private final Zombie zombie;
    private final Random random = new Random();
    private int cooldown = 0;
    private int riderSelectionCooldown = 0;
    private int modeSwitchCooldown = 0;
    private int dodgeCooldown = 0;
    private static final int MIN_COOLDOWN = 5;
    private static final int MAX_COOLDOWN = 30;
    private static final int RIDER_SELECTION_INTERVAL = 10;
    private static final int MODE_SWITCH_INTERVAL = 80;
    private static final int DODGE_COOLDOWN = 20;
    private static final double DODGE_SUCCESS_RATE = 0.8;
    private static final double AVOIDANCE_DISTANCE = 4.0;
    private static final int AVOIDANCE_EFFECT_DURATION = 60;
    private static final double ENERGY_RECOVERY_AMOUNT = 5.0;

    public ZombieHeiseiswordGoal(Zombie zombie) {
        this.zombie = zombie;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        ItemStack mainHandItem = this.zombie.m_21205_();
        return mainHandItem.m_41720_() instanceof Heiseisword && this.zombie.m_5448_() != null && this.zombie.m_6084_();
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.initializeWeapon();
    }

    public void m_8037_() {
        super.m_8037_();
        ItemStack mainHandItem = this.zombie.m_21205_();
        Item item = mainHandItem.m_41720_();
        if (!(item instanceof Heiseisword)) {
            return;
        }
        Heiseisword heiseisword = (Heiseisword)item;
        Level level = this.zombie.m_9236_();
        LivingEntity target = this.zombie.m_5448_();
        if (target == null || !target.m_6084_()) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.riderSelectionCooldown > 0) {
            --this.riderSelectionCooldown;
        }
        if (this.modeSwitchCooldown > 0) {
            --this.modeSwitchCooldown;
        }
        if (this.dodgeCooldown > 0) {
            --this.dodgeCooldown;
        }
        if (this.dodgeCooldown <= 0 && this.shouldDodge()) {
            this.performDodge();
            this.dodgeCooldown = 20;
        }
        if (this.riderSelectionCooldown <= 0) {
            this.selectRandomRider(heiseisword, mainHandItem, level);
            this.riderSelectionCooldown = 10;
        }
        if (this.modeSwitchCooldown <= 0) {
            this.maybeSwitchMode(heiseisword, mainHandItem, level);
            this.modeSwitchCooldown = 80;
        }
        if (this.cooldown <= 0) {
            this.performAction(heiseisword, mainHandItem, level, target);
            this.cooldown = this.random.nextInt(26) + 5;
        }
        this.zombie.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
    }

    private void initializeWeapon() {
        ItemStack mainHandItem = this.zombie.m_21205_();
        if (mainHandItem.m_41720_() instanceof Heiseisword) {
            String fixedRiderName;
            boolean isFixedRider = mainHandItem.m_41782_() && mainHandItem.m_41783_().m_128471_("fixedRider");
            String string = fixedRiderName = isFixedRider ? mainHandItem.m_41783_().m_128461_("fixedRiderName") : null;
            if (isFixedRider && fixedRiderName != null && !fixedRiderName.isEmpty()) {
                Heiseisword.setSelectedRiderStatic(mainHandItem, fixedRiderName);
            } else {
                List<String> riderOrder = HeiseiRiderEffectManager.getRiderOrder();
                if (!riderOrder.isEmpty()) {
                    Heiseisword.setSelectedRiderStatic(mainHandItem, riderOrder.get(0));
                }
            }
            mainHandItem.m_41784_().m_128405_("currentRotationPosition", 0);
        }
    }

    private void selectRandomRider(Heiseisword heiseisword, ItemStack stack, Level level) {
        List<String> riderOrder;
        String fixedRiderName;
        boolean isFixedRider = stack.m_41782_() && stack.m_41783_().m_128471_("fixedRider");
        String string = fixedRiderName = isFixedRider ? stack.m_41783_().m_128461_("fixedRiderName") : null;
        if (isFixedRider && fixedRiderName != null && !fixedRiderName.isEmpty()) {
            String currentRider = Heiseisword.getSelectedRiderStatic(stack);
            if (currentRider == null || !currentRider.equals(fixedRiderName)) {
                Heiseisword.setSelectedRiderStatic(stack, fixedRiderName);
                int rotationPosition = this.random.nextInt(4);
                stack.m_41784_().m_128405_("currentRotationPosition", rotationPosition);
                if (!level.f_46443_) {
                    HeiseiRiderEffectManager.playSelectionSound(level, (LivingEntity)this.zombie, fixedRiderName);
                }
            }
        } else if (this.random.nextDouble() < 0.8 && !(riderOrder = HeiseiRiderEffectManager.getRiderOrder()).isEmpty()) {
            String randomRider = riderOrder.get(this.random.nextInt(riderOrder.size()));
            Heiseisword.setSelectedRiderStatic(stack, randomRider);
            int rotationPosition = this.random.nextInt(4);
            stack.m_41784_().m_128405_("currentRotationPosition", rotationPosition);
            if (!level.f_46443_) {
                HeiseiRiderEffectManager.playSelectionSound(level, (LivingEntity)this.zombie, randomRider);
            }
        }
    }

    private void maybeSwitchMode(Heiseisword heiseisword, ItemStack stack, Level level) {
        boolean isFixedRider;
        boolean bl = isFixedRider = stack.m_41782_() && stack.m_41783_().m_128471_("fixedRider");
        if (isFixedRider) {
            if (Heiseisword.isFinishTimeModeStatic(stack)) {
                Heiseisword.setFinishTimeModeStatic(stack, false);
                Heiseisword.setScrambleRidersStatic(stack, new ArrayList<String>());
                String fixedRiderName = stack.m_41783_().m_128461_("fixedRiderName");
                Heiseisword.setSelectedRiderStatic(stack, fixedRiderName);
                Heiseisword.setUltimateModeStatic(stack, false);
                stack.m_41784_().m_128405_("currentRotationPosition", 0);
                stack.m_41784_().m_128473_("isXKeyUltimateReady");
            }
            return;
        }
        if (this.random.nextDouble() < 0.2) {
            boolean newMode;
            boolean currentMode = Heiseisword.isFinishTimeModeStatic(stack);
            boolean bl2 = newMode = !currentMode;
            if (newMode) {
                int finishTimeCooldown;
                long lastEnterTime = stack.m_41784_().m_128454_("lastFinishTimeEnter");
                long currentTime = level.m_46467_();
                if (currentTime - lastEnterTime >= (long)(finishTimeCooldown = 300)) {
                    Heiseisword.setFinishTimeModeStatic(stack, true);
                    stack.m_41784_().m_128356_("lastFinishTimeEnter", currentTime);
                    if (!level.f_46443_) {
                        HeiseiRiderEffectManager.playFinishTimeSound(level, (LivingEntity)this.zombie);
                    }
                    Heiseisword.setScrambleRiders(stack, new ArrayList<String>());
                }
            } else {
                Heiseisword.setFinishTimeModeStatic(stack, false);
                Heiseisword.setScrambleRidersStatic(stack, new ArrayList<String>());
                Heiseisword.setSelectedRiderStatic(stack, null);
                Heiseisword.setUltimateModeStatic(stack, false);
                stack.m_41784_().m_128405_("currentRotationPosition", 0);
                stack.m_41784_().m_128473_("isXKeyUltimateReady");
            }
        }
    }

    private void performAction(Heiseisword heiseisword, ItemStack stack, Level level, LivingEntity target) {
        Vec3 direction = target.m_20182_().m_82546_(this.zombie.m_20182_()).m_82541_();
        boolean isFinishTimeMode = Heiseisword.isFinishTimeModeStatic(stack);
        if (isFinishTimeMode) {
            this.performFinishTimeAction(heiseisword, stack, level, target, direction);
        } else {
            this.performNormalAction(heiseisword, stack, level, target, direction);
        }
    }

    private void performNormalAction(Heiseisword heiseisword, ItemStack stack, Level level, LivingEntity target, Vec3 direction) {
        if (this.random.nextDouble() < 0.7) {
            if ((double)this.zombie.m_20270_((Entity)target) < 2.5) {
                this.performNormalAttack(heiseisword, stack, level, target, direction);
            }
        } else {
            this.performRangedAttack(heiseisword, stack, level, target, direction);
        }
    }

    private void performFinishTimeAction(Heiseisword heiseisword, ItemStack stack, Level level, LivingEntity target, Vec3 direction) {
        List<String> selectedRiders;
        if (this.random.nextDouble() < 0.3) {
            this.selectMoreRiders(heiseisword, stack, level);
        }
        if (this.random.nextDouble() < 0.2 && !Heiseisword.isUltimateModeStatic(stack)) {
            Heiseisword.setUltimateModeStatic(stack, true);
            if (!level.f_46443_) {
                HeiseiRiderEffectManager.playUltimateActivationSound(level, (LivingEntity)this.zombie);
            }
        }
        if (this.random.nextDouble() < 0.8 && !(selectedRiders = Heiseisword.getScrambleRidersStatic(stack)).isEmpty()) {
            boolean isUltimateMode = Heiseisword.isUltimateModeStatic(stack);
            if (isUltimateMode) {
                this.executeUltimateAttack(heiseisword, stack, level, target, direction, selectedRiders);
            } else {
                this.executeScrambleAttack(heiseisword, stack, level, target, direction, selectedRiders);
            }
            stack.m_41784_().m_128356_("lastAttackTime", level.m_46467_());
        }
    }

    private void selectMoreRiders(Heiseisword heiseisword, ItemStack stack, Level level) {
        List<String> riderOrder = HeiseiRiderEffectManager.getRiderOrder();
        List<String> currentScrambleRiders = Heiseisword.getScrambleRidersStatic(stack);
        int count = 1 + this.random.nextInt(3);
        for (int i = 0; i < count; ++i) {
            ArrayList<String> availableRiders = new ArrayList<String>(riderOrder);
            availableRiders.removeAll(currentScrambleRiders);
            if (availableRiders.isEmpty()) continue;
            String randomRider = (String)availableRiders.get(this.random.nextInt(availableRiders.size()));
            currentScrambleRiders.add(randomRider);
            if (level.f_46443_) continue;
            HeiseiRiderEffectManager.playSelectionSound(level, (LivingEntity)this.zombie, randomRider);
        }
        Heiseisword.setScrambleRidersStatic(stack, currentScrambleRiders);
    }

    private void callZombiesToAvoidEffects(Level level, Vec3 direction) {
        if (level.m_5776_()) {
            return;
        }
        double leaderRange = 20.0;
        Vec3 pos = this.zombie.m_20182_();
        AABB searchArea = new AABB(pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), pos.m_7096_(), pos.m_7098_(), pos.m_7094_()).m_82400_(leaderRange);
        List nearbyZombies = level.m_45976_(Zombie.class, searchArea);
        for (Zombie nearbyZombie : nearbyZombies) {
            int blockZ;
            int blockY;
            if (nearbyZombie == this.zombie || nearbyZombie.getPersistentData().m_128441_("IsZombieLeader")) continue;
            Vec3 avoidanceDirection = this.calculateSmartAvoidanceDirection(nearbyZombie, direction);
            if (nearbyZombie.m_21573_() == null) continue;
            double distance = nearbyZombie.m_20270_((Entity)this.zombie);
            double adjustedDistance = Math.min(4.0, distance * 0.5);
            double targetX = nearbyZombie.m_20185_() + avoidanceDirection.f_82479_ * adjustedDistance;
            double targetY = nearbyZombie.m_20186_();
            double targetZ = nearbyZombie.m_20189_() + avoidanceDirection.f_82481_ * adjustedDistance;
            int blockX = (int)Math.floor(targetX);
            if (!level.m_8055_(new BlockPos(blockX, blockY = (int)Math.floor(targetY), blockZ = (int)Math.floor(targetZ))).m_60643_((BlockGetter)level, null, null)) continue;
            nearbyZombie.m_21573_().m_26519_(targetX, targetY, targetZ, 1.5);
            nearbyZombie.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, 2, false, false, true));
            nearbyZombie.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 60, 1, false, false, true));
        }
    }

    private Vec3 calculateSmartAvoidanceDirection(Zombie nearbyZombie, Vec3 attackDirection) {
        Vec3 basicAvoidance = new Vec3(-attackDirection.f_82479_, 0.0, -attackDirection.f_82481_).m_82541_();
        Vec3 toNearbyZombie = nearbyZombie.m_20182_().m_82546_(this.zombie.m_20182_()).m_82541_();
        Vec3 smartAvoidance = basicAvoidance.m_82549_(toNearbyZombie.m_82490_(0.5)).m_82541_();
        return smartAvoidance;
    }

    private boolean shouldDodge() {
        LivingEntity target = this.zombie.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        double distance = this.zombie.m_20270_((Entity)target);
        if (distance < 4.0) {
            double dodgeChance = 0.8 * (1.0 - distance / 4.0);
            return this.random.nextDouble() < dodgeChance;
        }
        return false;
    }

    private void performDodge() {
        LivingEntity target = this.zombie.m_5448_();
        if (target == null || !target.m_6084_()) {
            return;
        }
        Vec3 toTarget = target.m_20182_().m_82546_(this.zombie.m_20182_()).m_82541_();
        boolean dodgeLeft = this.random.nextBoolean();
        Vec3 dodgeDirection = dodgeLeft ? new Vec3(-toTarget.f_82481_, 0.0, toTarget.f_82479_).m_82541_() : new Vec3(toTarget.f_82481_, 0.0, -toTarget.f_82479_).m_82541_();
        dodgeDirection = dodgeDirection.m_82549_(new Vec3((this.random.nextDouble() - 0.5) * 0.4, 0.0, (this.random.nextDouble() - 0.5) * 0.4)).m_82541_();
        if (this.zombie.m_21573_() != null) {
            double targetX = this.zombie.m_20185_() + dodgeDirection.f_82479_ * 2.5;
            double targetY = this.zombie.m_20186_();
            double targetZ = this.zombie.m_20189_() + dodgeDirection.f_82481_ * 2.5;
            this.zombie.m_21573_().m_26519_(targetX, targetY, targetZ, 2.0);
            this.zombie.m_20256_(dodgeDirection.m_82490_(0.6));
            this.zombie.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 10, 3, false, false, true));
        }
    }

    private void performNormalAttack(Heiseisword heiseisword, ItemStack stack, Level level, LivingEntity target, Vec3 direction) {
        String selectedRider = Heiseisword.getSelectedRiderStatic(stack);
        if (selectedRider != null && !selectedRider.isEmpty()) {
            this.callZombiesToAvoidEffects(level, direction);
            HeiseiRiderEffectManager.getRiderEffect(selectedRider).executeSpecialAttack(level, (LivingEntity)this.zombie, direction);
            HeiseiRiderEffectManager.playAttackSound(level, (LivingEntity)this.zombie, selectedRider);
            stack.m_41784_().m_128356_("lastAttackTime", level.m_46467_());
        }
    }

    private void performRangedAttack(Heiseisword heiseisword, ItemStack stack, Level level, LivingEntity target, Vec3 direction) {
        String selectedRider = Heiseisword.getSelectedRiderStatic(stack);
        if (selectedRider != null && !selectedRider.isEmpty()) {
            this.callZombiesToAvoidEffects(level, direction);
            float chargeTime = 0.5f + this.random.nextFloat() * 0.5f;
            HeiseiRiderEffectManager.getRiderEffect(selectedRider).executeSpecialAttack(level, (LivingEntity)this.zombie, direction.m_82490_((double)chargeTime * 2.0));
            HeiseiRiderEffectManager.playAttackSound(level, (LivingEntity)this.zombie, selectedRider);
            stack.m_41784_().m_128356_("lastAttackTime", level.m_46467_());
        }
    }

    private void executeScrambleAttack(Heiseisword heiseisword, ItemStack stack, Level level, LivingEntity target, Vec3 direction, List<String> riders) {
        if (!riders.isEmpty()) {
            this.callZombiesToAvoidEffects(level, direction);
            HeiseiRiderEffectManager.playScrambleTimeBreakSound(level, (LivingEntity)this.zombie, riders);
            for (String rider : riders) {
                HeiseiRiderEffectManager.getRiderEffect(rider).executeSpecialAttack(level, (LivingEntity)this.zombie, direction);
            }
        }
    }

    private void executeUltimateAttack(Heiseisword heiseisword, ItemStack stack, Level level, LivingEntity target, Vec3 direction, List<String> riders) {
        if (!riders.isEmpty()) {
            this.callZombiesToAvoidEffects(level, direction);
            HeiseiRiderEffectManager.playUltimateTimeBreakSound(level, (LivingEntity)this.zombie, riders);
            for (String rider : riders) {
                HeiseiRiderEffectManager.getRiderEffect(rider).executeSpecialAttack(level, (LivingEntity)this.zombie, direction.m_82490_(2.0));
            }
            if (!level.f_46443_) {
                level.m_254849_((Entity)this.zombie, this.zombie.m_20185_(), this.zombie.m_20186_(), this.zombie.m_20189_(), 4.0f, Level.ExplosionInteraction.MOB);
                target.m_20256_(direction.m_82490_(2.0));
            }
        }
        Heiseisword.setUltimateModeStatic(stack, false);
    }
}

