/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.event;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModSounds;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="kamen_rider_weapon_craft")
public class LivingHurtHandler {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        Entity entity2 = source.m_7639_();
        if (entity2 instanceof Player) {
            Level level;
            Player player = (Player)entity2;
            long currentTime = player.m_9236_().m_46467_();
            long standbyStartTime = LivingHurtHandler.getStandbyStartTime(player);
            long standbyEndTime = LivingHurtHandler.getStandbyEndTime(player);
            if (currentTime >= standbyStartTime && currentTime <= standbyEndTime && (level = player.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.PROGRISING_STRASH.get(), SoundSource.PLAYERS, 1.8f, 1.0f);
                event.setAmount(event.getAmount() + 6.0f);
                LivingHurtHandler.stopStandbyTone(serverLevel, player);
            }
        }
    }

    private static void stopStandbyTone(ServerLevel serverLevel, Player player) {
        MinecraftServer server = serverLevel.m_7654_();
        if (server != null) {
            CommandSourceStack commandSourceStack = player.m_20203_().m_81324_();
            server.m_129892_().m_230957_(commandSourceStack, "/stopsound @s player kamen_rider_weapon_craft:pro_standby_tone");
        }
    }

    private static long getStandbyStartTime(Player player) {
        return player.getPersistentData().m_128454_("standbyStartTime");
    }

    private static void setStandbyStartTime(Player player, long time) {
        player.getPersistentData().m_128356_("standbyStartTime", time);
    }

    private static long getStandbyEndTime(Player player) {
        return player.getPersistentData().m_128454_("standbyEndTime");
    }

    private static void setStandbyEndTime(Player player, long time) {
        player.getPersistentData().m_128356_("standbyEndTime", time);
    }
}

