/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.event;

import com.xiaoshi2022.kamen_rider_weapon_craft.Item.custom.Heiseisword;
import com.xiaoshi2022.kamen_rider_weapon_craft.entity.ai.zombie.ZombieHeiseiswordController;
import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="kamen_rider_weapon_craft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ZombieHeiseiswordEventHandler {
    private static final String TAG_HEISEISWORD_ZOMBIE = "HeiseiswordZombie";

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinLevelEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            CompoundTag nbt = zombie.getPersistentData();
            ItemStack mainHandItem = zombie.m_21205_();
            if (mainHandItem.m_41720_() instanceof Heiseisword) {
                if (!ZombieHeiseiswordController.hasHeiseiswordGoal(zombie)) {
                    ZombieHeiseiswordController.addHeiseiswordGoal(zombie);
                }
                ZombieHeiseiswordEventHandler.setHeiseiswordHealth(zombie);
                nbt.m_128379_(TAG_HEISEISWORD_ZOMBIE, true);
            } else if (zombie.m_9236_().f_46441_.m_188501_() <= 0.03f && !zombie.m_6162_() && !nbt.m_128441_(TAG_HEISEISWORD_ZOMBIE) && !nbt.m_128441_("IsCustomSpawned")) {
                ItemStack heiseisword = new ItemStack((ItemLike)ModItems.HEISEISWORD.get());
                zombie.m_8061_(EquipmentSlot.MAINHAND, heiseisword);
                if (!ZombieHeiseiswordController.hasHeiseiswordGoal(zombie)) {
                    ZombieHeiseiswordController.addHeiseiswordGoal(zombie);
                }
                ZombieHeiseiswordEventHandler.setHeiseiswordHealth(zombie);
                nbt.m_128379_(TAG_HEISEISWORD_ZOMBIE, true);
            }
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Zombie) {
            Zombie zombie = (Zombie)livingEntity;
            if (event.getSlot().m_20743_() == EquipmentSlot.Type.HAND) {
                ItemStack newItem = event.getTo();
                ItemStack oldItem = event.getFrom();
                if (newItem.m_41720_() instanceof Heiseisword && !(oldItem.m_41720_() instanceof Heiseisword)) {
                    if (!ZombieHeiseiswordController.hasHeiseiswordGoal(zombie)) {
                        ZombieHeiseiswordController.addHeiseiswordGoal(zombie);
                    }
                    ZombieHeiseiswordEventHandler.setHeiseiswordHealth(zombie);
                } else if (!(newItem.m_41720_() instanceof Heiseisword) && oldItem.m_41720_() instanceof Heiseisword) {
                    ZombieHeiseiswordController.removeHeiseiswordGoal(zombie);
                    ZombieHeiseiswordEventHandler.restoreOriginalHealth(zombie);
                }
            }
        }
    }

    private static void setHeiseiswordHealth(Zombie zombie) {
        double originalSpeed;
        if (zombie.m_9236_().m_5776_()) {
            return;
        }
        CompoundTag nbt = zombie.getPersistentData();
        if (!nbt.m_128441_("OriginalHealth")) {
            double originalHealth = zombie.m_21051_(Attributes.f_22276_).m_22135_();
            nbt.m_128347_("OriginalHealth", originalHealth);
        }
        if (!nbt.m_128441_("OriginalMovementSpeed")) {
            originalSpeed = zombie.m_21051_(Attributes.f_22279_).m_22135_();
            nbt.m_128347_("OriginalMovementSpeed", originalSpeed);
        }
        if (!nbt.m_128441_("OriginalAttackDamage")) {
            double originalDamage = zombie.m_21051_(Attributes.f_22281_).m_22135_();
            nbt.m_128347_("OriginalAttackDamage", originalDamage);
        }
        zombie.m_21051_(Attributes.f_22276_).m_22100_(300.0);
        zombie.m_21153_(300.0f);
        originalSpeed = nbt.m_128459_("OriginalMovementSpeed");
        zombie.m_21051_(Attributes.f_22279_).m_22100_(originalSpeed * 1.8);
        double originalDamage = nbt.m_128459_("OriginalAttackDamage");
        zombie.m_21051_(Attributes.f_22281_).m_22100_(originalDamage * 2.5);
        nbt.m_128379_("IsZombieLeader", true);
    }

    private static void restoreOriginalHealth(Zombie zombie) {
        if (zombie.m_9236_().m_5776_()) {
            return;
        }
        CompoundTag nbt = zombie.getPersistentData();
        if (nbt.m_128441_("OriginalHealth")) {
            double originalHealth = nbt.m_128459_("OriginalHealth");
            zombie.m_21051_(Attributes.f_22276_).m_22100_(originalHealth);
            zombie.m_21153_((float)Math.min((double)zombie.m_21223_(), originalHealth));
            nbt.m_128473_("OriginalHealth");
        }
        if (nbt.m_128441_("OriginalMovementSpeed")) {
            double originalSpeed = nbt.m_128459_("OriginalMovementSpeed");
            zombie.m_21051_(Attributes.f_22279_).m_22100_(originalSpeed);
            nbt.m_128473_("OriginalMovementSpeed");
        }
        if (nbt.m_128441_("OriginalAttackDamage")) {
            double originalDamage = nbt.m_128459_("OriginalAttackDamage");
            zombie.m_21051_(Attributes.f_22281_).m_22100_(originalDamage);
            nbt.m_128473_("OriginalAttackDamage");
        }
        nbt.m_128473_("IsZombieLeader");
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDropsEvent event) {
        ItemStack mainHandItem;
        Zombie zombie;
        CompoundTag nbt;
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Zombie && (nbt = (zombie = (Zombie)livingEntity).getPersistentData()).m_128441_(TAG_HEISEISWORD_ZOMBIE) && nbt.m_128471_(TAG_HEISEISWORD_ZOMBIE) && (mainHandItem = zombie.m_21205_()).m_41720_() instanceof Heiseisword && !mainHandItem.m_41619_()) {
            ItemStack heiseiswordDrop = new ItemStack((ItemLike)ModItems.HEISEISWORD.get());
            if (mainHandItem.m_41782_()) {
                heiseiswordDrop.m_41751_(mainHandItem.m_41783_().m_6426_());
            }
            event.getDrops().add(new ItemEntity(zombie.m_9236_(), zombie.m_20185_(), zombie.m_20186_(), zombie.m_20189_(), heiseiswordDrop));
        }
    }
}

