/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.network;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.energy.HeiseiswordEnergyManager;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class HeiseiswordEnergySyncPacket {
    private final UUID playerUUID;
    private final double currentEnergy;
    private final double maxEnergy;

    public HeiseiswordEnergySyncPacket(Player player, double currentEnergy, double maxEnergy) {
        this.playerUUID = player.m_20148_();
        this.currentEnergy = currentEnergy;
        this.maxEnergy = maxEnergy;
    }

    public static void encode(HeiseiswordEnergySyncPacket msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.playerUUID);
        buf.writeDouble(msg.currentEnergy);
        buf.writeDouble(msg.maxEnergy);
    }

    public static HeiseiswordEnergySyncPacket decode(FriendlyByteBuf buf) {
        UUID playerUUID = buf.m_130259_();
        double currentEnergy = buf.readDouble();
        double maxEnergy = buf.readDouble();
        return new HeiseiswordEnergySyncPacket(playerUUID, currentEnergy, maxEnergy);
    }

    private HeiseiswordEnergySyncPacket(UUID playerUUID, double currentEnergy, double maxEnergy) {
        this.playerUUID = playerUUID;
        this.currentEnergy = currentEnergy;
        this.maxEnergy = maxEnergy;
    }

    public static void handle(HeiseiswordEnergySyncPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                HeiseiswordEnergySyncPacket.updateClientEnergy(msg.playerUUID, msg.currentEnergy, msg.maxEnergy);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void updateClientEnergy(UUID playerUUID, double currentEnergy, double maxEnergy) {
        Player player = Minecraft.m_91087_().f_91073_.m_46003_(playerUUID);
        if (player != null) {
            HeiseiswordEnergyManager.setCurrentEnergy(player, currentEnergy);
            HeiseiswordEnergyManager.setMaxEnergy(player, maxEnergy);
        }
    }
}

