/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.network;

import com.xiaoshi2022.kamen_rider_weapon_craft.Item.custom.HinawaDaidai_DJ_Ju;
import com.xiaoshi2022.kamen_rider_weapon_craft.Item.custom.progrise_hopper_blade;
import com.xiaoshi2022.kamen_rider_weapon_craft.Item.custom.sonicarrow;
import com.xiaoshi2022.kamen_rider_weapon_craft.network.NetworkHandler;
import com.xiaoshi2022.kamen_rider_weapon_craft.procedures.KRWBoot;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ServerSound {
    private static boolean isPlayingStandbySound = false;
    private final SoundType soundType;

    public ServerSound(SoundType soundType) {
        this.soundType = soundType;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.soundType);
    }

    public static ServerSound decode(FriendlyByteBuf buffer) {
        return new ServerSound((SoundType)buffer.m_130066_(SoundType.class));
    }

    public static void handle(ServerSound message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                switch (message.soundType) {
                    case START_STANDBY: {
                        isPlayingStandbySound = true;
                        break;
                    }
                    case STOP_STANDBY: {
                        isPlayingStandbySound = false;
                        break;
                    }
                    case BOOT: {
                        if (ServerSound.isHoldingItem((Player)player, sonicarrow.class)) {
                            KRWBoot.playSonicarrowBootSound(player);
                        }
                        if (ServerSound.isHoldingItem((Player)player, progrise_hopper_blade.class)) {
                            KRWBoot.playProgriseHopperBladeBoot(player);
                        }
                        if (!ServerSound.isHoldingItem((Player)player, HinawaDaidai_DJ_Ju.class)) break;
                        KRWBoot.playHinawaDaidaiDJJuBoot(player);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static boolean isHoldingItem(Player player, Class<?> itemClass) {
        return itemClass.isInstance(player.m_21205_().m_41720_()) || itemClass.isInstance(player.m_21206_().m_41720_());
    }

    public static boolean isPlayingStandbySound() {
        return isPlayingStandbySound;
    }

    public static void sendToServer(ServerSound message) {
        NetworkHandler.INSTANCE.sendToServer((Object)message);
    }

    public static enum SoundType {
        START_STANDBY,
        STOP_STANDBY,
        BOOT;

    }
}

