/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.xiaoshi2022.kamen_rider_weapon_craft.recipe.RiderFusionRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModRecipeSerializers
implements RecipeSerializer<RiderFusionRecipe> {
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"kamen_rider_weapon_craft");
    public static final RegistryObject<RecipeSerializer<RiderFusionRecipe>> RIDER_FUSION_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("rider_fusion_recipe_serializer", RiderFusionRecipe.Serializer::new);

    public RiderFusionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        if (recipeId == null) {
            throw new IllegalArgumentException("Recipe ID cannot be null");
        }
        System.out.println("[Recipe] Loading recipe from JSON: " + String.valueOf(recipeId));
        try {
            ItemStack output = json.has("output") && !json.get("output").isJsonNull() ? ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output")) : ItemStack.f_41583_;
            JsonObject ingredientsObj = GsonHelper.m_13930_((JsonObject)json, (String)"ingredients");
            NonNullList ingredients = NonNullList.m_122780_((int)4, (Object)Ingredient.f_43901_);
            int[] requiredCounts = new int[4];
            for (int slot = 0; slot < 4; ++slot) {
                String slotKey = String.valueOf(slot);
                if (!ingredientsObj.has(slotKey)) {
                    System.out.println("[Recipe] Missing slot definition: " + slot);
                    throw new JsonParseException("Missing ingredient definition for slot " + slot);
                }
                JsonObject slotObj = ingredientsObj.getAsJsonObject(slotKey);
                ingredients.set(slot, (Object)Ingredient.m_43917_((JsonElement)slotObj));
                requiredCounts[slot] = GsonHelper.m_13824_((JsonObject)slotObj, (String)"count", (int)1);
            }
            if (!json.has("fusion_time")) {
                System.out.println("[Recipe] Missing fusion time field");
                throw new JsonParseException("Missing required field 'fusion_time'");
            }
            int fusionTime = GsonHelper.m_13927_((JsonObject)json, (String)"fusion_time");
            return new RiderFusionRecipe(recipeId, output, (NonNullList<Ingredient>)ingredients, fusionTime, requiredCounts);
        }
        catch (Exception e) {
            System.out.println("[Recipe] JSON parsing failed: " + e.getMessage());
            throw e;
        }
    }

    public RiderFusionRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        if (recipeId == null) {
            throw new IllegalArgumentException("Recipe ID cannot be null");
        }
        System.out.println("[Recipe] Loading recipe from network: " + String.valueOf(recipeId));
        ItemStack output = buffer.m_130267_();
        if (output.m_41619_()) {
            output = ItemStack.f_41583_;
        }
        NonNullList ingredients = NonNullList.m_122780_((int)4, (Object)Ingredient.f_43901_);
        int[] requiredCounts = new int[4];
        for (int slot = 0; slot < 4; ++slot) {
            ingredients.set(slot, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            requiredCounts[slot] = buffer.readInt();
        }
        int fusionTime = buffer.readInt();
        return new RiderFusionRecipe(recipeId, output, (NonNullList<Ingredient>)ingredients, fusionTime, requiredCounts);
    }

    public void toNetwork(FriendlyByteBuf buffer, RiderFusionRecipe recipe) {
        System.out.println("[Recipe] Writing recipe to network: " + String.valueOf(recipe.getRecipeId()));
        buffer.writeItemStack(recipe.output, false);
        for (int slot = 0; slot < 4; ++slot) {
            ((Ingredient)recipe.m_7527_().get(slot)).m_43923_(buffer);
            buffer.writeInt(recipe.requiredCounts[slot]);
        }
        buffer.writeInt(recipe.getFusionTime());
    }
}

