/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.xiaoshi2022.kamen_rider_weapon_craft.recipe.ModRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class RiderFusionRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    final ItemStack output;
    private final NonNullList<Ingredient> ingredients;
    private final int fusionTime;
    final int[] requiredCounts;

    public RiderFusionRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> ingredients, int fusionTime, int[] requiredCounts) {
        if (id == null) {
            throw new IllegalArgumentException("Recipe ID cannot be null");
        }
        this.id = id;
        this.output = output;
        this.ingredients = ingredients;
        this.fusionTime = fusionTime;
        this.requiredCounts = requiredCounts;
        System.out.println("[Recipe] Created recipe: " + String.valueOf(id));
        System.out.println(" - Output: " + String.valueOf(output));
        System.out.println(" - Fusion time: " + fusionTime);
        for (int i = 0; i < ingredients.size(); ++i) {
            System.out.printf(" - Slot %d: %s x%d%n", i, ((Ingredient)ingredients.get(i)).m_43908_()[0], requiredCounts[i]);
        }
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public boolean m_5818_(Container inv, Level level) {
        System.out.println("[Recipe] Checking recipe match...");
        for (int slot = 0; slot < 4; ++slot) {
            ItemStack slotStack = inv.m_8020_(slot);
            Ingredient ingredient = (Ingredient)this.ingredients.get(slot);
            System.out.printf(" - Slot %d: Actual=%s x%d, Required=%s x%d%n", slot, slotStack.m_41720_().m_5524_(), slotStack.m_41613_(), ingredient.m_43908_()[0].m_41720_().m_5524_(), this.requiredCounts[slot]);
            if (!ingredient.test(slotStack)) {
                System.out.println("[Recipe] Item does not match: " + String.valueOf(slotStack));
                return false;
            }
            if (slotStack.m_41613_() >= this.requiredCounts[slot]) continue;
            System.out.println("[Recipe] Insufficient quantity: " + slotStack.m_41613_() + " < " + this.requiredCounts[slot]);
            return false;
        }
        System.out.println("[Recipe] Match successful");
        return true;
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        System.out.println("[Recipe] Assembling output item: " + String.valueOf(this.output));
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.RIDER_FUSION_RECIPE.get();
    }

    public int getFusionTime() {
        return this.fusionTime;
    }

    public int getRequiredCount(int slot) {
        return this.requiredCounts[slot];
    }

    public ResourceLocation getRecipeId() {
        return this.id;
    }

    public static class Serializer
    implements RecipeSerializer<RiderFusionRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public RiderFusionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            if (recipeId == null) {
                throw new IllegalArgumentException("Recipe ID cannot be null");
            }
            System.out.println("[Recipe] Loading recipe from JSON: " + String.valueOf(recipeId));
            try {
                ItemStack output = json.has("output") && !json.get("output").isJsonNull() ? ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output")) : ItemStack.f_41583_;
                JsonObject ingredientsObj = GsonHelper.m_13930_((JsonObject)json, (String)"ingredients");
                NonNullList ingredients = NonNullList.m_122780_((int)4, (Object)Ingredient.f_43901_);
                int[] requiredCounts = new int[4];
                for (int slot = 0; slot < 4; ++slot) {
                    String slotKey = String.valueOf(slot);
                    if (!ingredientsObj.has(slotKey)) {
                        System.out.println("[Recipe] Missing slot definition: " + slot);
                        throw new JsonParseException("Missing ingredient definition for slot " + slot);
                    }
                    JsonObject slotObj = ingredientsObj.getAsJsonObject(slotKey);
                    ingredients.set(slot, (Object)Ingredient.m_43917_((JsonElement)slotObj));
                    requiredCounts[slot] = GsonHelper.m_13824_((JsonObject)slotObj, (String)"count", (int)1);
                }
                if (!json.has("fusion_time")) {
                    System.out.println("[Recipe] Missing fusion time field");
                    throw new JsonParseException("Missing required field 'fusion_time'");
                }
                int fusionTime = GsonHelper.m_13927_((JsonObject)json, (String)"fusion_time");
                return new RiderFusionRecipe(recipeId, output, (NonNullList<Ingredient>)ingredients, fusionTime, requiredCounts);
            }
            catch (Exception e) {
                System.out.println("[Recipe] JSON parsing failed: " + e.getMessage());
                throw e;
            }
        }

        public RiderFusionRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            if (recipeId == null) {
                throw new IllegalArgumentException("Recipe ID cannot be null");
            }
            System.out.println("[Recipe] Loading recipe from network: " + String.valueOf(recipeId));
            ItemStack output = buffer.m_130267_();
            if (output.m_41619_()) {
                output = ItemStack.f_41583_;
            }
            NonNullList ingredients = NonNullList.m_122780_((int)4, (Object)Ingredient.f_43901_);
            int[] requiredCounts = new int[4];
            for (int slot = 0; slot < 4; ++slot) {
                ingredients.set(slot, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
                requiredCounts[slot] = buffer.readInt();
            }
            int fusionTime = buffer.readInt();
            return new RiderFusionRecipe(recipeId, output, (NonNullList<Ingredient>)ingredients, fusionTime, requiredCounts);
        }

        public void toNetwork(FriendlyByteBuf buffer, RiderFusionRecipe recipe) {
            System.out.println("[Recipe] Writing recipe to network: " + String.valueOf(recipe.getRecipeId()));
            buffer.writeItemStack(recipe.output, false);
            for (int slot = 0; slot < 4; ++slot) {
                ((Ingredient)recipe.m_7527_().get(slot)).m_43923_(buffer);
                buffer.writeInt(recipe.requiredCounts[slot]);
            }
            buffer.writeInt(recipe.getFusionTime());
        }
    }
}

