/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.HeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.HeiseiRiderEffectManager;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractHeiseiRiderEffect
implements HeiseiRiderEffect {
    private static final Random random = new Random();

    @Override
    public double getEnergyCost() {
        return 20.0;
    }

    @Override
    public void executeSpecialAttack(Level level, LivingEntity shooter, Vec3 direction) {
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            this.executePlayerSpecialAttack(level, player, direction);
        } else {
            this.executeNonPlayerSpecialAttack(level, shooter, direction);
        }
    }

    public void executeNonPlayerSpecialAttack(Level level, LivingEntity shooter, Vec3 direction) {
        if (!level.f_46443_) {
            HeiseiRiderEffectManager.playSelectionSound(level, shooter, this.getRiderName());
            HeiseiRiderEffectManager.playAttackSound(level, shooter, this.getRiderName());
            Vec3 attackDirection = direction != null && direction.m_82556_() > 0.0 ? direction.m_82541_() : shooter.m_20154_();
            float attackRange = this.getEffectRange();
            float width = attackRange / 2.0f;
            Vec3 start = shooter.m_20182_().m_82520_(0.0, (double)shooter.m_20192_() * 0.5, 0.0);
            Vec3 end = start.m_82549_(attackDirection.m_82490_((double)attackRange));
            AABB attackBox = new AABB(Math.min(start.f_82479_, end.f_82479_) - (double)width, Math.min(start.f_82480_, end.f_82480_) - 1.0, Math.min(start.f_82481_, end.f_82481_) - (double)width, Math.max(start.f_82479_, end.f_82479_) + (double)width, Math.max(start.f_82480_, end.f_82480_) + 1.0, Math.max(start.f_82481_, end.f_82481_) + (double)width);
            for (LivingEntity target : level.m_6443_(LivingEntity.class, attackBox, entity -> entity != shooter && entity != null && entity.m_6084_())) {
                Vec3 targetRelative = target.m_20182_().m_82546_(start);
                if (!(targetRelative.m_82526_(attackDirection) > 0.0)) continue;
                DamageSource damageSource = level.m_269111_().m_269333_(shooter);
                target.m_6469_(damageSource, this.getAttackDamage());
            }
            this.applyVisualEffects(level, shooter, attackDirection);
        }
    }

    protected void applyVisualEffects(Level level, LivingEntity shooter, Vec3 direction) {
        if (level.f_46443_) {
            for (int i = 0; i < 20; ++i) {
                double offsetX = random.nextGaussian() * 0.5;
                double offsetY = random.nextGaussian() * 0.5 + 1.0;
                double offsetZ = random.nextGaussian() * 0.5;
                Vec3 particlePos = shooter.m_20182_().m_82520_(offsetX, offsetY, offsetZ);
                Vec3 particleMotion = direction.m_82490_(0.5).m_82520_(random.nextGaussian() * 0.1, random.nextGaussian() * 0.1, random.nextGaussian() * 0.1);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, particleMotion.f_82479_, particleMotion.f_82480_, particleMotion.f_82481_);
            }
        } else {
            level.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11928_, SoundSource.HOSTILE, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
        }
    }

    public void executePlayerSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            HeiseiRiderEffectManager.playSelectionSound(level, (LivingEntity)player, this.getRiderName());
            HeiseiRiderEffectManager.playAttackSound(level, (LivingEntity)player, this.getRiderName());
            Vec3 attackDirection = direction != null && direction.m_82556_() > 0.0 ? direction.m_82541_() : player.m_20154_();
            float attackRange = this.getEffectRange();
            float width = attackRange / 2.0f;
            Vec3 start = player.m_20182_().m_82520_(0.0, (double)player.m_20192_() * 0.5, 0.0);
            Vec3 end = start.m_82549_(attackDirection.m_82490_((double)attackRange));
            AABB attackBox = new AABB(Math.min(start.f_82479_, end.f_82479_) - (double)width, Math.min(start.f_82480_, end.f_82480_) - 1.0, Math.min(start.f_82481_, end.f_82481_) - (double)width, Math.max(start.f_82479_, end.f_82479_) + (double)width, Math.max(start.f_82480_, end.f_82480_) + 1.0, Math.max(start.f_82481_, end.f_82481_) + (double)width);
            for (LivingEntity target : level.m_6443_(LivingEntity.class, attackBox, entity -> entity != player && entity != null && entity.m_6084_())) {
                Vec3 targetRelative = target.m_20182_().m_82546_(start);
                if (!(targetRelative.m_82526_(attackDirection) > 0.0)) continue;
                DamageSource damageSource = level.m_269111_().m_269075_(player);
                target.m_6469_(damageSource, this.getAttackDamage());
            }
            this.applyVisualEffects(level, (LivingEntity)player, attackDirection);
        }
    }

    @Override
    public abstract String getRiderName();

    @Override
    public abstract String getActivationSoundName();

    @Override
    public abstract float getAttackDamage();

    @Override
    public abstract float getEffectRange();
}

