/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.drive.DriveRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.drive.DriveRiderEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DriveEffect
extends AbstractHeiseiRiderEffect {
    @Override
    public void executePlayerSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 3));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 1));
            Vec3 velocity = direction.m_82490_(3.0);
            player.m_20256_(velocity);
            player.f_19789_ = 0.0f;
            level.m_7654_().execute(() -> {
                try {
                    Thread.sleep(100L);
                    this.executeSpeedAttack(level, player, direction);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
            DriveRiderEffect.spawnWheelEffectByOwnerDirection(level, (LivingEntity)player, this.getAttackDamage());
        }
    }

    @Override
    public void executeNonPlayerSpecialAttack(Level level, LivingEntity shooter, Vec3 direction) {
        if (!level.f_46443_) {
            Vec3 normalizedDirection = direction != null && direction.m_82556_() > 0.0 ? direction.m_82541_() : shooter.m_20154_().m_82541_();
            DriveRiderEntity.trySpawnEffect(level, shooter, normalizedDirection, this.getAttackDamage());
            level.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11977_, SoundSource.HOSTILE, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            shooter.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 2));
            double range = 10.0;
            Vec3 start = shooter.m_20182_().m_82520_(0.0, (double)shooter.m_20192_() * 0.5, 0.0);
            Vec3 end = start.m_82549_(normalizedDirection.m_82490_(range));
            AABB attackBox = new AABB(start, end).m_82377_(range / 2.0, 2.0, range / 2.0);
            level.m_6443_(LivingEntity.class, attackBox, entity -> {
                if (entity == shooter) {
                    return false;
                }
                Vec3 toEntity = entity.m_20182_().m_82546_(shooter.m_20182_()).m_82541_();
                return toEntity.m_82526_(normalizedDirection) > 0.5;
            }).forEach(entity -> entity.m_6469_(level.m_269111_().m_269333_(shooter), this.getAttackDamage() * 0.5f));
        }
    }

    private void executeSpeedAttack(Level level, Player player, Vec3 direction) {
        Vec3 normalizedDirection = direction.m_82541_();
        double range = 5.0;
        Vec3 start = player.m_20299_(1.0f);
        Vec3 end = start.m_82549_(normalizedDirection.m_82490_(range));
        AABB attackBox = new AABB(start, end).m_82377_(range / 2.0, 2.0, range / 2.0);
        level.m_6443_(LivingEntity.class, attackBox, entity -> {
            if (entity == player) {
                return false;
            }
            Vec3 toEntity = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_();
            return toEntity.m_82526_(normalizedDirection) > 0.5;
        }).forEach(entity -> {
            Vec3 relativeVelocity = entity.m_20184_().m_82546_(player.m_20184_());
            float damageFactor = (float)Math.min(1.0 + relativeVelocity.m_82553_() / 5.0, 2.0);
            entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * damageFactor);
        });
    }

    @Override
    public String getRiderName() {
        return "Drive";
    }

    @Override
    public String getActivationSoundName() {
        return "SpeeDemon!";
    }

    @Override
    public float getAttackDamage() {
        return 50.0f;
    }

    @Override
    public float getEffectRange() {
        return 15.0f;
    }
}

