/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.HeiseiRiderEffectManager;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.Faiz.FaizEmptySetEntity;
import java.util.Random;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class FaizEffect
extends AbstractHeiseiRiderEffect {
    private static final Random random = new Random();
    private static final Vector3f FAIZ_RED_COLOR = new Vector3f(1.0f, 0.0f, 0.0f);
    private static final DustParticleOptions RED_DUST = new DustParticleOptions(FAIZ_RED_COLOR, 2.5f);

    @Override
    public void executePlayerSpecialAttack(Level level, Player player, Vec3 direction) {
        this.spawnAttackParticles(level, player, direction);
        if (!level.f_46443_) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 3));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 1));
            double attackRange = this.getEffectRange();
            double width = attackRange / 2.0;
            Vec3 start = player.m_20299_(1.0f);
            Vec3 end = start.m_82549_(direction.m_82490_(attackRange));
            AABB attackBox = new AABB(Math.min(start.f_82479_, end.f_82479_) - width, Math.min(start.f_82480_, end.f_82480_) - 1.0, Math.min(start.f_82481_, end.f_82481_) - width, Math.max(start.f_82479_, end.f_82479_) + width, Math.max(start.f_82480_, end.f_82480_) + 1.0, Math.max(start.f_82481_, end.f_82481_) + width);
            level.m_6443_(LivingEntity.class, attackBox, entity -> entity != player && entity.m_6084_()).forEach(entity -> {
                Vec3 targetRelative = entity.m_20182_().m_82546_(start);
                if (targetRelative.m_82541_().m_82526_(direction.m_82541_()) > 0.7) {
                    float healthBefore = entity.m_21223_();
                    for (int i = 0; i < 3; ++i) {
                        entity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.4f);
                    }
                    if (entity.m_21224_()) {
                        this.spawnEmptySetParticleEffect(level, entity.m_20182_());
                    }
                }
            });
        }
    }

    private void spawnEmptySetParticleEffect(Level level, Vec3 position) {
        if (!level.f_46443_) {
            FaizEmptySetEntity emptySetEntity = new FaizEmptySetEntity(level, null);
            emptySetEntity.m_6034_(position.f_82479_, position.f_82480_ + 0.5, position.f_82481_);
            level.m_7967_((Entity)emptySetEntity);
        }
    }

    private void spawnVerticalEmptySetParticles(ServerLevel level, DustParticleOptions particle, Vec3 position) {
        int i;
        double centerX = position.f_82479_;
        double centerY = position.f_82480_ + 2.0;
        double centerZ = position.f_82481_;
        int circleParticles = 50;
        double radius = 1.2;
        for (int i2 = 0; i2 < circleParticles; ++i2) {
            double angle = Math.PI * 2 * (double)i2 / (double)circleParticles;
            double x = centerX + radius * Math.cos(angle);
            double z = centerZ + radius * Math.sin(angle);
            double y = centerY;
            double offsetX = (random.nextDouble() - 0.5) * 0.1;
            double offsetZ = (random.nextDouble() - 0.5) * 0.1;
            double motionX = (x - centerX) * 0.08;
            double motionZ = (z - centerZ) * 0.08;
            double motionY = 0.02;
            level.m_8767_((ParticleOptions)particle, x + offsetX, y, z + offsetZ, 1, motionX, motionY, motionZ, 0.05);
        }
        int lineParticles = 25;
        double lineLength = 1.8;
        for (i = 0; i < lineParticles; ++i) {
            double progress = (double)i / (double)(lineParticles - 1);
            double offset = (progress - 0.5) * lineLength;
            double x = centerX + offset * Math.cos(0.7853981633974483);
            double z = centerZ + offset * Math.sin(0.7853981633974483);
            double y = centerY;
            double motionX = (random.nextDouble() - 0.5) * 0.03;
            double motionZ = (random.nextDouble() - 0.5) * 0.03;
            double motionY = 0.03 + random.nextDouble() * 0.03;
            level.m_8767_((ParticleOptions)particle, x, y, z, 1, motionX, motionY, motionZ, 0.05);
        }
        for (i = 0; i < 20; ++i) {
            double sparkX = centerX + (random.nextDouble() - 0.5) * 0.5;
            double sparkY = centerY + (random.nextDouble() - 0.5) * 0.5;
            double sparkZ = centerZ + (random.nextDouble() - 0.5) * 0.5;
            double motionX = (random.nextDouble() - 0.5) * 0.1;
            double motionY = (random.nextDouble() - 0.5) * 0.1;
            double motionZ = (random.nextDouble() - 0.5) * 0.1;
            level.m_8767_((ParticleOptions)particle, sparkX, sparkY, sparkZ, 1, motionX, motionY, motionZ, 0.05);
        }
        for (int ring = 0; ring < 3; ++ring) {
            double ringRadius = 0.5 + (double)ring * 0.4;
            for (int i3 = 0; i3 < 20; ++i3) {
                double angle = Math.PI * 2 * (double)i3 / 20.0;
                double x = centerX + ringRadius * Math.cos(angle);
                double z = centerZ + ringRadius * Math.sin(angle);
                double y = centerY;
                double motionX = (x - centerX) * 0.15;
                double motionZ = (z - centerZ) * 0.15;
                double motionY = 0.05;
                level.m_8767_((ParticleOptions)particle, x, y, z, 1, motionX, motionY, motionZ, 0.05);
            }
        }
    }

    private void spawnVerticalEmptySetParticles(Level level, DustParticleOptions particle, Vec3 position) {
        int i;
        double centerX = position.f_82479_;
        double centerY = position.f_82480_ + 2.0;
        double centerZ = position.f_82481_;
        int circleParticles = 50;
        double radius = 1.2;
        for (int i2 = 0; i2 < circleParticles; ++i2) {
            double angle = Math.PI * 2 * (double)i2 / (double)circleParticles;
            double x = centerX + radius * Math.cos(angle);
            double z = centerZ + radius * Math.sin(angle);
            double y = centerY;
            double offsetX = (random.nextDouble() - 0.5) * 0.1;
            double offsetZ = (random.nextDouble() - 0.5) * 0.1;
            double motionX = (x - centerX) * 0.08;
            double motionZ = (z - centerZ) * 0.08;
            double motionY = 0.02;
            level.m_7106_((ParticleOptions)particle, x + offsetX, y, z + offsetZ, motionX, motionY, motionZ);
        }
        int lineParticles = 25;
        double lineLength = 1.8;
        for (i = 0; i < lineParticles; ++i) {
            double progress = (double)i / (double)(lineParticles - 1);
            double offset = (progress - 0.5) * lineLength;
            double x = centerX + offset * Math.cos(0.7853981633974483);
            double z = centerZ + offset * Math.sin(0.7853981633974483);
            double y = centerY;
            double motionX = (random.nextDouble() - 0.5) * 0.03;
            double motionZ = (random.nextDouble() - 0.5) * 0.03;
            double motionY = 0.03 + random.nextDouble() * 0.03;
            level.m_7106_((ParticleOptions)particle, x, y, z, motionX, motionY, motionZ);
        }
        for (i = 0; i < 20; ++i) {
            double sparkX = centerX + (random.nextDouble() - 0.5) * 0.5;
            double sparkY = centerY + (random.nextDouble() - 0.5) * 0.5;
            double sparkZ = centerZ + (random.nextDouble() - 0.5) * 0.5;
            double motionX = (random.nextDouble() - 0.5) * 0.1;
            double motionY = (random.nextDouble() - 0.5) * 0.1;
            double motionZ = (random.nextDouble() - 0.5) * 0.1;
            level.m_7106_((ParticleOptions)particle, sparkX, sparkY, sparkZ, motionX, motionY, motionZ);
        }
        for (int ring = 0; ring < 3; ++ring) {
            double ringRadius = 0.5 + (double)ring * 0.4;
            for (int i3 = 0; i3 < 20; ++i3) {
                double angle = Math.PI * 2 * (double)i3 / 20.0;
                double x = centerX + ringRadius * Math.cos(angle);
                double z = centerZ + ringRadius * Math.sin(angle);
                double y = centerY;
                double motionX = (x - centerX) * 0.15;
                double motionZ = (z - centerZ) * 0.15;
                double motionY = 0.05;
                level.m_7106_((ParticleOptions)particle, x, y, z, motionX, motionY, motionZ);
            }
        }
    }

    private void spawnAttackParticles(Level level, Player player, Vec3 direction) {
        for (int i = 0; i < 25; ++i) {
            double progress = (double)i / 25.0;
            Vec3 pos = player.m_20299_(1.0f).m_82549_(direction.m_82490_(progress * 5.0));
            double offsetX = (random.nextDouble() - 0.5) * 0.3;
            double offsetY = (random.nextDouble() - 0.5) * 0.3;
            double offsetZ = (random.nextDouble() - 0.5) * 0.3;
            double motionX = direction.f_82479_ * 0.2 + (random.nextDouble() - 0.5) * 0.1;
            double motionY = direction.f_82480_ * 0.2 + (random.nextDouble() - 0.5) * 0.1;
            double motionZ = direction.f_82481_ * 0.2 + (random.nextDouble() - 0.5) * 0.1;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)RED_DUST, pos.f_82479_ + offsetX, pos.f_82480_ + offsetY, pos.f_82481_ + offsetZ, 1, motionX, motionY, motionZ, 0.05);
                continue;
            }
            if (!level.f_46443_) continue;
            level.m_7106_((ParticleOptions)RED_DUST, pos.f_82479_ + offsetX, pos.f_82480_ + offsetY, pos.f_82481_ + offsetZ, motionX, motionY, motionZ);
        }
    }

    @Override
    public String getRiderName() {
        return "Faiz";
    }

    @Override
    public String getActivationSoundName() {
        return "Axel Form!";
    }

    @Override
    public float getAttackDamage() {
        return 48.0f;
    }

    @Override
    public float getEffectRange() {
        return 8.0f;
    }

    @Override
    public void executeNonPlayerSpecialAttack(Level level, LivingEntity shooter, Vec3 direction) {
        if (!level.f_46443_) {
            HeiseiRiderEffectManager.playSelectionSound(level, shooter, this.getRiderName());
            HeiseiRiderEffectManager.playAttackSound(level, shooter, this.getRiderName());
            Vec3 attackDirection = direction != null && direction.m_82556_() > 0.0 ? direction.m_82541_() : shooter.m_20154_();
            float attackRange = this.getEffectRange();
            float width = attackRange / 2.0f;
            Vec3 start = shooter.m_20182_().m_82520_(0.0, (double)shooter.m_20192_() * 0.5, 0.0);
            Vec3 end = start.m_82549_(attackDirection.m_82490_((double)attackRange));
            AABB attackBox = new AABB(Math.min(start.f_82479_, end.f_82479_) - (double)width, Math.min(start.f_82480_, end.f_82480_) - 1.0, Math.min(start.f_82481_, end.f_82481_) - (double)width, Math.max(start.f_82479_, end.f_82479_) + (double)width, Math.max(start.f_82480_, end.f_82480_) + 1.0, Math.max(start.f_82481_, end.f_82481_) + (double)width);
            for (LivingEntity target : level.m_6443_(LivingEntity.class, attackBox, entity -> entity != shooter && entity != null && entity.m_6084_())) {
                Vec3 targetRelative = target.m_20182_().m_82546_(start);
                if (!(targetRelative.m_82526_(attackDirection) > 0.0)) continue;
                float healthBefore = target.m_21223_();
                for (int i = 0; i < 3; ++i) {
                    DamageSource damageSource = level.m_269111_().m_269333_(shooter);
                    target.m_6469_(damageSource, this.getAttackDamage() * 0.4f);
                    if (!target.m_6084_()) break;
                }
                if (target.m_6084_()) continue;
                this.spawnEmptySetParticleEffect(level, target.m_20182_());
            }
        }
    }
}

