/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.ghost.GhostHeroicSoulEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GhostEffect
extends AbstractHeiseiRiderEffect {
    private final Random random = new Random();
    private final List<HeroicSoul> usedHeroicSouls = new ArrayList<HeroicSoul>();

    @Override
    public void executePlayerSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            ArrayList<HeroicSoul> availableSouls = new ArrayList<HeroicSoul>();
            for (HeroicSoul soul : HeroicSoul.values()) {
                if (this.usedHeroicSouls.contains((Object)soul)) continue;
                availableSouls.add(soul);
            }
            if (availableSouls.isEmpty()) {
                this.usedHeroicSouls.clear();
                availableSouls.addAll(List.of(HeroicSoul.values()));
            }
            HeroicSoul selectedSoul = (HeroicSoul)((Object)availableSouls.get(this.random.nextInt(availableSouls.size())));
            this.usedHeroicSouls.add(selectedSoul);
            this.spawnHeroicSoulEntity(level, player, direction, selectedSoul);
            this.executeHeroicSoulAbility(level, player, direction, selectedSoul);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 0));
        }
    }

    private void executeHeroicSoulAbility(Level level, Player player, Vec3 direction, HeroicSoul soul) {
        switch (soul) {
            case MUSASHI: {
                this.executeMusashiAbility(level, player, direction, this.getAttackDamage() * soul.getDamageMultiplier());
                break;
            }
            case EDISON: {
                this.executeEdisonAbility(level, player, direction, this.getAttackDamage() * soul.getDamageMultiplier());
                break;
            }
            case NEWTON: {
                this.executeNewtonAbility(level, player, direction, this.getAttackDamage() * soul.getDamageMultiplier());
            }
        }
    }

    private void executeMusashiAbility(Level level, Player player, Vec3 direction, float damage) {
        Vec3 start = player.m_20299_(1.0f);
        float attackRange = this.getEffectRange();
        Vec3 rightDirection = direction.m_82524_((float)Math.toRadians(20.0));
        Vec3 leftDirection = direction.m_82524_((float)Math.toRadians(-20.0));
        Vec3 rightEnd = start.m_82549_(rightDirection.m_82490_((double)attackRange));
        level.m_6443_(LivingEntity.class, new AABB(start, rightEnd).m_82400_(1.5), entity -> entity != player && entity.m_6084_()).forEach(entity -> {
            Vec3 targetRelative = entity.m_20182_().m_82546_(start);
            if (targetRelative.m_82541_().m_82526_(direction.m_82541_()) > 0.6) {
                entity.m_6469_(level.m_269111_().m_269075_(player), damage);
                entity.m_20254_(8);
            }
        });
        Vec3 leftEnd = start.m_82549_(leftDirection.m_82490_((double)attackRange));
        level.m_6443_(LivingEntity.class, new AABB(start, leftEnd).m_82400_(1.5), entity -> entity != player && entity.m_6084_()).forEach(entity -> {
            Vec3 targetRelative = entity.m_20182_().m_82546_(start);
            if (targetRelative.m_82541_().m_82526_(direction.m_82541_()) > 0.6) {
                entity.m_6469_(level.m_269111_().m_269075_(player), damage);
                entity.m_20254_(8);
            }
        });
    }

    private void executeEdisonAbility(Level level, Player player, Vec3 direction, float damage) {
        Vec3 start = player.m_20299_(1.0f);
        float attackRange = this.getEffectRange();
        float width = attackRange / 2.0f;
        Vec3 end = start.m_82549_(direction.m_82490_((double)attackRange));
        AABB attackBox = new AABB(Math.min(start.f_82479_, end.f_82479_) - (double)width, Math.min(start.f_82480_, end.f_82480_) - 2.0, Math.min(start.f_82481_, end.f_82481_) - (double)width, Math.max(start.f_82479_, end.f_82479_) + (double)width, Math.max(start.f_82480_, end.f_82480_) + 2.0, Math.max(start.f_82481_, end.f_82481_) + (double)width);
        level.m_6443_(LivingEntity.class, attackBox, entity -> entity != player && entity.m_6084_()).forEach(entity -> {
            Vec3 targetRelative = entity.m_20182_().m_82546_(start);
            if (targetRelative.m_82541_().m_82526_(direction.m_82541_()) > 0.7) {
                entity.m_6469_(level.m_269111_().m_269075_(player), damage);
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 1));
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 100, 0));
            }
        });
    }

    private void executeNewtonAbility(Level level, Player player, Vec3 direction, float damage) {
        Vec3 start = player.m_20299_(1.0f);
        float attackRange = this.getEffectRange();
        float width = attackRange / 2.0f;
        Vec3 center = start.m_82549_(direction.m_82490_(Math.min(6.0, (double)(attackRange / 2.0f))));
        AABB attackBox = new AABB(center.f_82479_ - (double)width, center.f_82480_ - 3.0, center.f_82481_ - (double)width, center.f_82479_ + (double)width, center.f_82480_ + 3.0, center.f_82481_ + (double)width);
        level.m_6443_(LivingEntity.class, attackBox, entity -> entity != player && entity.m_6084_()).forEach(entity -> {
            Vec3 targetRelative = entity.m_20182_().m_82546_(start);
            if (targetRelative.m_82541_().m_82526_(direction.m_82541_()) > 0.7) {
                Vec3 attraction = center.m_82546_(entity.m_20182_()).m_82541_().m_82490_(0.3);
                entity.m_20256_(entity.m_20184_().m_82549_(attraction));
                entity.m_6469_(level.m_269111_().m_269075_(player), damage);
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 2));
            }
        });
    }

    private void spawnHeroicSoulEntity(Level level, Player player, Vec3 direction, HeroicSoul soul) {
        GhostHeroicSoulEntity.trySpawnEffect(level, player, direction, soul.getColor(), this.getAttackDamage() * soul.getDamageMultiplier(), soul.isFireDamage(), soul.name());
    }

    @Override
    public String getRiderName() {
        return "Ghost";
    }

    @Override
    public String getActivationSoundName() {
        return "Omega Drive!";
    }

    @Override
    public float getAttackDamage() {
        return 49.0f;
    }

    @Override
    public float getEffectRange() {
        return 15.0f;
    }

    @Override
    public void executeNonPlayerSpecialAttack(Level level, LivingEntity shooter, Vec3 direction) {
        if (!level.f_46443_) {
            GhostHeroicSoulEntity.trySpawnEffect(level, shooter, direction, -16711681, this.getAttackDamage() / 3.0f, false, "specter");
            level.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_12404_, SoundSource.HOSTILE, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            shooter.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 100, 0));
        }
    }

    private static enum HeroicSoul {
        MUSASHI("Musashi", 16729344, 1.2f, 18, true),
        EDISON("Edison", 0xFFFF00, 1.1f, 18, false),
        NEWTON("Newton", 2003199, 1.0f, 18, false);

        private final String name;
        private final int color;
        private final float damageMultiplier;
        private final int entityModelId;
        private final boolean isFireDamage;

        private HeroicSoul(String name, int color, float damageMultiplier, int entityModelId, boolean isFireDamage) {
            this.name = name;
            this.color = color;
            this.damageMultiplier = damageMultiplier;
            this.entityModelId = entityModelId;
            this.isFireDamage = isFireDamage;
        }

        public String getName() {
            return this.name;
        }

        public int getColor() {
            return this.color;
        }

        public float getDamageMultiplier() {
            return this.damageMultiplier;
        }

        public int getEntityModelId() {
            return this.entityModelId;
        }

        public boolean isFireDamage() {
            return this.isFireDamage;
        }
    }
}

