/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.impl;

import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.AbstractHeiseiRiderEffect;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.effect.HeiseiRiderEffectManager;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RyukiEffect
extends AbstractHeiseiRiderEffect {
    @Override
    public void executePlayerSpecialAttack(Level level, Player player, Vec3 direction) {
        if (!level.f_46443_) {
            this.addFireResistance(player);
            RyukiCard selectedCard = RyukiCard.values()[level.f_46441_.m_188503_(RyukiCard.values().length)];
            switch (selectedCard) {
                case SwordVent: {
                    this.executeSwordVent(level, player, direction);
                    break;
                }
                case ShootVent: {
                    this.executeShootVent(level, player, direction);
                    break;
                }
                case GuardVent: {
                    this.executeGuardVent(level, player, direction);
                    break;
                }
                case StrikeVent: {
                    this.executeStrikeVent(level, player, direction);
                    break;
                }
                case FinalVent: {
                    this.executeFinalVent(level, player, direction);
                }
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 600, 0));
        }
    }

    private void executeSwordVent(Level level, Player player, Vec3 direction) {
        EntityHitResult entityHitResult;
        Entity entity;
        double reach = this.getEffectRange();
        Vec3 normalizedDirection = direction.m_82541_();
        HitResult result = player.m_19907_(reach, 0.0f, false);
        if (result instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)result).m_82443_()) instanceof LivingEntity) {
            Vec3 toEntity;
            double dotProduct;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity != player && (dotProduct = (toEntity = livingEntity.m_20182_().m_82546_(player.m_20182_()).m_82541_()).m_82526_(normalizedDirection)) > 0.5) {
                livingEntity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage());
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1));
                livingEntity.m_20254_(5);
            }
        }
    }

    private void executeShootVent(Level level, Player player, Vec3 direction) {
        Vec3 normalizedDirection = direction.m_82541_();
        double maxReach = 15.0;
        Vec3 start = player.m_20299_(1.0f);
        Vec3 end = start.m_82549_(normalizedDirection.m_82490_(maxReach));
        AABB attackBox = new AABB(start, end).m_82400_(2.0);
        level.m_6443_(LivingEntity.class, attackBox, entity -> {
            if (entity == player) {
                return false;
            }
            Vec3 toEntity = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_();
            return toEntity.m_82526_(normalizedDirection) > 0.5;
        }).forEach(livingEntity -> {
            livingEntity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.3f);
            livingEntity.m_20254_(7);
        });
        for (int i = 0; i < 5; ++i) {
            double angleOffset = (double)(i - 2) * Math.PI / 12.0;
            Vec3 vec3 = new Vec3(Math.cos(angleOffset) * direction.f_82479_ - Math.sin(angleOffset) * direction.f_82481_, direction.f_82480_ + (level.f_46441_.m_188500_() - 0.5) * 0.3, Math.sin(angleOffset) * direction.f_82479_ + Math.cos(angleOffset) * direction.f_82481_).m_82541_();
        }
    }

    private void executeGuardVent(Level level, Player player, Vec3 direction) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 2));
        Vec3 normalizedDirection = direction.m_82541_();
        double range = this.getEffectRange();
        Vec3 start = player.m_20299_(1.0f);
        Vec3 end = start.m_82549_(normalizedDirection.m_82490_(range));
        AABB attackBox = new AABB(start, end).m_82377_(range / 2.0, 2.0, range / 2.0);
        level.m_6443_(LivingEntity.class, attackBox, entity -> {
            if (entity == player) {
                return false;
            }
            Vec3 toEntity = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_();
            return toEntity.m_82526_(normalizedDirection) > 0.5;
        }).forEach(entity -> entity.m_6469_(level.m_269111_().m_269374_((Entity)player), this.getAttackDamage() * 0.3f));
    }

    private void executeStrikeVent(Level level, Player player, Vec3 direction) {
        Vec3 normalizedDirection = direction.m_82541_();
        double range = this.getEffectRange();
        Vec3 start = player.m_20299_(1.0f);
        Vec3 end = start.m_82549_(normalizedDirection.m_82490_(range));
        AABB attackBox = new AABB(start, end).m_82377_(range / 2.0, 2.0, range / 2.0);
        level.m_6443_(LivingEntity.class, attackBox, entity -> {
            if (entity == player) {
                return false;
            }
            Vec3 toEntity = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_();
            return toEntity.m_82526_(normalizedDirection) > 0.5;
        }).forEach(livingEntity -> {
            livingEntity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 0.6f);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 100, 1));
            livingEntity.m_20254_(5);
        });
    }

    private void executeFinalVent(Level level, Player player, Vec3 direction) {
        Vec3 normalizedDirection = direction.m_82541_();
        double range = this.getEffectRange();
        Vec3 targetPos = player.m_20299_(1.0f).m_82549_(normalizedDirection.m_82490_(range));
        level.m_254849_((Entity)player, targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, (float)(range / 2.0), Level.ExplosionInteraction.NONE);
        AABB attackBox = new AABB(targetPos, targetPos).m_82400_(4.0);
        level.m_6443_(LivingEntity.class, attackBox, entity -> {
            if (entity == player) {
                return false;
            }
            Vec3 toEntity = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_();
            return toEntity.m_82526_(normalizedDirection) > 0.5;
        }).forEach(livingEntity -> {
            livingEntity.m_6469_(level.m_269111_().m_269075_(player), this.getAttackDamage() * 1.5f);
            Vec3 knockback = normalizedDirection.m_82490_(2.0);
            livingEntity.m_20256_(livingEntity.m_20184_().m_82549_(knockback));
            livingEntity.m_20254_(10);
        });
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 5));
    }

    @Override
    public String getRiderName() {
        return "Ryuki";
    }

    @Override
    public String getActivationSoundName() {
        return "Dragon Rider Kick!";
    }

    @Override
    public float getAttackDamage() {
        return 47.0f;
    }

    @Override
    public float getEffectRange() {
        return 8.0f;
    }

    public void executeFireballAttack(Level level, LivingEntity shooter, Vec3 direction) {
        if (!level.f_46443_) {
            HeiseiRiderEffectManager.playAttackSound(level, shooter, this.getRiderName());
            Vec3 fireballDirection = direction != null && direction.m_82556_() > 0.0 ? direction.m_82541_() : shooter.m_20154_();
            SmallFireball fireball = new SmallFireball(level, shooter, fireballDirection.f_82479_ * 1.5, fireballDirection.f_82480_ * 1.5, fireballDirection.f_82481_ * 1.5);
            fireball.m_6034_(shooter.m_20185_() + fireballDirection.f_82479_ * 0.5, shooter.m_20188_() - 0.3 + fireballDirection.f_82480_ * 0.5, shooter.m_20189_() + fireballDirection.f_82481_ * 0.5);
            fireball.f_36813_ = fireballDirection.f_82479_ * 1.5;
            fireball.f_36814_ = fireballDirection.f_82480_ * 1.5;
            fireball.f_36815_ = fireballDirection.f_82481_ * 1.5;
            level.m_7967_((Entity)fireball);
        }
    }

    private void addFireResistance(Player player) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 600, 0));
    }

    @Override
    public void executeNonPlayerSpecialAttack(Level level, LivingEntity shooter, Vec3 direction) {
        if (!level.f_46443_) {
            if (shooter instanceof Mob) {
                shooter.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 600, 0));
            }
            this.executeFireballAttack(level, shooter, direction);
        }
    }

    private static enum RyukiCard {
        SwordVent,
        ShootVent,
        GuardVent,
        StrikeVent,
        FinalVent;

    }
}

