/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.energy;

import com.mojang.blaze3d.systems.RenderSystem;
import com.xiaoshi2022.kamen_rider_weapon_craft.Item.custom.Heiseisword;
import com.xiaoshi2022.kamen_rider_weapon_craft.rider.energy.HeiseiswordEnergyManager;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class HeiseiswordEnergyRenderer {
    private static final int BAR_WIDTH = 64;
    private static final int BAR_HEIGHT = 64;
    private static final int HUD_RIGHT_OFFSET = 20;
    private static final int HUD_BOTTOM_OFFSET = 30;
    private static final ResourceLocation BAR_BACKGROUND = new ResourceLocation("kamen_rider_weapon_craft:textures/gui/heiseisword_bar_background.png");
    private static final ResourceLocation BAR_FILL = new ResourceLocation("kamen_rider_weapon_craft:textures/gui/heiseisword_bar_fill.png");
    private static final ResourceLocation BAR_OVERLAY = new ResourceLocation("kamen_rider_weapon_craft:textures/gui/heiseisword_bar_overlay.png");
    public static final IGuiOverlay RENDER_ENERGY_BAR = (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (!(player.m_21205_().m_41720_() instanceof Heiseisword)) {
            return;
        }
        double currentEnergy = HeiseiswordEnergyManager.getCurrentEnergy((Player)player);
        double maxEnergy = HeiseiswordEnergyManager.getMaxEnergy((Player)player);
        double energyPercentage = currentEnergy / maxEnergy;
        energyPercentage = Math.max(0.0, Math.min(1.0, energyPercentage));
        int barX = screenWidth - 20 - 64;
        int barY = screenHeight - 30 - 64;
        RenderSystem.enableBlend();
        try {
            guiGraphics.m_280163_(BAR_BACKGROUND, barX, barY, 0.0f, 0.0f, 64, 64, 64, 64);
        }
        catch (Exception e) {
            guiGraphics.m_280509_(barX, barY, barX + 64, barY + 64, Integer.MIN_VALUE);
        }
        int fillHeight = (int)(64.0 * energyPercentage);
        int fillY = barY + (64 - fillHeight);
        if (fillHeight > 0) {
            try {
                guiGraphics.m_280163_(BAR_FILL, barX, fillY, 0.0f, (float)(64 - fillHeight), 64, fillHeight, 64, 64);
            }
            catch (Exception e) {
                guiGraphics.m_280509_(barX, fillY, barX + 64, barY + 64, -2147418368);
            }
        }
        try {
            guiGraphics.m_280163_(BAR_OVERLAY, barX, barY, 0.0f, 0.0f, 64, 64, 64, 64);
        }
        catch (Exception e) {
            guiGraphics.m_280509_(barX, barY, barX + 1, barY + 64, -1);
            guiGraphics.m_280509_(barX + 64 - 1, barY, barX + 64, barY + 64, -1);
            guiGraphics.m_280509_(barX, barY, barX + 64, barY + 1, -1);
            guiGraphics.m_280509_(barX, barY + 64 - 1, barX + 64, barY + 64, -1);
            String percentageText = String.format("%.0f%%", energyPercentage * 100.0);
            Font font = gui.m_93082_();
            int n = barX + 32 - gui.m_93082_().m_92895_(percentageText) / 2;
            Objects.requireNonNull(gui.m_93082_());
            guiGraphics.m_280056_(font, percentageText, n, barY + 32 - 9 / 2, -1, true);
        }
        RenderSystem.disableBlend();
    };
}

