/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoshi2022.kamen_rider_weapon_craft.rider.heisei.Faiz;

import com.xiaoshi2022.kamen_rider_weapon_craft.registry.ModEntityTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FaizEmptySetEntity
extends Entity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation APPEAR_ANIMATION = RawAnimation.begin().then("appear", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().then("idle", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation DISAPPEAR_ANIMATION = RawAnimation.begin().then("disappear", Animation.LoopType.PLAY_ONCE);
    private static final EntityDataAccessor<Integer> LIFETIME = SynchedEntityData.m_135353_(FaizEmptySetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int MAX_LIFETIME = 40;

    public FaizEmptySetEntity(EntityType<? extends FaizEmptySetEntity> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
        this.m_20331_(true);
    }

    public FaizEmptySetEntity(Level level, LivingEntity enemy) {
        super((EntityType)ModEntityTypes.FAIZ_EMPTY_SET.get(), level);
        this.f_19794_ = true;
        this.m_20331_(true);
        if (enemy != null) {
            this.m_6034_(enemy.m_20185_(), enemy.m_20186_() + (double)enemy.m_20206_() * 0.5, enemy.m_20189_());
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(LIFETIME, (Object)40);
    }

    protected void m_7378_(CompoundTag compound) {
        this.f_19804_.m_135381_(LIFETIME, (Object)compound.m_128451_("Lifetime"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Lifetime", ((Integer)this.f_19804_.m_135370_(LIFETIME)).intValue());
    }

    public void m_8119_() {
        super.m_8119_();
        int currentLifetime = (Integer)this.f_19804_.m_135370_(LIFETIME) - 1;
        this.f_19804_.m_135381_(LIFETIME, (Object)currentLifetime);
        if (currentLifetime <= 0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private PlayState predicate(AnimationState<FaizEmptySetEntity> event) {
        int lifetime = (Integer)this.f_19804_.m_135370_(LIFETIME);
        if (lifetime > 30) {
            event.getController().setAnimation(APPEAR_ANIMATION);
        } else if (lifetime > 10) {
            event.getController().setAnimation(IDLE_ANIMATION);
        } else {
            event.getController().setAnimation(DISAPPEAR_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6094_() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationProgress() {
        return 1.0f - (float)((Integer)this.f_19804_.m_135370_(LIFETIME)).intValue() / 40.0f;
    }

    public int getRemainingTicks() {
        return (Integer)this.f_19804_.m_135370_(LIFETIME);
    }

    public int getMaxTicks() {
        return 40;
    }

    public boolean isDisappearing() {
        return (Integer)this.f_19804_.m_135370_(LIFETIME) <= 10;
    }

    public boolean isAppearing() {
        return (Integer)this.f_19804_.m_135370_(LIFETIME) > 30;
    }
}

